/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisServlet;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;

public class JAxisServlet
extends AxisServlet {
    private static final long serialVersionUID = 8738737484808995721L;

    protected void reportAvailableServices(HttpServletResponse response, PrintWriter writer, HttpServletRequest request) throws ConfigurationException, AxisFault {
        Iterator i;
        AxisServer engine = this.getEngine();
        response.setContentType("text/html; charset=utf-8");
        writer.println("<h2>And now... Some Services</h2>");
        try {
            i = engine.getConfig().getDeployedServices();
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configException.getContainedException();
            }
            throw configException;
        }
        AxisServer axisServer = this.getEngine();
        ServiceDesc serviceDesc = null;
        try {
            InitialContext iCtx = new InitialContext();
            serviceDesc = (ServiceDesc)iCtx.lookup("java:comp/jonas/" + axisServer.getName() + "/dd");
        }
        catch (NamingException e) {
            log.debug("Cannot find ServiceDesc in context 'java:comp/jonas/" + axisServer.getName() + "/dd'", e);
            throw new AxisFault("Servlet name not found : " + axisServer.getName(), e);
        }
        writer.println("<ul>");
        while (i.hasNext()) {
            org.apache.axis.description.ServiceDesc sd = (org.apache.axis.description.ServiceDesc)i.next();
            StringBuffer sb = new StringBuffer();
            sb.append("<li>");
            String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            String endpointURL = null;
            QName portName = this.getWsdlPortName(serviceDesc, name);
            try {
                endpointURL = serviceDesc.getWSDL().getLocation(portName).toExternalForm();
            }
            catch (WSDeploymentDescException e) {
                throw new AxisFault("Cannot find endpoint URL for server " + axisServer.getName() + " and port " + name, e);
            }
            sb.append(endpointURL);
            sb.append("?jwsdl\"><i>(wsdl)</i></a></li>");
            writer.println(sb.toString());
            ArrayList operations = sd.getOperations();
            if (operations.isEmpty()) continue;
            writer.println("<ul>");
            for (OperationDesc desc : operations) {
                writer.println("<li>" + desc.getName());
            }
            writer.println("</ul>");
        }
        writer.println("</ul>");
    }

    private QName getWsdlPortName(ServiceDesc serviceDesc, String axisServiceName) {
        QName wsdlPortName = null;
        Iterator p = serviceDesc.getPortComponents().iterator();
        while (p.hasNext() || wsdlPortName == null) {
            PortComponentDesc pcd = (PortComponentDesc)p.next();
            if (!axisServiceName.equals(pcd.getServiceName())) continue;
            wsdlPortName = pcd.getQName();
        }
        return wsdlPortName;
    }
}

