/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.ow2.jonas.ws.cxf.http.JOnASHTTPTransportFactory;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class BusCreator {
    private static Log logger = LogFactory.getLog(BusCreator.class);

    public Bus initBus() {
        IExecution<Bus> createBusJob = new IExecution<Bus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Bus execute() throws Exception {
                Bus newBus;
                Level old = org.ow2.jonas.lib.util.Log.setComponentLogLevel("org.apache.cxf", BasicLevel.LEVEL_ERROR);
                Level old2 = org.ow2.jonas.lib.util.Log.setComponentLogLevel("org.springframework", BasicLevel.LEVEL_ERROR);
                PrintStream previousErrorStream = System.err;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream tempStream = new PrintStream(baos);
                System.setErr(tempStream);
                try {
                    newBus = BusFactory.newInstance().createBus();
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    System.setErr(previousErrorStream);
                    String errorMessage = baos.toString();
                    if (errorMessage != null && errorMessage.contains("java.net.UnknownHostException")) {
                        logger.debug("Error while initializing the Bus : ''{0}'' ", errorMessage);
                    } else if (!"".equals(errorMessage)) {
                        logger.error("Error while initializing the Bus : ''{0}'' ", errorMessage);
                    }
                    org.ow2.jonas.lib.util.Log.setComponentLogLevel("org.apache.cxf", old);
                    org.ow2.jonas.lib.util.Log.setComponentLogLevel("org.springframework", old2);
                    throw throwable;
                }
                System.setErr(previousErrorStream);
                String errorMessage = baos.toString();
                if (errorMessage != null && errorMessage.contains("java.net.UnknownHostException")) {
                    logger.debug("Error while initializing the Bus : ''{0}'' ", errorMessage);
                } else if (!"".equals(errorMessage)) {
                    logger.error("Error while initializing the Bus : ''{0}'' ", errorMessage);
                }
                org.ow2.jonas.lib.util.Log.setComponentLogLevel("org.apache.cxf", old);
                org.ow2.jonas.lib.util.Log.setComponentLogLevel("org.springframework", old2);
                return newBus;
            }
        };
        ExecutionResult res = new RunnableHelper().execute(Bus.class.getClassLoader(), (IExecution)createBusJob);
        if (res.hasException()) {
            logger.error("Cannot create Bus", res.getException());
        }
        Bus bus = (Bus)res.getResult();
        try {
            this.createDestinationFactory(bus);
        }
        catch (BusException e) {
            logger.error("Cannot create destination factory", e);
        }
        return bus;
    }

    private void createDestinationFactory(Bus bus) throws BusException {
        JOnASHTTPTransportFactory factory = new JOnASHTTPTransportFactory(bus);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("http://schemas.xmlsoap.org/wsdl/soap/http");
        namespaces.add("http://schemas.xmlsoap.org/soap/http");
        namespaces.add("http://schemas.xmlsoap.org/wsdl/http/");
        namespaces.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        namespaces.add("http://cxf.apache.org/transports/http/configuration");
        namespaces.add("http://cxf.apache.org/bindings/xformat");
        factory.setTransportIds(namespaces);
        for (String ns : namespaces) {
            this.registerTransport(bus, factory, ns);
        }
    }

    private void registerTransport(Bus bus, DestinationFactory factory, String namespace) throws BusException {
        DestinationFactoryManager manager = bus.getExtension(DestinationFactoryManager.class);
        manager.registerDestinationFactory(namespace, factory);
    }
}

