/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.servlet.ServletContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.version.Version;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.ws.cxf.JOnASJaxWsImplementorInfo;
import org.ow2.jonas.ws.cxf.JOnASJaxWsServerFactoryBean;
import org.ow2.jonas.ws.cxf.easybeans.ext.WebServiceContextInjectionHandler;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.IWebservicesModule;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.base.JAXWSService;
import org.ow2.jonas.ws.jaxws.base.JAXWSWebservicesModule;
import org.ow2.jonas.ws.jaxws.client.JAXWSWebServiceRefBuilder;
import org.ow2.jonas.ws.jaxws.easybeans.naming.WebServiceRefExtensionListener;
import org.ow2.jonas.ws.jaxws.handler.builder.DescriptorHandlerChainBuilder;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.WSDLPublisherManager;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.ws.api.struct.IWebServiceMarker;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFService
extends JAXWSService
implements IJAXWSService {
    private Bus clientBus;
    private static org.ow2.util.log.Log logger = LogFactory.getLog(CXFService.class);
    private IEventService eventService;
    private WebServiceRefExtensionListener listener;
    private Map<String, IWebservicesModule<WebservicesContainer<CXFWSEndpoint>>> webservicesModules = new HashMap<String, IWebservicesModule<WebservicesContainer<CXFWSEndpoint>>>();
    private WSDLPublisherManager publisherManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws ServiceException {
        Level old = Log.setComponentLogLevel("org.apache.cxf", BasicLevel.LEVEL_ERROR);
        Level old2 = Log.setComponentLogLevel("org.springframework", BasicLevel.LEVEL_ERROR);
        PrintStream previousErrorStream = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream tempStream = new PrintStream(baos);
        System.setErr(tempStream);
        try {
            this.clientBus = BusFactory.getDefaultBus();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            System.setErr(previousErrorStream);
            String errorMessage = baos.toString();
            if (errorMessage != null && errorMessage.contains("java.net.UnknownHostException")) {
                logger.debug("Error while initializing the Bus : ''{0}'' ", errorMessage);
            } else if (!"".equals(errorMessage)) {
                logger.error("Error while initializing the Bus : ''{0}'' ", errorMessage);
            }
            Log.setComponentLogLevel("org.apache.cxf", old);
            Log.setComponentLogLevel("org.springframework", old2);
            throw throwable;
        }
        System.setErr(previousErrorStream);
        String errorMessage = baos.toString();
        if (errorMessage != null && errorMessage.contains("java.net.UnknownHostException")) {
            logger.debug("Error while initializing the Bus : ''{0}'' ", errorMessage);
        } else if (!"".equals(errorMessage)) {
            logger.error("Error while initializing the Bus : ''{0}'' ", errorMessage);
        }
        Log.setComponentLogLevel("org.apache.cxf", old);
        Log.setComponentLogLevel("org.springframework", old2);
        System.setProperty("javax.xml.ws.spi.Provider", ProviderImpl.class.getName());
        super.doStart();
        logger.info("{0} started", Version.getCompleteVersionString());
    }

    @Override
    protected void doStop() throws ServiceException {
        Level old = Log.setComponentLogLevel("org.apache.cxf", BasicLevel.LEVEL_ERROR);
        Level old2 = Log.setComponentLogLevel("org.springframework", BasicLevel.LEVEL_ERROR);
        this.clientBus.shutdown(true);
        this.clientBus = null;
        BusFactory.setDefaultBus(null);
        Log.setComponentLogLevel("org.apache.cxf", old);
        Log.setComponentLogLevel("org.springframework", old2);
        super.doStop();
        logger.info("CXF service stopped", new Object[0]);
    }

    @Override
    public Reference createNamingReference(IJaxwsWebServiceRef serviceRef) throws NamingException {
        JAXWSWebServiceRefBuilder builder = new JAXWSWebServiceRefBuilder();
        return builder.build(serviceRef);
    }

    @Override
    public IWebServiceEndpoint createPOJOWebServiceEndpoint(IWarClassMetadata metadata, ClassLoader loader, ServletContext servletContext) throws WSException {
        String name = this.findUniqueContextName(servletContext);
        IWebservicesModule<WebservicesContainer<CXFWSEndpoint>> module = this.webservicesModules.get(name);
        if (module == null) {
            module = new JAXWSWebservicesModule<WebservicesContainer<CXFWSEndpoint>>(name);
            this.webservicesModules.put(name, module);
        }
        String classname = metadata.getJClass().getName().replace('/', '.');
        Class<?> klass = null;
        try {
            klass = loader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new WSException("Impossible to load the WebService class", e);
        }
        IWebServiceMarker marker = metadata.getWebServiceMarker();
        JOnASJaxWsImplementorInfo jaxWsImplementorInfo = new JOnASJaxWsImplementorInfo(klass, marker);
        WebservicesContainer<CXFWSEndpoint> container = module.findContainer(jaxWsImplementorInfo.getWsdlLocation());
        if (container == null) {
            container = new WebservicesContainer(jaxWsImplementorInfo.getWsdlLocation());
            module.addContainer(container);
            ResourceManager manager = container.getBus().getExtension(ResourceManager.class);
            manager.addResourceResolver(new ServletContextResourceResolver(servletContext));
        }
        EndpointImpl ep = this.createEndpointImpl(container.getBus(), klass, jaxWsImplementorInfo, marker);
        String serviceName = jaxWsImplementorInfo.getServiceName().getLocalPart();
        String pattern = null;
        pattern = !"".equals(serviceName) ? "/" + serviceName : "/" + klass.getSimpleName() + "Service";
        PortMetaData pmd = new PortMetaData();
        pmd.setUrlPattern(pattern);
        logger.debug("PortMetaData [pattern:{0}]", pmd.getUrlPattern());
        CXFWSEndpoint endpoint = new CXFWSEndpoint(ep, IWebServiceEndpoint.EndpointType.POJO, pmd, container);
        container.addEndpoint(endpoint);
        return endpoint;
    }

    private String findUniqueContextName(ServletContext context) {
        return context.getRealPath("/");
    }

    private EndpointImpl createEndpointImpl(Bus bus, Class<?> klass, JOnASJaxWsImplementorInfo info, IWebServiceMarker serviceMarker) throws WSException {
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = new JaxWsServiceFactoryBean(info);
        jaxWsServiceFactoryBean.setBus(bus);
        this.checkEnableMtom(jaxWsServiceFactoryBean, info);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Object implementor = null;
        try {
            try {
                Thread.currentThread().setContextClassLoader(klass.getClassLoader());
                jaxWsServiceFactoryBean.create();
                implementor = klass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new WSException("Cannot access '" + klass.getName() + "'", e);
            }
            catch (InstantiationException e) {
                throw new WSException("Cannot instantiate '" + klass.getName() + "'", e);
            }
            Object var10_8 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
        JOnASJaxWsServerFactoryBean factoryBean = new JOnASJaxWsServerFactoryBean(jaxWsServiceFactoryBean);
        IHandlerChains handlerChains = serviceMarker.getHandlerChains();
        if (handlerChains != null) {
            factoryBean.setHandlerChainBuilder(new DescriptorHandlerChainBuilder(handlerChains));
        }
        this.injectImplementorResources(implementor);
        EndpointImpl endpoint = new EndpointImpl(bus, implementor, factoryBean);
        endpoint.setServiceFactory(jaxWsServiceFactoryBean);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (info.getServiceName() != null) {
            properties.put("javax.xml.ws.wsdl.service", info.getServiceName());
        }
        if (info.getEndpointName() != null) {
            properties.put("javax.xml.ws.wsdl.port", info.getEndpointName());
        }
        endpoint.setProperties(properties);
        return endpoint;
    }

    private void injectImplementorResources(Object implementor) throws WSException {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler(new WebServiceContextInjectionHandler());
        try {
            processor.process(implementor);
        }
        catch (ProcessorException e) {
            throw new WSException("Cannot inject instance " + implementor, e);
        }
    }

    protected void checkEnableMtom(JaxWsServiceFactoryBean jaxWsServiceFactoryBean, JOnASJaxWsImplementorInfo info) {
        String protocolBinding;
        if (info == null) {
            return;
        }
        if (!info.isMTOMEnabled() || (protocolBinding = info.getBindingType()) == null || "http://schemas.xmlsoap.org/wsdl/soap/http".equals(protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(protocolBinding)) {
            // empty if block
        }
    }

    private void publishWSDL(WebservicesContainer container) {
        try {
            this.publisherManager.publish(container.getPublishableDefinitions());
        }
        catch (WSDLPublisherException e) {
            logger.error("Unable to publish WSDL for the container ''{0}''", container.getName(), e);
        }
    }

    @Override
    public void finalizePOJODeployment(ServletContext context) {
        String name = this.findUniqueContextName(context);
        IWebservicesModule<WebservicesContainer<CXFWSEndpoint>> module = this.webservicesModules.get(name);
        if (module != null) {
            module.start();
            for (WebservicesContainer<CXFWSEndpoint> container : module.getContainers()) {
                this.publishWSDL(container);
            }
        }
    }

    @Override
    public void undeployPOJOEndpoints(ServletContext context) {
        String name = this.findUniqueContextName(context);
        IWebservicesModule<WebservicesContainer<CXFWSEndpoint>> module = this.webservicesModules.get(name);
        if (module != null) {
            module.stop();
            this.webservicesModules.remove(name);
        }
    }

    public void bindEventService(IEventService eventService) {
        this.eventService = eventService;
        this.listener = new WebServiceRefExtensionListener();
        eventService.registerListener(this.listener, "/easybeans/container/factory/context");
    }

    public void unbindEventService(IEventService eventService) {
        this.eventService.unregisterListener(this.listener);
        this.eventService = null;
    }

    public void setWSDLPublisherManager(WSDLPublisherManager publisherManager) {
        this.publisherManager = publisherManager;
    }
}

