/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.publish.internal.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.ws.publish.WSDLPublisher;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WSDLPublisherFactory {
    public static final String CLASSNAME = "jonas.service.wsdl.class";
    private static Log logger = LogFactory.getLog(WSDLPublisherFactory.class);
    private static I18n i18n = I18n.getInstance(WSDLPublisherFactory.class);

    private WSDLPublisherFactory() {
    }

    public static WSDLPublisherFactory newInstance() {
        return new WSDLPublisherFactory();
    }

    public WSDLPublisher newPublisher(String filename) throws WSDLPublisherException {
        Properties props = this.loadProperties(filename + ".properties");
        String classname = props.getProperty(CLASSNAME);
        if (classname == null) {
            String err = i18n.getMessage("WSDLHandlerFactory.newHandler.noClassname", filename + ".properties");
            logger.error("WSDLHandlerFactory.newHandler.noClassname", filename + ".properties");
            throw new WSDLPublisherException(err);
        }
        Object[] pvalues = new Object[]{props};
        Class[] types = new Class[]{Properties.class};
        WSDLPublisher publisher = null;
        try {
            Class<WSDLPublisher> handlerClazz = Class.forName(classname).asSubclass(WSDLPublisher.class);
            Constructor<WSDLPublisher> handlerConstr = handlerClazz.getConstructor(types);
            publisher = handlerConstr.newInstance(pvalues);
        }
        catch (Exception e) {
            String err = i18n.getMessage("WSDLHandlerFactory.newHandler.instantiationFailure", filename, classname);
            logger.error("WSDLHandlerFactory.newHandler.instantiationFailure", filename, classname);
            throw new WSDLPublisherException(err, e);
        }
        return publisher;
    }

    private Properties loadProperties(String filename) throws WSDLPublisherException {
        Properties props = new Properties();
        InputStream is = this.getFromClassLoader(filename);
        if (is == null) {
            is = this.getFromFile(JProp.getJonasBase() + File.separator + "conf" + File.separator + filename);
        }
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException ioe) {
                String err = i18n.getMessage("WSDLHandlerFactory.loadProperties.ioe", filename);
                logger.error("WSDLHandlerFactory.loadProperties.ioe", filename);
                throw new WSDLPublisherException(err);
            }
        } else {
            String err = i18n.getMessage("WSDLHandlerFactory.loadProperties.notFound", filename);
            logger.error("WSDLHandlerFactory.loadProperties.notFound", filename);
            throw new WSDLPublisherException(err);
        }
        return props;
    }

    private InputStream getFromClassLoader(String filename) {
        String clProps = filename;
        if (!clProps.startsWith("/")) {
            clProps = "/" + clProps;
        }
        return this.getClass().getResourceAsStream(clProps);
    }

    private InputStream getFromFile(String filename) {
        FileInputStream is = null;
        File file = new File(filename);
        try {
            is = new FileInputStream(file);
        }
        catch (IOException ioe) {
            logger.warn("Cannot load {0} from file system.", filename);
            is = null;
        }
        return is;
    }
}

