/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.builder.webserviceref.factory;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.ow2.util.ee.builder.webserviceref.Constants;
import org.ow2.util.ee.builder.webserviceref.ReferenceHelper;
import org.ow2.util.ee.builder.webserviceref.factory.IPortProcessor;
import org.ow2.util.ee.builder.webserviceref.factory.JAXWSVersion;
import org.ow2.util.ee.builder.webserviceref.factory.PortProcessorImpl;
import org.ow2.util.ee.builder.webserviceref.factory.SubClassServiceGenerator;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.struct.JaxwsWebServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefObjectFactory
implements ObjectFactory {
    private static Log logger = LogFactory.getLog(WebServiceRefObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Constructor<? extends Service> constructor;
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        ReferenceHelper helper = new ReferenceHelper(ref);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String serviceClassname = helper.extract(Constants.SERVICE_CLASS.name());
        String seiClassname = helper.extract(Constants.SERVICE_ENDPOINT_INTERFACE.name());
        String wsdlLocation = helper.extract(Constants.WSDL_LOCATION.name());
        IJaxwsWebServiceRef jaxWebServiceRef = helper.extract(Constants.SERVICE_REF_ANNOTATION.name(), JaxwsWebServiceRef.class);
        Class<Service> serviceClass = null;
        serviceClass = Class.forName(serviceClassname, true, loader).asSubclass(Service.class);
        boolean haveWSDL = true;
        URL location = null;
        if (wsdlLocation != null) {
            try {
                location = new URL(wsdlLocation);
            }
            catch (MalformedURLException mue) {
                ClassLoader serviceLoader = serviceClass.getClassLoader();
                location = serviceLoader.getResource(wsdlLocation);
                if (location == null) {
                    location = loader.getResource(wsdlLocation);
                }
                if (location == null) {
                    haveWSDL = false;
                }
            }
        } else {
            haveWSDL = false;
        }
        QName serviceQName = null;
        WebServiceClient annotation = serviceClass.getAnnotation(WebServiceClient.class);
        if (annotation != null) {
            String annotationWsdlLocation;
            serviceQName = new QName(annotation.targetNamespace(), annotation.name());
            if (!haveWSDL && !"".equals(annotationWsdlLocation = annotation.wsdlLocation())) {
                URL urlWsdlLocation = loader.getResource(annotationWsdlLocation);
                if (urlWsdlLocation != null) {
                    haveWSDL = true;
                    location = urlWsdlLocation;
                } else {
                    logger.warn("Unable to found an URL referencing the WSDL Location ''{0}'' specified in the WebServiceClient annotation ''{1}''", annotationWsdlLocation, annotation.name());
                }
            }
        }
        PortProcessorImpl portProcessor = new PortProcessorImpl(jaxWebServiceRef);
        JAXWSVersion version2 = JAXWSVersion.JAXWS_20;
        try {
            serviceClass.getClassLoader().loadClass("javax.xml.ws.soap.MTOMFeature");
            version2 = JAXWSVersion.JAXWS_21;
        }
        catch (Exception e) {
            version2 = JAXWSVersion.JAXWS_20;
        }
        catch (Error e) {
            version2 = JAXWSVersion.JAXWS_20;
        }
        Class<? extends Service> subServiceClass = SubClassServiceGenerator.getClass(serviceClass, haveWSDL, version2);
        Service service = null;
        if (haveWSDL) {
            constructor = subServiceClass.getDeclaredConstructor(IPortProcessor.class, URL.class, QName.class);
            service = constructor.newInstance(portProcessor, location, serviceQName);
        } else {
            constructor = subServiceClass.getDeclaredConstructor(IPortProcessor.class);
            service = constructor.newInstance(portProcessor);
        }
        this.processObjectInstance(service, helper);
        Service returnedObject = service;
        if (seiClassname != null) {
            ClassLoader serviceClassLoader = service.getClass().getClassLoader();
            Class<?> sei = serviceClassLoader.loadClass(seiClassname);
            returnedObject = service.getPort(sei);
        }
        return returnedObject;
    }

    protected void processObjectInstance(Service service, ReferenceHelper referenceHelper) throws Exception {
    }
}

