/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.common.impl.AbsDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadata;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.war.api.exceptions.WARDeploymentDescException;
import org.ow2.util.ee.metadata.war.impl.WarClassesLocator;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.configurator.WarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.war.impl.specific.ISpecificWarDeployableFactory;
import org.ow2.util.ee.metadata.war.impl.xml.merge.WarMetadataMerge;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Filter;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Listener;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Servlet;
import org.ow2.util.ee.metadata.war.impl.xml.struct.Tag;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WARDeploymentDesc;
import org.ow2.util.ee.metadata.ws.api.IWebservicesCommonClassMetadata;
import org.ow2.util.ee.metadata.ws.api.xml.merge.IClassMetadataFinder;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;
import org.ow2.util.ee.metadata.ws.impl.xml.merge.WebservicesMetadataMerger;
import org.ow2.util.ee.metadata.ws.impl.xml.parsing.Webservices12DeploymentDesc;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.classlocator.ClassLoaderClassesLocator;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarDeployableMetadataFactory
extends AbsDeployableMetadataFactory
implements IWarDeployableMetadataFactory {
    private static final Log LOGGER = LogFactory.getLog(WarDeployableMetadataFactory.class);
    private static final String WEBINF_CLASSES_PREFIX = "WEB-INF/classes/";

    public WarDeployableMetadataFactory() {
    }

    public WarDeployableMetadataFactory(IScanner scanner) {
        super(scanner);
    }

    @Override
    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(deployable, null, null);
    }

    @Override
    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable, ClassLoader classLoader) throws DeployableMetadataException {
        List<ClassLoaderClassesLocator> classesLocatorList = null;
        classesLocatorList = classLoader != null ? Arrays.asList(new ClassLoaderClassesLocator(classLoader)) : Arrays.asList(new ClassLoaderClassesLocator(ClassLoader.getSystemClassLoader()));
        return this.createDeployableMetadata(deployable, classesLocatorList, null);
    }

    private void completeClassList(WAR war, Set<String> classNameSet) {
        for (Servlet servlet : war.getServlets()) {
            this.addClassToSetIfNotNull(servlet.getClassName(), classNameSet);
        }
        for (Listener listener : war.getListeners()) {
            this.addClassToSetIfNotNull(listener.getListenerClassName(), classNameSet);
        }
        for (Tag tag : war.getTags()) {
            this.addClassToSetIfNotNull(tag.getTagClassName(), classNameSet);
        }
        for (Filter filter : war.getFilters()) {
            this.addClassToSetIfNotNull(filter.getFilterClassName(), classNameSet);
        }
    }

    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable, List<? extends IClassesLocator> warExternLibraries, List<? extends ISpecificWarDeployableFactory> specificDeployableFactoryList) throws DeployableMetadataException {
        WAR war;
        try {
            if (!URLUtils.urlToFile2(deployable.getArchive().getURL()).isDirectory()) {
                throw new DeployableMetadataException("war must be uncompressed (local directory expected)");
            }
        }
        catch (URLUtilsException e) {
            throw new DeployableMetadataException("war must be uncompressed (local directory expected)");
        }
        catch (ArchiveException e) {
            throw new DeployableMetadataException("war exception", e);
        }
        long tAnalyzeStart = System.currentTimeMillis();
        IArchive archive = deployable.getArchive();
        try {
            war = WARDeploymentDesc.getWAR(archive);
        }
        catch (WARDeploymentDescException e) {
            throw new DeployableMetadataException(e);
        }
        IWebservices webservices = null;
        try {
            webservices = Webservices12DeploymentDesc.getWebservices12(archive, Webservices12DeploymentDesc.Type.WEBAPP);
        }
        catch (ParsingException e) {
            throw new DeployableMetadataException(e);
        }
        WarDeployableMetadataConfigurator warArchiveMetadataConfigurator = new WarDeployableMetadataConfigurator(deployable);
        HashSet<String> classNameSet = new HashSet<String>();
        if (specificDeployableFactoryList != null) {
            for (ISpecificWarDeployableFactory iSpecificWarDeployableFactory : specificDeployableFactoryList) {
                warArchiveMetadataConfigurator.addSpecificMetadataConfigurator(iSpecificWarDeployableFactory.beforeScan(deployable, classNameSet));
            }
        }
        this.completeClassList(war, classNameSet);
        if (war.isMetadataComplete()) {
            warArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        } else {
            Iterator<String> entryIterator;
            warArchiveMetadataConfigurator.setAnnotationParsingDesactived(false);
            try {
                entryIterator = archive.getEntries();
            }
            catch (ArchiveException archiveException) {
                throw new DeployableMetadataException(archiveException);
            }
            while (entryIterator.hasNext()) {
                String string = entryIterator.next();
                if (!string.startsWith(WEBINF_CLASSES_PREFIX) || !string.endsWith(".class")) continue;
                classNameSet.add(string.substring(WEBINF_CLASSES_PREFIX.length(), string.length() - ".class".length()));
            }
        }
        this.scan(classNameSet, new WarClassesLocator(archive), warExternLibraries, warArchiveMetadataConfigurator);
        final WarDeployableMetadata warDeployableMetadata = warArchiveMetadataConfigurator.getWarDeployableMetadata();
        warDeployableMetadata.setWebservices12(webservices);
        new WarMetadataMerge(warDeployableMetadata).merge(war);
        WebservicesMetadataMerger.merge(warDeployableMetadata, new IClassMetadataFinder(){

            @Override
            public IWebservicesCommonClassMetadata<?, ?, ?> findClassMetadata(String link) {
                if (war == null) {
                    return null;
                }
                List<Servlet> servlets = war.getServlets();
                for (Servlet servlet : servlets) {
                    if (!link.equals(servlet.getName())) continue;
                    return warDeployableMetadata.getWarClassMetadata(servlet.getClassName().replace('.', '/'));
                }
                return null;
            }
        });
        if (LOGGER.isDebugEnabled()) {
            long l = System.currentTimeMillis();
            LOGGER.debug("Analyze of file {0} took {1} ms.", archive.getName(), l - tAnalyzeStart);
        }
        return warArchiveMetadataConfigurator.getWarDeployableMetadata();
    }

    @Override
    public Class<IWarDeployableMetadata> getDeployableMetadataClass() {
        return IWarDeployableMetadata.class;
    }
}

