/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.obr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.bundlerepository.RepositoryAdminImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.obr.Resource;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.obr.ObrDeployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.impl.AbsResourceFetcherImpl;

public class ObrResourceFetcher
extends AbsResourceFetcherImpl
implements IResourceFetcher {
    private static final Log logger = LogFactory.getLog(ObrResourceFetcher.class);
    private File localFile = null;
    private BundleContext bundleContext = null;
    private URL resourceURL = null;
    private Long lastCheck = null;

    public File getResource() throws ResourceFetcherNotResolvedException {
        if (this.localFile == null) {
            throw new ResourceFetcherNotResolvedException();
        }
        return this.localFile;
    }

    public boolean hasChanged() throws FetcherException {
        URLConnection connection = null;
        try {
            connection = this.resourceURL.openConnection();
        }
        catch (IOException e) {
            throw new FetcherException(e);
        }
        long time = System.currentTimeMillis() - 1L;
        long changed = connection.getLastModified();
        if (this.lastCheck < changed) {
            return true;
        }
        this.lastCheck = time;
        return false;
    }

    public void resolve() throws FetcherException {
        if (this.deployment == null) {
            throw new FetcherException(new InvalidDeploymentException("null deployment"));
        }
        if (!(this.deployment instanceof ObrDeployment)) {
            throw new FetcherException(new InvalidDeploymentException("Bad deployment type: " + this.deployment.getClass().getName()));
        }
        ObrDeployment obrDeployment = (ObrDeployment)this.deployment;
        if (this.bundleContext == null) {
            throw new FetcherException("Cannot resolve this OBR resource fetcher with a null bundle context.");
        }
        RepositoryAdminImpl repositoryAdmin = new RepositoryAdminImpl(this.bundleContext);
        for (Repository repository : this.getRepositoryManager()) {
            if (repository.getType() != RepositoryKind.OBR) continue;
            URL url = null;
            try {
                url = new URL(repository.getUrl());
            }
            catch (MalformedURLException e) {
                logger.warn("Bad url in repository {0}; exception: {1}", repository, e);
            }
            if (url == null) continue;
            try {
                repositoryAdmin.addRepository(url);
            }
            catch (Exception e) {
                logger.warn("Could not insert repository {0} into the OBR repository admin.", url);
            }
        }
        String filter = this.buildFilterString(obrDeployment);
        if (filter == null) {
            logger.error("OBR deployment {0} resolves in null search filter - aborting deployment", obrDeployment);
            throw new FetcherException("Null search filter for deployment " + obrDeployment.toString());
        }
        Resource[] discoveryResult = repositoryAdmin.discoverResources(filter);
        if (discoveryResult.length == 0) {
            logger.error("OBR deployment {0} search returns no matching resource.", obrDeployment);
            throw new FetcherException("No matching search result for deployment " + obrDeployment.toString());
        }
        if (discoveryResult.length > 1) {
            logger.error("OBR deployment {0} search returns more than one resource.", obrDeployment);
            throw new FetcherException("Too many search results for deployment " + obrDeployment.toString());
        }
        Resource matchingResource = discoveryResult[0];
        this.resourceURL = matchingResource.getURL();
        this.localFile = ObrResourceFetcher.makeLocalFilePath(this.localRepositoriesBaseDir, matchingResource.getRepository().getName(), matchingResource.getSymbolicName());
        if (this.localFile != null && !this.localFile.getParentFile().exists()) {
            this.localFile.getParentFile().mkdirs();
        }
        this.update();
    }

    public void update() throws FetcherException {
        this.lastCheck = System.currentTimeMillis();
        InputStream input = null;
        try {
            input = this.resourceURL.openStream();
        }
        catch (IOException e) {
            logger.error("Exception while opening connection to resource {0}", this.resourceURL);
            throw new FetcherException("Exception while opening connection", e);
        }
        try {
            FileUtils.dump(input, this.localFile);
        }
        catch (FileUtilsException e) {
            logger.error("Exception while copying data from resource {0};exception: {1}", this.resourceURL, e);
            throw new FetcherException("Exception while copying resource data", e);
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private String buildFilterString(ObrDeployment obrDeployment) {
        if (obrDeployment == null) {
            return null;
        }
        String symbolicName = obrDeployment.getBundleSymbolicName();
        String bundleVersion = obrDeployment.getBundleVersion();
        String filter = obrDeployment.getFilter();
        String requireService = obrDeployment.getRequireService();
        StringBuilder sb = new StringBuilder("(&");
        if (symbolicName != null) {
            sb.append("(symbolicname=");
            sb.append(symbolicName);
            sb.append(")");
        }
        if (bundleVersion != null) {
            sb.append("(version");
            sb.append(bundleVersion);
            sb.append(")");
        }
        if (filter != null) {
            sb.append(filter);
        }
        if (requireService != null) {
            sb.append("(service=");
            sb.append(requireService);
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public RepositoryKind getSupportedRepositoryType() {
        return RepositoryKind.OBR;
    }
}

