/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.reader.activator;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.schemastream.ISchemaStreamFactory;
import org.ow2.util.plan.reader.ReaderException;
import org.ow2.util.plan.reader.plan.IPlanReader;
import org.ow2.util.plan.reader.plan.PlanReaderImpl;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.ow2.util.plan.reader.repository.RepositoryDataReaderImpl;

public class ReaderActivator
implements BundleActivator,
ServiceListener {
    private Log logger = LogFactory.getLog(ReaderActivator.class);
    private BundleContext bundleContext = null;
    private ISchemaStreamFactory schemaStreamFactory = null;
    private IPlanReader nonValidatingPlanReader = null;
    private IRepositoryDataReader nonValidatingRepositoryReader = null;
    private IPlanReader validatingPlanReader = null;
    private IRepositoryDataReader validatingRepositoryReader = null;
    private ServiceRegistration nonValidatingPlanReaderServiceRegistration = null;
    private ServiceRegistration nonValidatingRepositoryReaderServiceRegistration = null;
    private ServiceRegistration validatingPlanReaderServiceRegistration = null;
    private ServiceRegistration validatingRepositoryReaderServiceRegistration = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.registerNonValidatingReaders();
        ServiceReference schemaFactoryRef = context.getServiceReference(ISchemaStreamFactory.class.getName());
        if (schemaFactoryRef != null) {
            this.schemaStreamFactory = (ISchemaStreamFactory)context.getService(schemaFactoryRef);
            this.registerValidatingReaders();
        }
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + ISchemaStreamFactory.class.getName() + ")");
    }

    private void registerNonValidatingReaders() throws Exception {
        this.nonValidatingPlanReader = new PlanReaderImpl();
        this.nonValidatingRepositoryReader = new RepositoryDataReaderImpl();
        Hashtable<String, Boolean> properties = new Hashtable<String, Boolean>();
        ((Dictionary)properties).put("validating", Boolean.FALSE);
        this.nonValidatingPlanReaderServiceRegistration = this.bundleContext.registerService(IPlanReader.class.getName(), (Object)this.nonValidatingPlanReader, properties);
        this.nonValidatingRepositoryReaderServiceRegistration = this.bundleContext.registerService(IRepositoryDataReader.class.getName(), (Object)this.nonValidatingRepositoryReader, properties);
        this.logger.debug("Non validating Plan Reader {0} registered - Non validating Repository Reader {1} registered.", this.nonValidatingPlanReader, this.nonValidatingRepositoryReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterNonValidatingReaders() throws Exception {
        Exception firstUnregisterException = null;
        if (this.nonValidatingPlanReaderServiceRegistration != null) {
            try {
                this.nonValidatingPlanReaderServiceRegistration.unregister();
                this.logger.debug("Plan Reader unregistered", new Object[0]);
            }
            catch (Exception e) {
                firstUnregisterException = e;
            }
            finally {
                this.nonValidatingPlanReaderServiceRegistration = null;
            }
        }
        if (this.nonValidatingRepositoryReaderServiceRegistration != null) {
            this.nonValidatingRepositoryReaderServiceRegistration.unregister();
            this.logger.debug("Repository Reader unregistered", new Object[0]);
            this.nonValidatingRepositoryReaderServiceRegistration = null;
        }
        if (firstUnregisterException != null) {
            throw new Exception(firstUnregisterException);
        }
    }

    private void registerValidatingReaders() {
        try {
            this.validatingPlanReader = new PlanReaderImpl();
            this.validatingRepositoryReader = new RepositoryDataReaderImpl();
        }
        catch (Exception e) {
            this.logger.warn("Couldn't create the validating readers ; exception {0}", e);
            this.validatingPlanReader = null;
            this.validatingRepositoryReader = null;
            return;
        }
        this.validatingPlanReader.setSchemaStreamFactory(this.schemaStreamFactory);
        this.validatingRepositoryReader.setSchemaStreamFactory(this.schemaStreamFactory);
        try {
            this.validatingPlanReader.setValidation(true);
            this.validatingRepositoryReader.setValidation(true);
        }
        catch (ReaderException e) {
            this.logger.warn("Couldn't activate readers validation ; exception {0}", e);
            this.validatingPlanReader = null;
            this.validatingRepositoryReader = null;
            return;
        }
        Hashtable<String, Boolean> properties = new Hashtable<String, Boolean>();
        ((Dictionary)properties).put("validating", Boolean.TRUE);
        this.validatingPlanReaderServiceRegistration = this.bundleContext.registerService(IPlanReader.class.getName(), (Object)this.validatingPlanReader, properties);
        this.validatingRepositoryReaderServiceRegistration = this.bundleContext.registerService(IRepositoryDataReader.class.getName(), (Object)this.validatingRepositoryReader, properties);
        this.logger.debug("Validating Plan Reader {0} registered - Validating Repository Reader {1} registered.", this.validatingPlanReader, this.validatingRepositoryReader);
    }

    private void unregisterValidatingReaders() {
        if (this.validatingPlanReaderServiceRegistration != null) {
            this.validatingPlanReaderServiceRegistration.unregister();
            this.logger.debug("Validating Plan Reader unregistered", new Object[0]);
            this.validatingPlanReaderServiceRegistration = null;
        }
        if (this.validatingRepositoryReaderServiceRegistration != null) {
            this.validatingRepositoryReaderServiceRegistration.unregister();
            this.logger.debug("Validating Repository Reader unregistered", new Object[0]);
            this.validatingRepositoryReaderServiceRegistration = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterValidatingReaders();
        this.unRegisterNonValidatingReaders();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object service = this.bundleContext.getService(serviceRef);
        if (service instanceof ISchemaStreamFactory) {
            switch (event.getType()) {
                case 1: {
                    if (this.validatingPlanReaderServiceRegistration == null) break;
                    this.registerValidatingReaders();
                    break;
                }
                case 4: {
                    this.unregisterValidatingReaders();
                    break;
                }
            }
        }
    }
}

