/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.repository.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.plan.repository.api.RepositoryIdCollisionException;
import org.ow2.util.plan.repository.impl.RepositoryComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsRepositoryManagerImpl
implements IRepositoryManager {
    protected Map<String, Repository> repositories = new HashMap<String, Repository>();

    @Override
    public void addRepository(Repository repository) throws RepositoryIdCollisionException, InvalidRepositoryException {
        String repositoryId = repository.getId();
        if (repositoryId == null) {
            throw new InvalidRepositoryException("The repository has no id; repository: " + repository);
        }
        if (this.repositories.containsKey(repositoryId)) {
            throw new RepositoryIdCollisionException("Repository Id already used:" + repositoryId);
        }
        this.repositories.put(repositoryId, repository);
    }

    @Override
    public void removeRepository(Repository repository) {
        Repository matchingRepository = this.repositories.get(repository.getId());
        if (repository == matchingRepository) {
            this.repositories.remove(repository.getId());
        }
    }

    @Override
    public Repository getRepositoryById(String id) {
        return this.repositories.get(id);
    }

    @Override
    public Iterator<Repository> iterator() {
        Repository[] array = new Repository[this.repositories.values().size()];
        this.repositories.values().toArray(array);
        Arrays.sort(array, new RepositoryComparator());
        return Arrays.asList(array).iterator();
    }

    @Override
    public Integer getRepositoryCount() {
        return this.repositories.size();
    }
}

