/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.SystemPropertyUtils;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private final ResourcePatternResolver resourcePatternResolver;

    public ResourceArrayPropertyEditor() {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    public void setAsText(String text) {
        String pattern = this.resolvePath(text).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(pattern));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value instanceof Collection || value instanceof Object[] && !(value instanceof Resource[])) {
            List<Object> input = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
            ArrayList<Resource> merged = new ArrayList<Resource>();
            Iterator it = input.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (element instanceof String) {
                    String pattern = this.resolvePath((String)element).trim();
                    try {
                        Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                        for (int i = 0; i < resources.length; ++i) {
                            Resource resource = resources[i];
                            if (merged.contains(resource)) continue;
                            merged.add(resource);
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
                    }
                }
                if (element instanceof Resource) {
                    if (merged.contains(element)) continue;
                    merged.add((Resource)element);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + element + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(merged.toArray(new Resource[merged.size()]));
        } else {
            super.setValue(value);
        }
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }
}

