/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.lib;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.SecurityRoleRefDesc;
import org.ow2.jonas.deployment.web.SecurityConstraintListDesc;
import org.ow2.jonas.deployment.web.SecurityRoleDesc;
import org.ow2.jonas.deployment.web.ServletDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.security.AbsPermissionManager;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.lib.security.auth.JPrincipal;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandlerCurrent;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandlerData;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;
import org.ow2.jonas.lib.util.Log;

public class PermissionManager
extends AbsPermissionManager {
    private static Logger logger = null;
    private WebContainerDeploymentDesc webContainerDeploymentDesc = null;

    public PermissionManager(WebContainerDeploymentDesc webContainerDeploymentDesc, String contextId, boolean remove) throws PermissionManagerException {
        super(contextId, remove);
        this.webContainerDeploymentDesc = webContainerDeploymentDesc;
        logger = Log.getLogger((String)"org.ow2.jonas.web");
    }

    public void translateServletDeploymentDescriptor() throws PermissionManagerException {
        this.translateSecurityConstraintElements();
        this.translateServletSecurityRoleRef();
    }

    protected void translateSecurityConstraintElements() throws PermissionManagerException {
        if (this.webContainerDeploymentDesc == null || this.getPolicyConfiguration() == null) {
            throw new PermissionManagerException("PolicyConfiguration or webContainerbDeploymentDesc is null");
        }
        SecurityConstraintListDesc securityConstraintListDesc = this.webContainerDeploymentDesc.getSecurityConstraintListDesc();
        PermissionCollection excludedPermissions = securityConstraintListDesc.getExcludedPermissions();
        PermissionCollection uncheckedPermissions = securityConstraintListDesc.getUncheckedPermissions();
        PermissionCollection rolePermissions = null;
        String roleName2 = null;
        Map roleMapPermissions = securityConstraintListDesc.getPermissionsByRole();
        try {
            this.getPolicyConfiguration().addToExcludedPolicy(excludedPermissions);
            this.getPolicyConfiguration().addToUncheckedPolicy(uncheckedPermissions);
            for (String roleName2 : roleMapPermissions.keySet()) {
                rolePermissions = (PermissionCollection)roleMapPermissions.get(roleName2);
                this.getPolicyConfiguration().addToRole(roleName2, rolePermissions);
            }
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Can not add add permissions to policy", (Throwable)pce);
        }
    }

    protected void translateServletSecurityRoleRef() throws PermissionManagerException {
        if (this.webContainerDeploymentDesc == null || this.getPolicyConfiguration() == null) {
            throw new PermissionManagerException("PolicyConfiguration or webContainerbDeploymentDesc is null");
        }
        Collection servlets = this.webContainerDeploymentDesc.getServletDescList();
        ArrayList<String> rolesAppearedInSecurityRoleRef = new ArrayList<String>();
        ServletDesc servletDesc2 = null;
        String servletName = null;
        List roleRefs = null;
        SecurityRoleRefDesc securityRoleRefDesc2 = null;
        for (ServletDesc servletDesc2 : servlets) {
            roleRefs = servletDesc2.getSecurityRoleRefList();
            servletName = servletDesc2.getServletName();
            for (SecurityRoleRefDesc securityRoleRefDesc2 : roleRefs) {
                Permission webRoleRefPermission = securityRoleRefDesc2.getWebRoleRefPermission();
                rolesAppearedInSecurityRoleRef.add(securityRoleRefDesc2.getRoleName());
                try {
                    this.getPolicyConfiguration().addToRole(securityRoleRefDesc2.getRoleLink(), webRoleRefPermission);
                }
                catch (PolicyContextException pce) {
                    throw new PermissionManagerException("Can not add add permission '" + webRoleRefPermission + "' to policy", (Throwable)pce);
                }
            }
        }
        List securityRoles = this.webContainerDeploymentDesc.getSecurityRoleList();
        SecurityRoleDesc securityRoleDesc2 = null;
        String securityRoleName = null;
        for (ServletDesc servletDesc2 : servlets) {
            servletName = servletDesc2.getServletName();
            for (SecurityRoleDesc securityRoleDesc2 : securityRoles) {
                securityRoleName = securityRoleDesc2.getRoleName();
                if (rolesAppearedInSecurityRoleRef.contains(securityRoleName)) continue;
                WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission(servletName, securityRoleName);
                try {
                    this.getPolicyConfiguration().addToRole(securityRoleName, (Permission)webRoleRefPermission);
                }
                catch (PolicyContextException pce) {
                    throw new PermissionManagerException("Can not add add permission '" + webRoleRefPermission + "' to policy", (Throwable)pce);
                }
            }
        }
        securityRoles = this.webContainerDeploymentDesc.getSecurityRoleList();
        for (SecurityRoleDesc securityRoleDesc2 : securityRoles) {
            securityRoleName = securityRoleDesc2.getRoleName();
            WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission("", securityRoleName);
            try {
                this.getPolicyConfiguration().addToRole(securityRoleName, (Permission)webRoleRefPermission);
            }
            catch (PolicyContextException pce) {
                throw new PermissionManagerException("Can not add add permission '" + webRoleRefPermission + "' to policy", (Throwable)pce);
            }
        }
    }

    public boolean checkWebUserDataPermission(HttpServletRequest request, String principalName, String[] roles) {
        try {
            ProtectionDomain protectionDomain = this.initPolicyContext(request, principalName, roles);
            WebUserDataPermission webUserDataPermission = new WebUserDataPermission(request);
            boolean accessOK = PermissionManager.getPolicy().implies(protectionDomain, (Permission)webUserDataPermission);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Policy.implies result = " + accessOK));
            }
            return accessOK;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can't check web user data permission :" + e.getMessage()));
            return false;
        }
    }

    public boolean checkWebResourcePermission(HttpServletRequest request, String principalName, String[] roles) {
        try {
            ProtectionDomain protectionDomain = this.initPolicyContext(request, principalName, roles);
            WebResourcePermission webResourcePermission = new WebResourcePermission(request);
            boolean accessOK = PermissionManager.getPolicy().implies(protectionDomain, (Permission)webResourcePermission);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Policy.implies result = " + accessOK));
            }
            return accessOK;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can't check web resource permission :" + e.getMessage()));
            return false;
        }
    }

    public boolean checkWebRoleRefPermission(HttpServletRequest request, String servletName, String principalName, String[] roles, String roleName) {
        try {
            ProtectionDomain protectionDomain = this.initPolicyContext(request, principalName, roles);
            WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission(servletName, roleName);
            boolean accessOK = PermissionManager.getPolicy().implies(protectionDomain, (Permission)webRoleRefPermission);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Policy.implies result = " + accessOK));
            }
            return accessOK;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can't check web role ref permission :" + e.getMessage()));
            return false;
        }
    }

    private synchronized ProtectionDomain initPolicyContext(HttpServletRequest request, String principalName, String[] roles) throws URISyntaxException, MalformedURLException {
        URL url;
        PolicyContext.setContextID((String)this.getContextId());
        JPolicyContextHandlerData jPolicyContextHandlerData = JPolicyContextHandlerCurrent.getCurrent().getJPolicyContextHandlerData();
        if (jPolicyContextHandlerData == null) {
            logger.log(BasicLevel.ERROR, (Object)"The Handler data retrieved is null !");
            return null;
        }
        jPolicyContextHandlerData.setHttpServletRequest(request);
        PolicyContext.setHandlerData((Object)jPolicyContextHandlerData);
        String urlString = "file://" + this.getContextId();
        try {
            url = new URI(new URL(urlString).toString()).toURL();
        }
        catch (URISyntaxException e) {
            url = new URI(new URL(urlString.replaceAll("\\ ", "%20")).toString()).toURL();
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        String[] overridedRoles = JPolicyUserRoleMapping.getMappingForPrincipal((String)this.getContextId(), (String)principalName);
        String[] allRoles = roles;
        if (overridedRoles != null) {
            allRoles = overridedRoles;
        }
        Principal[] principals = null;
        if (allRoles != null) {
            principals = new Principal[allRoles.length];
            for (int k = 0; k < allRoles.length; ++k) {
                principals[k] = new JPrincipal(allRoles[k]);
            }
        }
        return new ProtectionDomain(codesource, null, null, principals);
    }

    protected void resetDeploymentDesc() {
        this.webContainerDeploymentDesc = null;
    }
}

