/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.ow2.jonas.commands.admin.CLIArgument;
import org.ow2.jonas.commands.admin.UtilAdmin;
import org.ow2.jonas.commands.admin.util.JMXConnectionHelper;
import org.ow2.jonas.launcher.felix.JOnAS;

public class ClientAdmin {
    private static final String DEFAULT_NAME = "jonas";
    private static final String JONAS_NAME = "jonas.name";
    private static final String JMXSERVICE_URL_PREFIX = "service:jmx:rmi:///jndi/";
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private static final String JONAS_BASE = "jonas.base";
    private static final String CAROL_FILE = "carol.properties";
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final int WAIT_LOOP_MSEC = 1000;
    private String jonasName = null;
    private String domainName = null;
    private ObjectName j2eeServerObjectName = null;
    private ObjectName domainOn = null;
    private boolean isError = false;
    private String[] target = null;
    private boolean qOption = false;
    private String username = null;
    private String password = null;
    private JMXConnectionHelper connection;

    public ClientAdmin(String[] args) throws Exception {
        String fileName = null;
        String timeout = null;
        String topic = null;
        String pingTimeoutValue = null;
        String protocol = null;
        String registry = null;
        String manageableState = null;
        boolean pingOption = false;
        boolean startOption = false;
        boolean interactive = true;
        ArrayList<CLIArgument> lstArgs = new ArrayList<CLIArgument>();
        for (int argn = 0; argn < args.length; ++argn) {
            CLIArgument ja;
            boolean nextArgument;
            String arg = args[argn];
            boolean bl = nextArgument = argn < args.length - 1;
            if (arg.equals("-h") || arg.equals("-?")) {
                this.usage();
                System.exit(0);
            }
            if (arg.equals("-a") && nextArgument) {
                fileName = args[++argn];
                ja = new CLIArgument(101, fileName);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-ping")) {
                pingOption = true;
                continue;
            }
            if (arg.equals("-custom")) {
                ja = new CLIArgument(110);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-e")) {
                ja = new CLIArgument(105);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-gc")) {
                ja = new CLIArgument(112);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-j")) {
                ja = new CLIArgument(104);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-l")) {
                ja = new CLIArgument(103);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-lmodules")) {
                ja = new CLIArgument(116);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-lapps")) {
                ja = new CLIArgument(117);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-registry") && nextArgument) {
                registry = args[++argn];
                continue;
            }
            if (arg.equals("-protocol") && nextArgument) {
                protocol = args[++argn];
                continue;
            }
            if (arg.equals("-timeout") && nextArgument) {
                pingTimeoutValue = args[++argn];
                continue;
            }
            if (arg.equals("-target") && nextArgument) {
                this.target = this.makeArrayFrom(args[++argn]);
                continue;
            }
            if (arg.equals("-r") && nextArgument) {
                fileName = args[++argn];
                ja = new CLIArgument(102, fileName);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-stop")) {
                ja = new CLIArgument(115);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-halt")) {
                ja = new CLIArgument(118);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-start")) {
                ja = new CLIArgument(114);
                lstArgs.add(ja);
                interactive = false;
                startOption = true;
                continue;
            }
            if (arg.equals("-sync")) {
                ja = new CLIArgument(109);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-passivate")) {
                ja = new CLIArgument(111);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("--debug-level") && nextArgument) {
                topic = args[++argn];
                ja = new CLIArgument(107, topic);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-t")) {
                ja = new CLIArgument(106);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-tt") && nextArgument) {
                timeout = args[++argn];
                ja = new CLIArgument(108, timeout);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-isdeployed") && nextArgument) {
                fileName = args[++argn];
                ja = new CLIArgument(113, fileName);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-q")) {
                this.qOption = true;
                interactive = false;
                continue;
            }
            if (arg.equals("-username")) {
                this.username = args[++argn];
                continue;
            }
            if (arg.equals("-password")) {
                this.password = args[++argn];
                continue;
            }
            if (arg.equals("-manageable.state") && nextArgument) {
                manageableState = args[++argn];
                continue;
            }
            System.out.println("Bad option: " + arg);
            this.usage();
            System.exit(2);
        }
        this.jonasName = System.getProperty(JONAS_NAME) != null ? System.getProperty(JONAS_NAME) : DEFAULT_NAME;
        JMXServiceURL jmxServiceUrl = this.initializeJMXConnectionHelper(registry, protocol);
        if (startOption) {
            boolean isStarted = this.connection.connect();
            this.connection.close();
            if (!isStarted) {
                JOnAS jonas = new JOnAS(Boolean.getBoolean("jonas.cache.clean"));
                jonas.start();
                return;
            }
            if (isStarted && Boolean.getBoolean(JONAS_BOOTSTRAP)) {
                System.err.println("JOnAS bootstrap is already started.");
                return;
            }
        }
        if (pingOption) {
            int pingTimeout = 120000;
            if (pingTimeoutValue != null) {
                try {
                    pingTimeout = Integer.parseInt(pingTimeoutValue);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Incorrect timeout value for ping. Value is '" + pingTimeoutValue + "'.");
                }
            }
            System.exit(this.waitServerManageable(pingTimeout, manageableState));
        }
        if (!this.connection.connect()) {
            System.err.println("Cannot connect to JOnAS using '" + jmxServiceUrl + "'");
        } else {
            block64: {
                System.out.println("You are administering server named " + this.jonasName);
                System.out.println("  " + jmxServiceUrl);
                try {
                    MBeanServerConnection conn = this.connection.getConnection();
                    this.j2eeServerObjectName = this.getJ2EEServerObjectName(conn);
                    this.domainName = this.j2eeServerObjectName.getDomain();
                    this.domainOn = ObjectName.getInstance(this.domainName + ":j2eeType=J2EEDomain,name=" + this.domainName);
                }
                catch (Exception e) {
                    if (pingOption) break block64;
                    System.err.println("Cannot admin server " + this.jonasName + ". Problem with JMX remote connection (" + e.getMessage() + ")");
                    System.exit(2);
                }
            }
            if (interactive) {
                this.menu();
            } else {
                boolean first = true;
                boolean forQuiet = this.qOption;
                this.qOption = true;
                for (CLIArgument argument : lstArgs) {
                    switch (argument.type) {
                        case 101: {
                            this.addFile(argument.value);
                            break;
                        }
                        case 102: {
                            this.removeFile(argument.value);
                            break;
                        }
                        case 114: {
                            this.startServer();
                            break;
                        }
                        case 115: {
                            this.stopServer();
                            break;
                        }
                        case 118: {
                            this.haltServer();
                            break;
                        }
                        case 103: {
                            this.listBeans();
                            break;
                        }
                        case 116: {
                            this.listModules();
                            break;
                        }
                        case 117: {
                            this.listApps();
                            break;
                        }
                        case 104: {
                            this.listJNDINames();
                            break;
                        }
                        case 105: {
                            this.listProperties();
                            break;
                        }
                        case 106: {
                            this.listTopics();
                            break;
                        }
                        case 107: {
                            this.setTopic(argument.value, "DEBUG");
                            break;
                        }
                        case 108: {
                            this.setTTimeout(argument.value);
                            break;
                        }
                        case 109: {
                            this.sync(false);
                            break;
                        }
                        case 110: {
                            this.custom();
                            break;
                        }
                        case 111: {
                            this.sync(true);
                            break;
                        }
                        case 112: {
                            this.runGC();
                            break;
                        }
                        case 113: {
                            this.isDeployedFile(argument.value);
                        }
                    }
                    if (first) {
                        first = false;
                        this.qOption = forQuiet;
                    }
                    if (!this.isError) continue;
                    System.exit(2);
                }
            }
            this.connection.close();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            new ClientAdmin(args);
        }
        catch (SecurityException e) {
            e.printStackTrace(System.err);
            System.err.println("This JOnAS server's JMX server requires credentials.");
            System.err.println("Please use the -username and -password options to provide them.");
        }
    }

    private JMXServiceURL initializeJMXConnectionHelper(String registry, String protocol) {
        Properties carolProperties = new Properties();
        try {
            String jonasBase = System.getProperty(JONAS_BASE);
            FileInputStream fis = new FileInputStream(jonasBase + File.separator + "conf" + File.separator + CAROL_FILE);
            carolProperties.load(fis);
        }
        catch (Exception e) {
            System.err.println("Cannot load Carol properties: " + e.getMessage());
        }
        if (protocol == null) {
            String protocols = carolProperties.getProperty("carol.protocols");
            protocol = protocols.split(",")[0];
        }
        if (registry == null) {
            registry = carolProperties.getProperty("carol." + protocol + ".url");
        }
        String urlPrefix = JMXSERVICE_URL_PREFIX;
        if ("iiop".equals(protocol)) {
            urlPrefix = urlPrefix.replace("rmi", "iiop");
        }
        String serviceUrl = urlPrefix.concat(registry).concat("/").concat(protocol).concat("connector_").concat(this.jonasName);
        JMXServiceURL jmxServiceUrl = null;
        try {
            jmxServiceUrl = new JMXServiceURL(serviceUrl);
        }
        catch (MalformedURLException e) {
            System.err.println("Cannot administer server " + this.jonasName + " because of incorrect JMX URL (" + e.getMessage() + ")");
            System.exit(2);
        }
        this.connection = new JMXConnectionHelper(jmxServiceUrl, this.username, this.password);
        return jmxServiceUrl;
    }

    private void runGC() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Run GC:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        String operationName = "runGC";
        Object[] params = null;
        String[] signature = null;
        try {
            conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
        }
        catch (Exception e) {
            System.err.println("Can't run GC in server " + this.jonasName + ". JMX Problem with MBean " + this.j2eeServerObjectName + " " + e.getMessage() + ".");
        }
        System.out.println("");
    }

    private MBeanServerConnection getConnection() {
        try {
            return this.connection.getConnection();
        }
        catch (IOException e) {
            System.err.println("Unable to connect to " + this.connection.getURL());
            System.err.println("Latest Exception: " + e.getMessage());
            return null;
        }
    }

    private void custom() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Custom:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            System.out.println(UtilAdmin.dumpCustom(this.domainName, this.jonasName, conn));
        }
        catch (Exception e) {
            System.err.println(e);
            this.isError = true;
            return;
        }
        System.out.println("");
    }

    private String[] makeArrayFrom(String line) {
        StringTokenizer stk = new StringTokenizer(line, ",");
        int nb = stk.countTokens();
        String[] ret = new String[nb];
        for (int i = 0; i < nb; ++i) {
            ret[i] = stk.nextToken();
        }
        return ret;
    }

    private void usage() {
        System.out.println("usage : jonas admin <options>");
        System.out.println("if no option(except -n), mode is interactive.");
        System.out.println("list of available options:");
        System.out.println("    -n name : to identify an JOnAS Server");
        System.out.println("    -username username : user name to use when connecting");
        System.out.println("    -password password : password to use when connecting");
        System.out.println("    -registry : to define registry address");
        System.out.println("    -protocol : to define protocol");
        System.out.println("    -s : stops the EJB server.");
        System.out.println("    -l        : lists beans currently in the JOnAS Server.");
        System.out.println("    -lmodules : lists J2EEModules currently in the JOnAS Server.");
        System.out.println("    -lapps    : lists J2EEApplications currently in the JOnAS Server.");
        System.out.println("    -j : lists registered JNDI names.");
        System.out.println("    -e : lists JOnAS properties currently used by the JOnAS Server.");
        System.out.println("    -a fileName : dynamically adds   : - beans from fileName in a new container");
        System.out.println("                                     : - servlets from a WAR file");
        System.out.println("                                     : - j2ee application from an EAR file");
        System.out.println("                                     : - resource adapter from a RAR file");
        System.out.println("    -r fileName : dynamically remove : - beans from container fileName");
        System.out.println("                                     : - servlets of a WAR file");
        System.out.println("                                     : - j2ee application of an EAR file");
        System.out.println("                                     : - resource adapter from a RAR file");
        System.out.println("    -sync: synchronize all entities");
        System.out.println("    -passivate: passivate all entities");
        System.out.println("    -gc: run the garbage collector");
        System.out.println("    -tt timeout: set default transaction timeout");
        System.out.println("    -start: Start servers designed by '-target' arg");
        System.out.println("    -target target: set target for commands (default is local server)");
        System.out.println("    -ping [-timeout <val (sec)>]: ping server for a given time.(default=100s)");
        System.out.println("    -t list monolog topics");
        System.out.println("    --debug-level topic : set DEBUG for a monolog topic");
        System.out.println("    -q : quiet mode, no processing header information.");
        System.out.println("    -h : help message.");
        System.out.println("    -? : help message.");
    }

    private void menu() throws IOException {
        BufferedReader inbuf = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            String fName;
            System.out.print("Admin (" + this.jonasName + ") > ");
            String command = inbuf.readLine();
            if (command.length() == 0) continue;
            if ("addfile".startsWith(command)) {
                fName = null;
                System.out.print("file name ? > ");
                fName = inbuf.readLine();
                if (fName.length() == 0) continue;
                this.addFile(fName);
                continue;
            }
            if ("start".startsWith(command)) {
                this.startServer();
                continue;
            }
            if ("env".startsWith(command)) {
                this.listProperties();
                continue;
            }
            if ("gc".startsWith(command)) {
                this.runGC();
                continue;
            }
            if ("help".startsWith(command) || command.equals("?")) {
                this.help();
                continue;
            }
            if ("jndinames".startsWith(command)) {
                this.listJNDINames();
                continue;
            }
            if ("listbeans".startsWith(command)) {
                this.listBeans();
                continue;
            }
            if ("listmodules".startsWith(command)) {
                this.listModules();
                continue;
            }
            if ("listapps".startsWith(command)) {
                this.listApps();
                continue;
            }
            if ("custom".startsWith(command)) {
                this.custom();
                continue;
            }
            if ("name".startsWith(command)) {
                System.out.println("Use the -n option to define the managed server name");
                continue;
            }
            if ("quit".startsWith(command) || "exit".startsWith(command)) {
                return;
            }
            if ("removefile".startsWith(command)) {
                fName = null;
                System.out.print("file name ? > ");
                fName = inbuf.readLine();
                if (fName.length() == 0) continue;
                this.removeFile(fName);
                continue;
            }
            if ("trace".startsWith(command)) {
                while (true) {
                    if (!this.listTopics()) continue block0;
                    System.out.print("topic name ? > ");
                    String tname = inbuf.readLine().trim();
                    if (tname.length() == 0) continue block0;
                    System.out.print("topic level ? (DEBUG | WARN | INFO | ERROR | INHERIT) > ");
                    String levstr = inbuf.readLine().trim();
                    this.setTopic(tname, levstr);
                }
            }
            if ("stop".startsWith(command)) {
                this.stopServer();
                continue;
            }
            if ("halt".startsWith(command)) {
                this.haltServer();
                continue;
            }
            if ("sync".startsWith(command)) {
                this.sync(false);
                continue;
            }
            if ("passivate".startsWith(command)) {
                this.sync(true);
                continue;
            }
            if ("ttimeout".startsWith(command)) {
                String tstr = null;
                System.out.print("transaction timeout in seconds ? > ");
                tstr = inbuf.readLine();
                if (tstr.length() == 0) continue;
                this.setTTimeout(tstr);
                continue;
            }
            if ("target".startsWith(command)) {
                System.out.print("Server or Cluster where to deploy the beans ? > ");
                this.target = this.makeArrayFrom(inbuf.readLine());
                continue;
            }
            System.out.println("Unknown command. Type help to get for the list of commands.");
        }
    }

    private void help() {
        System.out.println("addfile     adds beans/servlets/j2ee app/rars based upon the file extension");
        System.out.println("custom      dump jonas customization");
        System.out.println("env         JOnAS properties used by the server");
        System.out.println("gc          run the garbage collector");
        System.out.println("help        help");
        System.out.println("jndinames   lists registered JNDI names");
        System.out.println("listbeans   lists beans");
        System.out.println("listmodules lists modules");
        System.out.println("listapps    lists applications");
        System.out.println("name        to identify a current JOnAS server");
        System.out.println("quit        quit JonasAdmin");
        System.out.println("removefile  remove beans/servlets/j2ee app/rars (based upon the file extension)");
        System.out.println("start       stop target servers");
        System.out.println("stop        stop target servers");
        System.out.println("halt        halt target servers");
        System.out.println("sync        synchronize all entities");
        System.out.println("passivate   passivate all entities");
        System.out.println("trace       get/set monolog topics");
        System.out.println("ttimeout    set default transaction timeout");
        System.out.println("target      set list of servers where command must be applied");
    }

    private int waitServerManageable(int pingTimeout, String manageableState) {
        if (pingTimeout <= 0) {
            throw new IllegalArgumentException("Timeout should be a value greater than 0");
        }
        String serverState = null;
        int loopValue = pingTimeout / 1000;
        for (int i = 0; i < loopValue; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return 1;
            }
            if (this.connection.connect()) {
                MBeanServerConnection conn = this.getConnection();
                if (this.j2eeServerObjectName == null) {
                    this.j2eeServerObjectName = this.getJ2EEServerObjectName(conn);
                    continue;
                }
                try {
                    serverState = (String)conn.getAttribute(this.j2eeServerObjectName, "state");
                    if (!serverState.equalsIgnoreCase(manageableState)) continue;
                    return 0;
                }
                catch (Exception e) {
                    System.err.println("Cannot administer server " + this.jonasName + ". Problem with MBean " + this.j2eeServerObjectName + " (" + e.getMessage() + ")");
                    return 2;
                }
            }
            if (!"j2ee.state.stopped".equals(manageableState) || Boolean.getBoolean(JONAS_BOOTSTRAP)) continue;
            return 2;
        }
        return 1;
    }

    private ObjectName getJ2EEServerObjectName(MBeanServerConnection conn) {
        if (this.j2eeServerObjectName == null) {
            try {
                Set<ObjectName> servers = conn.queryNames(UtilAdmin.J2EEServer(this.jonasName), null);
                if (!servers.isEmpty()) {
                    return servers.iterator().next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.j2eeServerObjectName;
    }

    private void addFile(String fileName) {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Add File:" + fileName);
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        String operationName = "deploy";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
            System.out.println("Check result with listmodules or listapps command.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private void isDeployedFile(String fileName) {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Is File Deployable:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        String operationName = "isDeployed";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            boolean res = (Boolean)conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
            if (res) {
                System.out.println("File " + fileName + " deployed");
            } else {
                System.out.println("File " + fileName + " not deployed");
            }
            System.out.println("Check result with listmodules or listapps command.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private void removeFile(String fileName) {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Remove File: " + fileName);
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        String operationName = "undeploy";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
            System.out.println("Check result with listmodules or listapps command.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private void stopServer() {
        MBeanServerConnection conn = this.getConnection();
        if (conn == null) {
            this.isError = true;
            return;
        }
        try {
            if (this.target == null) {
                String operationName = "stop";
                Object[] params = null;
                String[] signature = null;
                try {
                    conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
                }
                catch (Exception e) {
                    String message = "ERROR: Can't stop server " + this.jonasName + " using MBean " + this.j2eeServerObjectName + ": " + e.getMessage();
                    if (e.getCause() != null) {
                        message = message + ", caused by " + e.getCause().getMessage();
                    }
                    message = message + ".";
                    System.err.println(message);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void haltServer() {
        block12: {
            MBeanServerConnection conn = this.getConnection();
            if (conn == null) {
                this.isError = true;
                return;
            }
            try {
                if (this.target == null) {
                    String operationName = "halt";
                    Object[] params = null;
                    String[] signature = null;
                    try {
                        conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
                    }
                    catch (Exception e) {
                        String message = "ERROR: Can't halt server " + this.jonasName + " using MBean " + this.j2eeServerObjectName + ": " + e.getMessage();
                        if (e.getCause() != null) {
                            message = message + ", caused by " + e.getCause().getMessage();
                        }
                        message = message + ".";
                        System.err.println(message);
                    }
                } else {
                    for (int i = 0; i < this.target.length; ++i) {
                        String atarget = this.target[i];
                        String operationName = "stopRemoteTarget";
                        Object[] params = new String[]{atarget};
                        String[] signature = new String[]{"java.lang.String"};
                        try {
                            conn.invoke(this.domainOn, operationName, params, signature);
                            continue;
                        }
                        catch (Exception e) {
                            String message = "ERROR: Can't halt remote server " + atarget + " using MBean " + this.domainOn + ": " + e.getMessage();
                            if (e.getCause() != null) {
                                message = message + ", caused by " + e.getCause().getMessage();
                            }
                            message = message + ".";
                            System.err.println(message);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.target == null) break block12;
                System.err.println("Error while halting servers:" + e.getCause().getMessage());
            }
        }
    }

    private void startServer() {
        block12: {
            MBeanServerConnection conn = this.getConnection();
            if (conn == null) {
                this.isError = true;
                return;
            }
            try {
                if (this.target == null) {
                    String operationName = "start";
                    Object[] params = null;
                    String[] signature = null;
                    try {
                        conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
                    }
                    catch (Exception e) {
                        String message = "ERROR: Can't start server " + this.jonasName + " using MBean " + this.j2eeServerObjectName + ": " + e.getMessage();
                        if (e.getCause() != null) {
                            message = message + ", caused by " + e.getCause().getMessage();
                        }
                        message = message + ".";
                        System.err.println(message);
                    }
                } else {
                    for (int i = 0; i < this.target.length; ++i) {
                        String atarget = this.target[i];
                        String operationName = "startRemoteTarget";
                        Object[] params = new String[]{atarget};
                        String[] signature = new String[]{"java.lang.String"};
                        try {
                            conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
                            continue;
                        }
                        catch (Exception e) {
                            String message = "ERROR: Can't start remote server " + this.jonasName + " using MBean " + this.j2eeServerObjectName + ": " + e.getMessage();
                            if (e.getCause() != null) {
                                message = message + ", caused by " + e.getCause().getMessage();
                            }
                            message = message + ".";
                            System.err.println(message);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.target == null) break block12;
                System.err.println("Error while starting servers:" + e.getCause().getMessage());
            }
        }
    }

    private void listBeans() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("ListBeans:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            ArrayList<String> names = UtilAdmin.listBeans(this.domainName, this.jonasName, conn);
            if (names.size() == 0) {
                System.out.println("No beans in " + this.jonasName);
            } else {
                for (String name : names) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ListBeans: " + e);
            this.isError = true;
            return;
        }
        System.out.println("");
    }

    private void listModules() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("ListModules:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            ArrayList<String> names = UtilAdmin.listModules(this.domainName, this.jonasName, conn);
            if (names.size() == 0) {
                System.out.println("No modules in " + this.jonasName);
            } else {
                for (String name : names) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ListModules: " + e);
            this.isError = true;
            return;
        }
        System.out.println("");
    }

    private void listApps() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("ListApplications:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            ArrayList<String> names = UtilAdmin.listApps(this.domainName, this.jonasName, conn);
            if (names.size() == 0) {
                System.out.println("No applications in " + this.jonasName);
            } else {
                for (String name : names) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ListApplications: " + e);
            this.isError = true;
            return;
        }
        System.out.println("");
    }

    private void listJNDINames() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("List JndiNames:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            ArrayList<ObjectName> ons = UtilAdmin.listJNDIResources(this.domainName, this.jonasName, conn);
            for (ObjectName on : ons) {
                System.out.println("");
                try {
                    String name = (String)conn.getAttribute(on, "Name");
                    ArrayList names = (ArrayList)conn.getAttribute(on, "Names");
                    System.out.println(name + " names:");
                    for (int i = 0; i < names.size(); ++i) {
                        System.out.println(names.get(i));
                    }
                }
                catch (MBeanException me) {
                    System.out.println(">> JNDIResource: " + me);
                    System.out.println(">> Target exception: " + me.getTargetException());
                }
            }
        }
        catch (Exception e) {
            System.err.println("List JndiNames: " + e);
            this.isError = true;
            return;
        }
        System.out.println("");
    }

    private void listProperties() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("ListProperties:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        String operationName = "getConfigFileEnv";
        Object[] params = null;
        String[] signature = null;
        try {
            Properties configProps = (Properties)conn.invoke(this.j2eeServerObjectName, operationName, params, signature);
            Enumeration<Object> e = configProps.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = configProps.get(key);
                System.out.println(key.toString() + "=" + value.toString());
            }
        }
        catch (Exception e) {
            System.err.println("Can't get properties of server " + this.jonasName + ". JMX Problem with MBean " + this.j2eeServerObjectName + " " + e.getMessage() + ".");
        }
        System.out.println("");
    }

    private boolean listTopics() {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("List Monolog Topics:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return false;
        }
        try {
            String[] result = UtilAdmin.getTopics(this.domainName, this.jonasName, conn);
            if (result == null) {
                System.out.println("Can't list Monolog Topics. Didn't found MBean for JOnAS logging management");
                return false;
            }
            if (result.length == 0) {
                System.out.println("No topics in " + this.jonasName);
            }
            for (int i = 0; i < result.length; ++i) {
                String level = UtilAdmin.getTopicLevel(this.domainName, this.jonasName, conn, result[i]);
                System.out.println(level + "\t" + result[i]);
            }
        }
        catch (Exception e) {
            System.err.println("List Monolog Topics : " + e);
            this.isError = true;
            return false;
        }
        return true;
    }

    private void setTopic(String t, String l) {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Set Monolog Topic:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            UtilAdmin.setTopicLevel(this.domainName, this.jonasName, conn, t, l);
        }
        catch (Exception e) {
            System.err.println("Set Monolog Topic : " + e);
            this.isError = true;
        }
        System.out.println("");
    }

    private void setTTimeout(String tstr) {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Set TransactionTimeout:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        Integer t = new Integer(tstr);
        try {
            ObjectName on = UtilAdmin.getJ2eeMBean(this.domainName, this.jonasName, "JTAResource", "JTAResource");
            if (conn.isRegistered(on)) {
                Attribute att = new Attribute("timeOut", t);
                conn.setAttribute(on, att);
                Integer val = (Integer)conn.getAttribute(on, "timeOut");
                System.out.println("TM timeout=" + val);
            }
        }
        catch (Exception e) {
            System.err.println("Can't set transaction time-out for server " + this.jonasName + ". " + e.getMessage());
        }
        System.out.println("");
    }

    private void sync(boolean passivate) {
        MBeanServerConnection conn;
        if (!this.qOption) {
            System.out.println("Sync:");
        }
        if ((conn = this.getConnection()) == null) {
            this.isError = true;
            return;
        }
        try {
            ObjectName on = this.getJonasServiceMBean(this.domainName, this.jonasName, "ejbContainers");
            String operationName = "syncAllEntities";
            Object[] params = new Boolean[]{passivate};
            String[] signature = new String[]{"boolean"};
            try {
                conn.invoke(on, operationName, params, signature);
            }
            catch (Exception e) {
                System.err.println("Can't sync entity beans in server " + this.jonasName + ". JMX Problem with MBean " + on + " " + e + ".");
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private ObjectName getJonasServiceMBean(String domain, String server, String service) throws MalformedObjectNameException, NullPointerException {
        StringBuffer sb = new StringBuffer(domain);
        sb.append(":");
        sb.append("type");
        sb.append("=");
        sb.append("service");
        sb.append(",");
        sb.append("name");
        sb.append("=");
        sb.append(service);
        return ObjectName.getInstance(new String(sb));
    }
}

