/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.check;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class CheckEnv {
    public static final int ENV_OK = 0;
    public static final int ENV_ERROR = 1;
    private static final String JONAS_ROOT = "jonas.root";
    private static final String JONAS_BASE = "jonas.base";
    private static final String JORAM_RAR = "joram_ra_for_jonas.rar";
    private static final String JORAM_ADMIN_FILE = "joramAdmin.xml";
    private static List<String> propertyFilesToCheck = new ArrayList<String>();
    private static List<String> jarFilesToCheck;
    private int envStatus = 0;
    private String jonasRoot = null;
    private String jonasBase = null;

    public CheckEnv(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-help") && !arg.equals("-?")) continue;
            this.help();
            System.exit(0);
        }
        this.jonasRoot = System.getProperty(JONAS_ROOT);
        this.jonasBase = System.getProperty(JONAS_BASE);
        this.envStatus = this.performCheck();
        if (this.envStatus == 0) {
            System.out.println("\nThe JOnAS environment seems correct.");
            System.exit(0);
        } else if (this.envStatus == 1) {
            System.out.println("\nERROR : The JOnAS environment is NOT correct.");
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        new CheckEnv(args);
    }

    public int performCheck() {
        this.envStatus = 0;
        this.checkJOnASProperties();
        for (String fileName : propertyFilesToCheck) {
            if (this.fileExists(this.jonasBase, fileName)) continue;
            System.out.println("ERROR : '" + fileName + "' not accessible in " + this.jonasBase);
            this.envStatus = 1;
        }
        for (String fileName : jarFilesToCheck) {
            if (this.fileExists(this.jonasRoot, fileName)) continue;
            System.out.println("ERROR : '" + fileName + "' not accessible in " + this.jonasRoot);
            this.envStatus = 1;
        }
        this.checkJORAMRar();
        this.checkPortAvailability();
        return this.envStatus;
    }

    private boolean fileExists(String parent, String fileName) {
        return new File(parent, fileName).exists();
    }

    private void help() {
        System.out.println("This command allows to check that the JOnAS environment is correctly set.");
    }

    private Properties getProperties(String fileName) {
        Properties props = null;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (is != null) {
            props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                props = null;
            }
        }
        return props;
    }

    private void checkJOnASProperties() {
        System.out.println("\nChecking jonas.properties file...");
        try {
            Properties properties = this.getProperties("jonas.properties");
            String services = properties.getProperty("jonas.services");
            if (services != null) {
                System.out.println("- jonas.services : " + services);
            } else {
                System.out.println("ERROR: jonas.services not defined in jonas.properties");
                this.envStatus = 1;
            }
            String jonasContent = properties.toString();
            if (jonasContent.length() == 0) {
                System.out.println("ERROR : jonas.properties is empty");
                this.envStatus = 1;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: 'jonas.properties' not accessible (" + e + ")");
            this.envStatus = 1;
        }
    }

    private void checkJORAMRar() {
        File joramAdminFile;
        System.out.println("\nChecking JORAM configuration...");
        File deployDirectory = new File(this.jonasBase, "deploy");
        if (!new File(deployDirectory, JORAM_RAR).exists()) {
            System.out.println("ERROR : the file 'joram_ra_for_jonas.rar' was not found in JONAS_BASE/deploy directory");
            this.envStatus = 1;
        }
        if (!(joramAdminFile = new File(this.jonasBase + File.separator + "conf" + File.separator + JORAM_ADMIN_FILE)).exists()) {
            System.out.println("ERROR : the file joramAdmin.xml was not found in JONAS_BASE/conf directory");
            this.envStatus = 1;
        }
    }

    private void checkPortAvailability() {
        System.out.println("\nChecking port availability...");
        Properties carolProperties = this.getProperties("carol.properties");
        String protocols = carolProperties.getProperty("carol.protocols");
        int port = -1;
        for (String protocol : protocols.split(",")) {
            try {
                URI url = new URI(carolProperties.getProperty("carol." + protocol + ".url"));
                port = url.getPort();
                ServerSocket sock = new ServerSocket(port);
                sock.close();
            }
            catch (URISyntaxException e) {
                System.out.println("ERROR : the URL for the '" + protocol + "' protocol is malformed");
                this.envStatus = 1;
            }
            catch (IOException e) {
                System.out.println("ERROR : the port number " + port + " is already open");
                this.envStatus = 1;
            }
        }
    }

    static {
        propertyFilesToCheck.add("conf/trace.properties");
        propertyFilesToCheck.add("conf/carol.properties");
        propertyFilesToCheck.add("conf/jonas-realm.xml");
        jarFilesToCheck = new ArrayList<String>();
        jarFilesToCheck.add("lib/client.jar");
        jarFilesToCheck.add("lib/jonas-client.jar");
        jarFilesToCheck.add("lib/bootstrap/client-bootstrap.jar");
        jarFilesToCheck.add("lib/bootstrap/felix-launcher.jar");
        jarFilesToCheck.add("lib/bootstrap/jonas-commands.jar");
        jarFilesToCheck.add("lib/common/easybeans-ant-tasks.jar");
        jarFilesToCheck.add("lib/common/ow_jonas_ant.jar");
    }
}

