/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class ConversionException
extends EclipseLinkException {
    protected Class classToConvertTo;
    protected transient Object sourceObject;
    public static final int COULD_NOT_BE_CONVERTED = 3001;
    public static final int COULD_NOT_BE_CONVERTED_EXTENDED = 3002;
    public static final int INCORRECT_DATE_FORMAT = 3003;
    public static final int INCORRECT_TIME_FORMAT = 3004;
    public static final int INCORRECT_TIMESTAMP_FORMAT = 3005;
    public static final int COULD_NOT_CONVERT_TO_BYTE_ARRAY = 3006;
    public static final int COULD_NOT_BE_CONVERTED_TO_CLASS = 3007;
    public static final int INCORRECT_DATE_TIME_FORMAT = 3008;

    protected ConversionException() {
    }

    protected ConversionException(String message, Object sourceObject, Class classToConvertTo, Exception exception) {
        super(message, exception);
        this.setSourceObject(sourceObject);
        this.setClassToConvertTo(classToConvertTo);
    }

    public static ConversionException couldNotBeConverted(Object mapping, Object descriptor, ConversionException exception) {
        Object sourceObject = exception.getSourceObject();
        Class javaClass = exception.getClassToConvertTo();
        Exception original = (Exception)exception.getInternalException();
        Object[] args = new Object[]{sourceObject, sourceObject.getClass(), mapping, descriptor, javaClass};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3002, args);
        ConversionException conversionException = new ConversionException(message, sourceObject, javaClass, original);
        conversionException.setStackTrace(exception.getStackTrace());
        conversionException.setErrorCode(3002);
        return conversionException;
    }

    public static ConversionException couldNotBeConverted(Object object, Class javaClass) {
        Object[] args = new Object[]{object, object.getClass(), javaClass};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3001, args);
        ConversionException conversionException = new ConversionException(message, object, javaClass, null);
        conversionException.setErrorCode(3001);
        return conversionException;
    }

    public static ConversionException couldNotBeConverted(Object object, Class javaClass, Exception exception) {
        Object[] args = new Object[]{object, object.getClass(), javaClass};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3001, args);
        ConversionException conversionException = new ConversionException(message, object, javaClass, exception);
        conversionException.setErrorCode(3001);
        return conversionException;
    }

    public static ConversionException couldNotBeConvertedToClass(Object object, Class javaClass, Exception exception) {
        Object[] args = new Object[]{object, object.getClass(), javaClass};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3007, args);
        ConversionException conversionException = new ConversionException(message, object, javaClass, exception);
        conversionException.setErrorCode(3007);
        return conversionException;
    }

    public static ConversionException couldNotConvertToByteArray(Object object) {
        Object[] args = new Object[]{object};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3006, args);
        ConversionException conversionException = new ConversionException(message, object, byte[].class, null);
        conversionException.setErrorCode(3006);
        return conversionException;
    }

    public static ConversionException incorrectDateFormat(String dateString) {
        Object[] args = new Object[]{dateString};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3003, args);
        ConversionException conversionException = new ConversionException(message, dateString, Date.class, null);
        conversionException.setErrorCode(3003);
        return conversionException;
    }

    public static ConversionException incorrectTimeFormat(String timeString) {
        Object[] args = new Object[]{timeString};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3004, args);
        ConversionException conversionException = new ConversionException(message, timeString, Time.class, null);
        conversionException.setErrorCode(3004);
        return conversionException;
    }

    public static ConversionException incorrectTimestampFormat(String timestampString) {
        Object[] args = new Object[]{timestampString};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3005, args);
        ConversionException conversionException = new ConversionException(message, timestampString, Timestamp.class, null);
        conversionException.setErrorCode(3005);
        return conversionException;
    }

    public static ConversionException incorrectDateTimeFormat(String dateTimeString) {
        Object[] args = new Object[]{dateTimeString};
        String message = ExceptionMessageGenerator.buildMessage(ConversionException.class, 3008, args);
        ConversionException conversionException = new ConversionException(message, dateTimeString, Calendar.class, null);
        conversionException.setErrorCode(3008);
        return conversionException;
    }

    public Class getClassToConvertTo() {
        return this.classToConvertTo;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public void setClassToConvertTo(Class classToConvertTo) {
        this.classToConvertTo = classToConvertTo;
    }

    public void setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
    }
}

