/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Basic;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ChangeTracking;
import org.eclipse.persistence.annotations.CloneCopyPolicy;
import org.eclipse.persistence.annotations.CopyPolicy;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.annotations.InstantiationCopyPolicy;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.Transformation;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.TransformationAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VariableOneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VersionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.ChangeTrackingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CloneCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CustomCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.InstantiationCopyPolicyMetadata;

public abstract class ClassAccessor
extends MetadataAccessor {
    private Boolean m_excludeDefaultMappings;
    private Boolean m_metadataComplete;
    private ChangeTrackingMetadata m_changeTracking;
    private Class m_customizerClass;
    private CloneCopyPolicyMetadata m_cloneCopyPolicy;
    private CustomCopyPolicyMetadata m_customCopyPolicy;
    private InstantiationCopyPolicyMetadata m_instantiationCopyPolicy;
    private String m_access;
    private String m_className;
    private String m_customizerClassName;
    private String m_description;
    private XMLAttributes m_attributes;

    protected ClassAccessor(String xmlElement) {
        super(xmlElement);
    }

    public ClassAccessor(Annotation annotation, Class cls, MetadataProject project) {
        super(annotation, new MetadataClass(cls), new MetadataDescriptor(cls), project);
        this.getDescriptor().setClassAccessor(this);
    }

    protected ClassAccessor(Annotation annotation, Class cls, MetadataDescriptor descriptor, MetadataProject project) {
        super(annotation, new MetadataClass(cls), descriptor, project);
    }

    protected MappingAccessor buildAccessor(MetadataAnnotatedElement accessibleObject) {
        if (accessibleObject.isBasicCollection(this.getDescriptor())) {
            return new BasicCollectionAccessor((Annotation)accessibleObject.getAnnotation(BasicCollection.class), accessibleObject, this);
        }
        if (accessibleObject.isBasicMap(this.getDescriptor())) {
            return new BasicMapAccessor((Annotation)accessibleObject.getAnnotation(BasicMap.class), accessibleObject, this);
        }
        if (accessibleObject.isId(this.getDescriptor())) {
            return new IdAccessor((Annotation)accessibleObject.getAnnotation(Id.class), accessibleObject, this);
        }
        if (accessibleObject.isVersion(this.getDescriptor())) {
            return new VersionAccessor((Annotation)accessibleObject.getAnnotation(Version.class), accessibleObject, this);
        }
        if (accessibleObject.isBasic(this.getDescriptor())) {
            return new BasicAccessor((Annotation)accessibleObject.getAnnotation(Basic.class), accessibleObject, this);
        }
        if (accessibleObject.isEmbedded(this.getDescriptor())) {
            return new EmbeddedAccessor((Annotation)accessibleObject.getAnnotation(Embedded.class), accessibleObject, this);
        }
        if (accessibleObject.isEmbeddedId(this.getDescriptor())) {
            return new EmbeddedIdAccessor((Annotation)accessibleObject.getAnnotation(EmbeddedId.class), accessibleObject, this);
        }
        if (accessibleObject.isTransformation(this.getDescriptor())) {
            return new TransformationAccessor((Annotation)accessibleObject.getAnnotation(Transformation.class), accessibleObject, this);
        }
        if (accessibleObject.isManyToMany(this.getDescriptor())) {
            return new ManyToManyAccessor((Annotation)accessibleObject.getAnnotation(ManyToMany.class), accessibleObject, this);
        }
        if (accessibleObject.isManyToOne(this.getDescriptor())) {
            return new ManyToOneAccessor((Annotation)accessibleObject.getAnnotation(ManyToOne.class), accessibleObject, this);
        }
        if (accessibleObject.isOneToMany(this.getDescriptor())) {
            return new OneToManyAccessor((Annotation)accessibleObject.getAnnotation(OneToMany.class), accessibleObject, this);
        }
        if (accessibleObject.isOneToOne(this.getDescriptor())) {
            return new OneToOneAccessor((Annotation)accessibleObject.getAnnotation(OneToOne.class), accessibleObject, this);
        }
        if (accessibleObject.isVariableOneToOne(this.getDescriptor())) {
            return new VariableOneToOneAccessor((Annotation)accessibleObject.getAnnotation(VariableOneToOne.class), accessibleObject, this);
        }
        if (this.getDescriptor().ignoreDefaultMappings()) {
            return null;
        }
        return new BasicAccessor((Annotation)accessibleObject.getAnnotation(Basic.class), accessibleObject, this);
    }

    public boolean excludeDefaultMappings() {
        return this.m_excludeDefaultMappings != null && this.m_excludeDefaultMappings != false;
    }

    public String getAccess() {
        return this.m_access;
    }

    public XMLAttributes getAttributes() {
        return this.m_attributes;
    }

    public ChangeTrackingMetadata getChangeTracking() {
        return this.m_changeTracking;
    }

    public String getClassName() {
        return this.m_className;
    }

    public CopyPolicyMetadata getCopyPolicy() {
        if (this.m_cloneCopyPolicy != null) {
            return this.m_cloneCopyPolicy;
        }
        if (this.m_instantiationCopyPolicy != null) {
            return this.m_instantiationCopyPolicy;
        }
        return this.m_customCopyPolicy;
    }

    public CloneCopyPolicyMetadata getCloneCopyPolicy() {
        return this.m_cloneCopyPolicy;
    }

    public CustomCopyPolicyMetadata getCustomCopyPolicy() {
        return this.m_customCopyPolicy;
    }

    public Class getCustomizerClass() {
        return this.m_customizerClass;
    }

    public String getCustomizerClassName() {
        return this.m_customizerClassName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Boolean getExcludeDefaultMappings() {
        return this.m_excludeDefaultMappings;
    }

    public String getIdentifier() {
        return this.getJavaClassName();
    }

    public InstantiationCopyPolicyMetadata getInstantiationCopyPolicy() {
        return this.m_instantiationCopyPolicy;
    }

    public Class getJavaClass() {
        return (Class)this.getAnnotatedElement();
    }

    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public Boolean getMetadataComplete() {
        return this.m_metadataComplete;
    }

    public boolean isMetadataComplete() {
        return this.m_metadataComplete != null && this.m_metadataComplete != false;
    }

    protected boolean havePersistenceAnnotationsDefined(Field[] fields) {
        for (Field field : fields) {
            MetadataField metadataField = new MetadataField(field, this.getLogger());
            if (!metadataField.hasDeclaredAnnotations(this.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    protected boolean havePersistenceAnnotationsDefined(Method[] methods) {
        for (Method method : methods) {
            MetadataMethod metadataMethod = new MetadataMethod(method, this.getLogger());
            if (!metadataMethod.hasDeclaredAnnotations(this.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_changeTracking, accessibleObject);
        this.initXMLObject(this.m_cloneCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_customCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_instantiationCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_attributes, accessibleObject);
        this.m_customizerClass = this.initXMLClassName(this.m_customizerClassName);
    }

    public boolean isClassAccessor() {
        return true;
    }

    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        ClassAccessor accessor = (ClassAccessor)metadata;
        this.m_access = (String)this.mergeSimpleObjects(this.m_access, accessor.getAccess(), accessor.getAccessibleObject(), "@access");
        this.m_customizerClass = (Class)this.mergeSimpleObjects(this.m_customizerClass, accessor.getCustomizerClass(), accessor.getAccessibleObject(), "<customizer>");
        this.m_description = (String)this.mergeSimpleObjects(this.m_description, accessor.getDescription(), accessor.getAccessibleObject(), "<description>");
        this.m_metadataComplete = (Boolean)this.mergeSimpleObjects(this.m_metadataComplete, accessor.getMetadataComplete(), accessor.getAccessibleObject(), "@metadata-complete");
        this.m_excludeDefaultMappings = (Boolean)this.mergeSimpleObjects(this.m_excludeDefaultMappings, accessor.getExcludeDefaultMappings(), accessor.getAccessibleObject(), "@exclude-default-mappings");
        this.m_cloneCopyPolicy = (CloneCopyPolicyMetadata)this.mergeORObjects(this.m_cloneCopyPolicy, accessor.getCloneCopyPolicy());
        this.m_customCopyPolicy = (CustomCopyPolicyMetadata)this.mergeORObjects(this.m_customCopyPolicy, accessor.getCustomCopyPolicy());
        this.m_instantiationCopyPolicy = (InstantiationCopyPolicyMetadata)this.mergeORObjects(this.m_instantiationCopyPolicy, accessor.getInstantiationCopyPolicy());
        this.m_changeTracking = (ChangeTrackingMetadata)this.mergeORObjects(this.m_changeTracking, accessor.getChangeTracking());
        if (this.m_attributes == null) {
            this.m_attributes = accessor.getAttributes();
        } else {
            this.m_attributes.merge(accessor.getAttributes());
        }
    }

    public abstract void process();

    protected void processAccessor(MappingAccessor accessor) {
        if (accessor != null && !accessor.isProcessed()) {
            this.getDescriptor().addAccessor(accessor);
            accessor.setOwningDescriptor(this.getOwningDescriptor());
            accessor.processConverters();
            if (accessor.isBasicCollection()) {
                this.getDescriptor().addBasicCollectionAccessor(accessor);
            } else if (accessor.isRelationship()) {
                this.getDescriptor().addRelationshipAccessor(accessor);
            } else {
                accessor.process();
                accessor.setIsProcessed();
            }
        }
    }

    protected void processAccessorFields() {
        for (Field field : MetadataHelper.getFields(this.getJavaClass())) {
            MetadataField metadataField = new MetadataField(field, this.getLogger());
            if (metadataField.isAnnotationPresent(Transient.class)) {
                if (!metadataField.hasMoreThanOneDeclaredAnnotation(this.getDescriptor())) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(field);
            }
            if (!metadataField.isValidPersistenceField(this.getDescriptor()) || this.getDescriptor().hasAccessorFor(metadataField.getAttributeName())) continue;
            this.processAccessor(this.buildAccessor(metadataField));
        }
    }

    protected void processAccessorMethods() {
        for (Method method : MetadataHelper.getDeclaredMethods(this.getJavaClass())) {
            MetadataMethod metadataMethod = new MetadataMethod(method, this.getLogger());
            if (metadataMethod.isAnnotationPresent(Transient.class)) {
                if (!metadataMethod.hasMoreThanOneDeclaredAnnotation(this.getDescriptor())) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(method);
            }
            if (!metadataMethod.isValidPersistenceMethod(this.getDescriptor()) || this.getDescriptor().hasAccessorFor(metadataMethod.getAttributeName())) continue;
            this.processAccessor(this.buildAccessor(metadataMethod));
        }
    }

    protected void processAccessors() {
        if (this.m_attributes != null) {
            for (MappingAccessor accessor : this.m_attributes.getAccessors()) {
                MetadataAnnotatedElement accessibleObject = null;
                if (accessor.usesPropertyAccess(this.getDescriptor())) {
                    if (accessor.getAccessMethods() != null) {
                        String getMethodName = accessor.getAccessMethods().getGetMethodName();
                        Method getMethod = MetadataHelper.getMethod(getMethodName, this.getJavaClass(), new Class[0]);
                        String setMethodName = accessor.getAccessMethods().getSetMethodName();
                        Method setMethod = MetadataHelper.getMethod(setMethodName, this.getJavaClass(), new Class[]{getMethod.getReturnType()});
                        accessibleObject = new MetadataMethod(getMethod, setMethod, accessor.getName(), this.getEntityMappings());
                    } else {
                        Method method = MetadataHelper.getMethodForPropertyName(accessor.getName(), this.getJavaClass());
                        if (method == null) {
                            throw ValidationException.invalidPropertyForClass(accessor.getName(), this.getJavaClass());
                        }
                        MetadataMethod metadataMethod = new MetadataMethod(method, this.getEntityMappings());
                        if (accessor.isTransient() || metadataMethod.isValidPersistenceMethod(this.getDescriptor(), true)) {
                            accessibleObject = metadataMethod;
                        }
                    }
                } else {
                    Field field = MetadataHelper.getFieldForName(accessor.getName(), this.getJavaClass());
                    if (field == null) {
                        throw ValidationException.invalidFieldForClass(accessor.getName(), this.getJavaClass());
                    }
                    MetadataField metadataField = new MetadataField(field, this.getEntityMappings());
                    if (accessor.isTransient() || metadataField.isValidPersistenceField(this.getDescriptor(), true)) {
                        accessibleObject = metadataField;
                    }
                }
                accessor.initXMLAccessor(accessibleObject, this.getDescriptor(), this.getProject());
                this.processAccessor(accessor);
            }
        }
        if (this.getDescriptor().usesPropertyAccess()) {
            this.processAccessorMethods();
        } else {
            this.processAccessorFields();
        }
    }

    protected void processBasicCollectionAccessors() {
        for (BasicCollectionAccessor accessor : this.getDescriptor().getBasicCollectionAccessors()) {
            accessor.process();
            accessor.setIsProcessed();
        }
    }

    protected void processChangeTracking() {
        Object changeTracking = this.getAnnotation(ChangeTracking.class);
        if (this.m_changeTracking != null || changeTracking != null) {
            if (this.getDescriptor().hasChangeTracking()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_change_tracking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_changeTracking == null) {
                new ChangeTrackingMetadata((Annotation)changeTracking, this.getAccessibleObject()).process(this.getDescriptor());
            } else {
                if (changeTracking != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", changeTracking, this.getJavaClassName(), this.getLocation());
                }
                this.m_changeTracking.process(this.getDescriptor());
            }
        }
    }

    protected void processCopyPolicy() {
        Object copyPolicy = this.getAnnotation(CopyPolicy.class);
        Object instantiationCopyPolicy = this.getAnnotation(InstantiationCopyPolicy.class);
        Object cloneCopyPolicy = this.getAnnotation(CloneCopyPolicy.class);
        if (this.getCopyPolicy() != null || copyPolicy != null || instantiationCopyPolicy != null || cloneCopyPolicy != null) {
            if (this.getDescriptor().hasCopyPolicy()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_copy_policy", this.getDescriptor().getJavaClass(), this.getJavaClass());
            }
            if (this.getCopyPolicy() == null) {
                if (copyPolicy != null) {
                    if (instantiationCopyPolicy != null || cloneCopyPolicy != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass(this.getJavaClassName());
                    }
                    new CustomCopyPolicyMetadata((Annotation)copyPolicy, this.getAccessibleObject()).process(this.getDescriptor());
                }
                if (instantiationCopyPolicy != null) {
                    if (cloneCopyPolicy != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass(this.getJavaClassName());
                    }
                    new InstantiationCopyPolicyMetadata((Annotation)instantiationCopyPolicy, this.getAccessibleObject()).process(this.getDescriptor());
                }
                if (cloneCopyPolicy != null) {
                    new CloneCopyPolicyMetadata((Annotation)cloneCopyPolicy, this.getAccessibleObject()).process(this.getDescriptor());
                }
            } else {
                if (copyPolicy != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", copyPolicy, this.getJavaClassName(), this.getLocation());
                }
                if (instantiationCopyPolicy != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", instantiationCopyPolicy, this.getJavaClassName(), this.getLocation());
                }
                if (cloneCopyPolicy != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", cloneCopyPolicy, this.getJavaClassName(), this.getLocation());
                }
                this.getCopyPolicy().process(this.getDescriptor());
            }
        }
    }

    protected void processCustomizer() {
        Object customizer = this.getAnnotation(Customizer.class);
        if (this.m_customizerClass != null && !this.m_customizerClass.equals(Void.TYPE) || customizer != null) {
            if (this.getDescriptor().hasCustomizer()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_customizer", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else {
                if (this.m_customizerClass == null || this.m_customizerClass.equals(Void.TYPE)) {
                    this.m_customizerClass = (Class)MetadataHelper.invokeMethod("value", customizer);
                } else if (customizer != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", customizer, this.getJavaClassName(), this.getLocation());
                }
                this.getProject().addAccessorWithCustomizer(this);
            }
        }
    }

    protected void processProperties() {
        PropertyMetadata property2;
        for (PropertyMetadata property2 : this.getProperties()) {
            this.getDescriptor().addProperty(property2);
        }
        Object properties = this.getAnnotation(Properties.class);
        if (properties != null) {
            for (Annotation property3 : (Annotation[])MetadataHelper.invokeMethod("value", properties)) {
                this.getDescriptor().addProperty(new PropertyMetadata(property3, this.getAccessibleObject()));
            }
        }
        if ((property2 = this.getAnnotation(Property.class)) != null) {
            this.getDescriptor().addProperty(new PropertyMetadata((Annotation)((Object)property2), this.getAccessibleObject()));
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setAttributes(XMLAttributes attributes) {
        this.m_attributes = attributes;
    }

    public void setChangeTracking(ChangeTrackingMetadata changeTracking) {
        this.m_changeTracking = changeTracking;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setCloneCopyPolicy(CloneCopyPolicyMetadata copyPolicy) {
        this.m_cloneCopyPolicy = copyPolicy;
    }

    public void setCustomCopyPolicy(CustomCopyPolicyMetadata copyPolicy) {
        this.m_customCopyPolicy = copyPolicy;
    }

    public void setCustomizerClassName(String customizerClassName) {
        this.m_customizerClassName = customizerClassName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setExcludeDefaultMappings(Boolean excludeDefaultMappings) {
        this.m_excludeDefaultMappings = excludeDefaultMappings;
    }

    public void setInstantiationCopyPolicy(InstantiationCopyPolicyMetadata copyPolicy) {
        this.m_instantiationCopyPolicy = copyPolicy;
    }

    public void setJavaClass(Class cls) {
        this.getAccessibleObject().setAnnotatedElement(cls);
        this.getDescriptor().setJavaClass(cls);
    }

    public void setMetadataComplete(Boolean metadataComplete) {
        this.m_metadataComplete = metadataComplete;
    }
}

