/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.platform.database.oracle;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTZWrapper;

public class TIMESTAMPHelper {
    public static TIMESTAMPTZ buildTIMESTAMPTZ(Calendar cal, Connection con) {
        try {
            if (con.getMetaData().getDriverVersion().startsWith("9.") || con.getMetaData().getDriverVersion().startsWith("10.")) {
                return new TIMESTAMPTZ(con, Helper.printCalendar(cal, false), cal);
            }
            return new TIMESTAMPTZ(con, new Timestamp(cal.getTimeInMillis()), cal);
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    public static Calendar buildCalendar(TIMESTAMPTZWrapper timestampTZ) throws SQLException {
        Timestamp ts = timestampTZ.getTimestamp();
        TimeZone tz = timestampTZ.getTimeZone();
        Calendar gCal = Calendar.getInstance();
        gCal.setTime(ts);
        gCal.getTimeZone().setID(tz.getID());
        gCal.getTimeZone().setRawOffset(tz.getRawOffset());
        return gCal;
    }

    public static Calendar buildCalendar(TIMESTAMPLTZWrapper timestampLTZ) throws SQLException {
        Calendar gCal = timestampLTZ.getZoneId() != null ? Calendar.getInstance(TimeZone.getTimeZone(timestampLTZ.getZoneId())) : Calendar.getInstance();
        Calendar localCalendar = Helper.allocateCalendar();
        localCalendar.setTime(timestampLTZ.getTimestamp());
        gCal.set(localCalendar.get(1), localCalendar.get(2), localCalendar.get(5), localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
        Helper.releaseCalendar(localCalendar);
        gCal.set(14, timestampLTZ.getTimestamp().getNanos() / 1000000);
        return gCal;
    }

    public static String printCalendar(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        StringWriter writer = new StringWriter();
        writer.write(Helper.printCalendar(calendar, false));
        writer.write(" ");
        writer.write(calendar.getTimeZone().getID());
        return writer.toString();
    }

    public static TimeZone extractTimeZone(byte[] bytes) {
        String regionName = null;
        if ((bytes[11] & 0xFFFFFF80) != 0) {
            int regionCode = (bytes[11] & 0x7F) << 6;
            regionName = new String(ZONEIDMAP.getRegion((int)(regionCode += (bytes[12] & 0xFC) >> 2)));
        } else {
            int hourOffset = bytes[11] - 20;
            int minuteOffset = bytes[12] - 60;
            String offset = Helper.buildZeroPrefix(hourOffset, 2) + ":" + Helper.buildZeroPrefix(minuteOffset, 2);
            regionName = "GMT" + offset;
        }
        return TimeZone.getTimeZone(regionName);
    }
}

