/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

public class RepeatableWriteUnitOfWork
extends UnitOfWorkImpl {
    protected UnitOfWorkChangeSet cumulativeUOWChangeSet;
    protected Map unregisteredDeletedObjectsCloneToBackupAndOriginal;
    protected boolean shouldTerminateTransaction = true;
    protected transient String flushClearCache;
    protected transient Set<Class> classesToBeInvalidated;

    public RepeatableWriteUnitOfWork(AbstractSession parentSession, ReferenceMode referenceMode) {
        super(parentSession, referenceMode);
        this.shouldNewObjectsBeCached = true;
    }

    public void clear(boolean shouldClearCache) {
        super.clear(shouldClearCache);
        if (this.cumulativeUOWChangeSet != null) {
            if (this.flushClearCache == null) {
                this.flushClearCache = PropertiesHandler.getSessionPropertyValueLogDebug("eclipselink.flush-clear.cache", this);
                if (this.flushClearCache == null) {
                    this.flushClearCache = "DropInvalidate";
                }
            }
            if (this.flushClearCache == "Drop") {
                this.cumulativeUOWChangeSet = null;
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            } else if (this.flushClearCache == "DropInvalidate") {
                Set<Class> updatedObjectsClasses = this.cumulativeUOWChangeSet.findUpdatedObjectsClasses();
                if (updatedObjectsClasses != null) {
                    if (this.classesToBeInvalidated == null) {
                        this.classesToBeInvalidated = updatedObjectsClasses;
                    } else {
                        this.classesToBeInvalidated.addAll(updatedObjectsClasses);
                    }
                }
                if (!this.unregisteredDeletedObjectsCloneToBackupAndOriginal.isEmpty()) {
                    if (this.classesToBeInvalidated == null) {
                        this.classesToBeInvalidated = new HashSet<Class>();
                    }
                    Iterator enumDeleted = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keySet().iterator();
                    while (enumDeleted.hasNext()) {
                        this.classesToBeInvalidated.add(enumDeleted.next().getClass());
                    }
                }
                this.cumulativeUOWChangeSet = null;
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            }
        }
    }

    public void clearForClose(boolean shouldClearCache) {
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
        super.clearForClose(shouldClearCache);
    }

    public boolean shouldClearForCloseOnRelease() {
        return true;
    }

    protected ClassDescriptor checkHierarchyForDescriptor(Class theClass) {
        ClassDescriptor descriptor = this.getDescriptor(theClass.getSuperclass());
        if (descriptor != null && descriptor.getInheritancePolicy().getDescribesNonPersistentSubclasses()) {
            return descriptor;
        }
        return null;
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(false);
        if (this.cumulativeUOWChangeSet != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
        this.mergeChangesIntoParent();
    }

    public void discoverUnregisteredNewObjects(Map clones, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects) {
        Iterator clonesEnum = clones.keySet().iterator();
        while (clonesEnum.hasNext()) {
            this.discoverAndPersistUnregisteredNewObjects(clonesEnum.next(), false, newObjects, unregisteredExistingObjects, visitedObjects);
        }
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2;
    }

    public boolean isObjectDeleted(Object object) {
        if (super.isObjectDeleted(object)) {
            return true;
        }
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && this.unregisteredDeletedObjectsCloneToBackupAndOriginal.containsKey(object)) {
            return true;
        }
        if (this.hasObjectsDeletedDuringCommit()) {
            return this.getObjectsDeletedDuringCommit().containsKey(object);
        }
        return false;
    }

    public void issueSQLbeforeCompletion() {
        super.issueSQLbeforeCompletion(false);
        if (this.cumulativeUOWChangeSet != null && this.getUnitOfWorkChangeSet() != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
    }

    protected void mergeChangesIntoParent() {
        if (this.classesToBeInvalidated != null) {
            IdentityMapAccessor accessor = this.getParentIdentityMapSession(null, false, true).getIdentityMapAccessor();
            Iterator<Class> it = this.classesToBeInvalidated.iterator();
            while (it.hasNext()) {
                accessor.invalidateClass(it.next(), false);
            }
            this.classesToBeInvalidated = null;
        }
        this.flushClearCache = null;
        super.mergeChangesIntoParent();
    }

    public Object mergeCloneWithReferences(Object rmiClone, MergeManager manager) {
        Object mergedObject = super.mergeCloneWithReferences(rmiClone, manager);
        for (Object newObjectClone : manager.getMergedNewObjects().values()) {
            ClassDescriptor descriptor = this.getDescriptor(newObjectClone);
            this.assignSequenceNumber(newObjectClone, descriptor);
            this.registerNewObjectInIdentityMap(newObjectClone, null, descriptor);
        }
        return mergedObject;
    }

    public void updateChangeTrackersIfRequired(Object objectToWrite, ObjectChangeSet changeSetToWrite, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        descriptor.getObjectChangePolicy().updateWithChanges(objectToWrite, changeSetToWrite, uow, descriptor);
    }

    public void writeChanges() {
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal == null) {
            this.unregisteredDeletedObjectsCloneToBackupAndOriginal = new IdentityHashMap(2);
        }
        if (this.getUnitOfWorkChangeSet() == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
        }
        this.calculateChanges(this.getCloneMapping(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), true);
        UnitOfWorkChangeSet changeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (!(changeSet.hasChanges() || changeSet.hasForcedChanges() || this.hasDeletedObjects() || this.hasModifyAllQueries())) {
            return;
        }
        try {
            this.commitToDatabaseWithPreBuiltChangeSet(changeSet, false);
            this.writesCompleted();
        }
        catch (RuntimeException exception) {
            this.clearFlushClearCache();
            this.setLifecycle(3);
            throw exception;
        }
        for (Object clone : this.getNewObjectsCloneToOriginal().keySet()) {
            Object original = this.getNewObjectsCloneToOriginal().get(clone);
            if (original == null) continue;
            this.getCloneToOriginals().put(clone, original);
        }
        this.getNewObjectsCloneToOriginal().clear();
        this.getNewObjectsOriginalToClone().clear();
        this.getUnregisteredExistingObjects().clear();
        this.getUnregisteredNewObjects().clear();
        this.getDeletedObjects().clear();
        for (Object deletedObject : this.getObjectsDeletedDuringCommit().keySet()) {
            Object[] backupAndOriginal = new Object[]{this.getCloneMapping().get(deletedObject), this.getCloneToOriginals().get(deletedObject)};
            this.unregisteredDeletedObjectsCloneToBackupAndOriginal.put(deletedObject, backupAndOriginal);
            this.unregisterObject(deletedObject);
        }
        this.getObjectsDeletedDuringCommit().clear();
        if (this.cumulativeUOWChangeSet == null) {
            this.cumulativeUOWChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        } else {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
        }
        this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
        this.changeTrackedHardList = null;
    }

    protected void registerNotRegisteredNewObjectForPersist(Object newObject, ClassDescriptor descriptor) {
        Object[] backupAndOriginal;
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && (backupAndOriginal = (Object[])this.unregisteredDeletedObjectsCloneToBackupAndOriginal.remove(newObject)) != null) {
            this.getCloneMapping().put(newObject, backupAndOriginal[0]);
            this.registerNewObjectClone(newObject, backupAndOriginal[1], descriptor);
            this.registerNewObjectInIdentityMap(newObject, newObject, descriptor);
            return;
        }
        super.registerNotRegisteredNewObjectForPersist(newObject, descriptor);
    }

    public void rollbackTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.rollbackTransaction();
        } else {
            this.setWasTransactionBegunPrematurely(true);
        }
    }

    public void synchronizeAndResume() {
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
        super.synchronizeAndResume();
    }

    public boolean wasDeleted(Object original) {
        return this.getUnregisteredDeletedCloneForOriginal(original) != null;
    }

    protected Object cloneAndRegisterNewObject(Object original) {
        ClassDescriptor descriptor = this.getDescriptor(original);
        if (this.isNestedUnitOfWork() && descriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object clone = builder.instantiateWorkingCopyClone(original, this);
        Object newOriginal = builder.buildNewInstance();
        this.getNewObjectsOriginalToClone().put(original, clone);
        this.getCloneMapping().put(clone, clone);
        builder.populateAttributesForClone(original, clone, this);
        this.registerNewObjectClone(clone, newOriginal, descriptor);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(clone, builder, this);
        this.getCloneMapping().put(clone, backupClone);
        return clone;
    }

    public Object getUnregisteredDeletedCloneForOriginal(Object original) {
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null) {
            Iterator keys = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keySet().iterator();
            Iterator values = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.values().iterator();
            while (keys.hasNext()) {
                Object deletedObjectClone = keys.next();
                Object[] backupAndOriginal = (Object[])values.next();
                Object currentOriginal = backupAndOriginal[1];
                if (original != currentOriginal) continue;
                return deletedObjectClone;
            }
        }
        return null;
    }

    protected void commitToDatabase(boolean commitTransaction) {
        try {
            super.commitToDatabase(commitTransaction);
        }
        catch (OptimisticLockException ole) {
            throw new javax.persistence.OptimisticLockException((Throwable)ole);
        }
    }

    public void commitTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.commitTransaction();
        }
    }

    public void setShouldTerminateTransaction(boolean shouldTerminateTransaction) {
        this.shouldTerminateTransaction = shouldTerminateTransaction;
    }

    public void clearFlushClearCache() {
        this.flushClearCache = null;
        this.classesToBeInvalidated = null;
    }
}

