/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployable;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class DeployerFactory {
    public static final String DEPLOYER_FACTORY_CLASS_NAME = DeployerFactory.class.getName();
    private static final String DEFAULT_DEPLOYER = "org.ow2.easybeans.deployer.EasyBeansDeployer";
    private static Log logger = LogFactory.getLog(DeployerFactory.class);
    private static String className = null;
    private static IDeployer deployer = null;

    private DeployerFactory() {
    }

    public static IDeployer getDeployer(EZBServer embedded) throws DeployerException {
        Class<?> clazz;
        if (deployer != null) {
            return deployer;
        }
        if (className == null) {
            className = DEFAULT_DEPLOYER;
        }
        String clName = System.getProperty(DEPLOYER_FACTORY_CLASS_NAME, className);
        logger.debug((Object)"Using ''{0}'' as deployer class", new Object[]{clName});
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(clName);
        }
        catch (ClassNotFoundException e) {
            throw new DeployerException("Cannot load the deployer class named '" + clName + "'.", (Throwable)e);
        }
        Class<?> depClass = null;
        if (!IDeployer.class.isAssignableFrom(clazz)) {
            throw new DeployerException("The class '" + clName + "' is not an EZBDeployer class");
        }
        depClass = clazz;
        try {
            deployer = (IDeployer)depClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeployerException("Cannot instantiate the class '" + clName + "'.");
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot instantiate the class '" + clName + "'.");
        }
        Method m = null;
        try {
            m = depClass.getMethod("setEmbedded", EZBServer.class);
        }
        catch (SecurityException e) {
            logger.debug((Object)"Cannot get the method setEmbedded", new Object[]{e});
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)"Cannot get the method setEmbedded", new Object[]{e});
        }
        if (m != null) {
            try {
                m.invoke((Object)deployer, embedded);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Cannot call setEmbedded", new Object[]{e});
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"Cannot call setEmbedded", new Object[]{e});
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"Cannot call setEmbedded", new Object[]{e});
            }
        }
        return deployer;
    }

    public static void setClassName(String classNameStr) {
        className = classNameStr;
    }
}

