/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.jacc.provider;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfigurationKeeper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JPolicyConfiguration
implements PolicyConfiguration {
    private State state;
    private String contextID = null;
    private static Log logger = LogFactory.getLog(JPolicyConfiguration.class);
    private PermissionCollection excludedPermissions = null;
    private PermissionCollection uncheckedPermissions = null;
    private Map<String, PermissionCollection> rolePermissions = null;

    public JPolicyConfiguration(String contextID) {
        this.contextID = contextID;
        this.resetState();
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.rolePermissions = new HashMap<String, PermissionCollection>();
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        logger.debug((Object)"Adding permission ''{0}'' as excluded policy.", new Object[]{permission});
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (permission != null) {
            this.excludedPermissions.add(permission);
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        logger.debug((Object)"Adding permissions ''{0}'' as excluded policy.", new Object[]{permissions});
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (permissions != null) {
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.excludedPermissions.add(e.nextElement());
            }
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        logger.debug((Object)"Adding permission ''{0}'' to role ''{1}''.", new Object[]{permission, roleName});
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (roleName == null) {
            throw new PolicyContextException(logger.getI18n().getMessage("JPolicyConfiguration.addToRole", new Object[0]));
        }
        if (permission == null) {
            return;
        }
        PermissionCollection permissionsOfRole = this.rolePermissions.get(roleName);
        if (permissionsOfRole == null) {
            permissionsOfRole = new Permissions();
        }
        permissionsOfRole.add(permission);
        this.rolePermissions.put(roleName, permissionsOfRole);
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        logger.debug((Object)"Adding permissions ''{0}'' to role ''{1}''.", new Object[]{permissions, roleName});
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (roleName == null) {
            throw new PolicyContextException(logger.getI18n().getMessage("JPolicyConfiguration.addToRole", new Object[0]));
        }
        if (permissions == null) {
            return;
        }
        PermissionCollection permissionsOfRole = this.rolePermissions.get(roleName);
        if (permissionsOfRole == null) {
            permissionsOfRole = new Permissions();
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            permissionsOfRole.add(e.nextElement());
        }
        this.rolePermissions.put(roleName, permissionsOfRole);
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        logger.debug((Object)"Adding permission ''{0}'' as unchecked policy.", new Object[]{permission});
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (permission != null) {
            this.uncheckedPermissions.add(permission);
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        logger.debug((Object)"Adding permissions ''{0}'' as unchecked policy.", new Object[]{permissions});
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (permissions != null) {
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.uncheckedPermissions.add(e.nextElement());
            }
        }
    }

    public void commit() throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateNotInState(State.DELETED);
        this.state = State.IN_SERVICE;
        JPolicyConfigurationKeeper.addConfiguration(this);
    }

    public void delete() throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.rolePermissions = new HashMap<String, PermissionCollection>();
        this.state = State.DELETED;
        JPolicyConfigurationKeeper.removeConfiguration(this);
    }

    public String getContextID() throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        return this.contextID;
    }

    public boolean inService() throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        return this.state == State.IN_SERVICE;
    }

    public void linkConfiguration(PolicyConfiguration link) throws IllegalArgumentException, PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        if (this.equals(link)) {
            throw new IllegalArgumentException(logger.getI18n().getMessage("JPolicyConfiguration.linkConfiguration.equivalent", new Object[]{this, link}));
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        this.excludedPermissions = new Permissions();
    }

    public void removeRole(String roleName) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        this.rolePermissions.remove(roleName);
    }

    public void removeUncheckedPolicy() throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(State.OPEN);
        this.uncheckedPermissions = new Permissions();
    }

    private void checkCurrentStateNotInState(State s) throws UnsupportedOperationException {
        if (this.state == s) {
            String err = logger.getI18n().getMessage("JPolicyConfiguration.checkCurrentStateNotInState.notValidState", new Object[]{s, this.state});
            throw new UnsupportedOperationException(err);
        }
    }

    private void checkCurrentStateIsInState(State s) throws UnsupportedOperationException {
        if (this.state != s) {
            String err = logger.getI18n().getMessage("JPolicyConfiguration.checkCurrentStateNotInState.notValidState", new Object[]{this.state, s});
            throw new UnsupportedOperationException(err);
        }
    }

    private void checkSetPolicy() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolicyConfiguration)) {
            logger.error((Object)"JPolicyConfiguration.equals.notInstanceOf", new Object[0]);
            return false;
        }
        try {
            return this.contextID.equals(((PolicyConfiguration)obj).getContextID());
        }
        catch (PolicyContextException pce) {
            logger.error((Object)"JPolicyConfiguration.equals.canNotCheck", new Object[]{pce});
            return false;
        }
    }

    public int hashCode() {
        return this.contextID.hashCode();
    }

    protected void resetState() {
        this.state = State.OPEN;
    }

    public PermissionCollection getExcludedPermissions() {
        if (this.state != State.IN_SERVICE) {
            return new Permissions();
        }
        return this.excludedPermissions;
    }

    public PermissionCollection getUncheckedPermissions() {
        if (this.state != State.IN_SERVICE) {
            return new Permissions();
        }
        return this.uncheckedPermissions;
    }

    public PermissionCollection getPermissionsForPrincipal(Principal principal) {
        logger.debug((Object)"principal = ''{0}''", new Object[]{principal});
        if (principal == null || this.state != State.IN_SERVICE) {
            return new Permissions();
        }
        PermissionCollection permissionsOfRole = this.rolePermissions.get(principal.getName());
        logger.debug((Object)"Permissions found = ''{0}''", new Object[]{permissionsOfRole});
        if (permissionsOfRole == null) {
            permissionsOfRole = new Permissions();
        }
        return permissionsOfRole;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        OPEN,
        IN_SERVICE,
        DELETED;

    }
}

