/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = org.omg.CORBA.ORB.init(var0, null);
        var2_2 = ((ORB)var1_1).getConfiguration().getNamedLogger("jacorb.print_ior");
        var4_3 = null;
        if (var0.length < 1 || var0.length > 2) {
            System.err.println("Usage: java PrintIOR [ ior_str | -f filename ]");
            System.exit(1);
        }
        if (var0[0].equals("-f")) {
            try {
                var5_4 = new BufferedReader(new FileReader(var0[1]), 2048);
                var3_6 = var5_4.readLine();
                if (var3_6 == null) ** GOTO lbl24
                var4_3 = var3_6;
                while (var3_6 != null) {
                    var3_6 = var5_4.readLine();
                    if (var3_6 == null) continue;
                    var4_3 = var4_3 + var3_6;
                }
            }
            catch (IOException var5_5) {
                var5_5.printStackTrace();
                System.exit(1);
            }
        } else {
            var4_3 = var0[0];
        }
lbl24:
        // 4 sources

        if (var4_3.startsWith("IOR:")) {
            var5_4 = new ParsedIOR(var4_3, var1_1, var2_2);
            PrintIOR.printIOR((ParsedIOR)var5_4, var1_1);
        } else {
            System.out.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
        var1_1.shutdown(true);
    }

    public static void printIOR(ParsedIOR parsedIOR, org.omg.CORBA.ORB oRB) {
        IOR iOR = parsedIOR.getIOR();
        System.out.println("------IOR components-----");
        System.out.println("TypeId\t:\t" + iOR.type_id);
        List list = parsedIOR.getProfiles();
        System.out.println("TAG_INTERNET_IOP Profiles:");
        for (int i = 0; i < list.size(); ++i) {
            System.out.print("\tProfile Id:  ");
            IIOPProfile iIOPProfile = (IIOPProfile)list.get(i);
            System.out.println("\tIIOP Version :  " + iIOPProfile.version().major + "." + iIOPProfile.version().minor);
            System.out.println("\tHost\t:\t" + ((IIOPAddress)iIOPProfile.getAddress()).getOriginalHost());
            int n = ((IIOPAddress)iIOPProfile.getAddress()).getPort();
            if (n < 0) {
                n += 65536;
            }
            System.out.println("\tPort\t:\t" + n);
            try {
                System.out.println("\tObject key (URL):      " + CorbaLoc.parseKey(parsedIOR.get_object_key()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.print("\tObject key (hex):    0x");
            PrintIOR.dumpHex(parsedIOR.get_object_key());
            System.out.println();
            if (iIOPProfile.version().minor >= 1) {
                if (iIOPProfile.getComponents().size() > 0) {
                    System.out.println("\t-- Found " + iIOPProfile.getComponents().size() + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(iIOPProfile.getComponents().asArray());
            }
            System.out.print("\n");
        }
        TaggedComponentList taggedComponentList = parsedIOR.getMultipleComponents();
        if (taggedComponentList.size() > 0) {
            System.out.println("Components in MULTIPLE_COMPONENTS profile: " + taggedComponentList.size());
            PrintIOR.printTaggedComponents(taggedComponentList.asArray());
        }
    }

    private static void printTaggedComponents(TaggedComponent[] taggedComponentArray) {
        block10: for (int i = 0; i < taggedComponentArray.length; ++i) {
            switch (taggedComponentArray[i].tag) {
                case 20: {
                    System.out.println("\t#" + i + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponentArray[i]);
                    continue block10;
                }
                case 33: {
                    System.out.println("\t#" + i + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponentArray[i]);
                    continue block10;
                }
                case 35: {
                    System.out.println("\t#" + i + ": TAG_SECIOP_SEC_TRANS");
                    continue block10;
                }
                case 3: {
                    System.out.println("\t#" + i + ": TAG_ALTERNATE_IIOP_ADDRESS");
                    PrintIOR.printAlternateAddress(taggedComponentArray[i]);
                    continue block10;
                }
                case 1: {
                    System.out.println("\t#" + i + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponentArray[i]);
                    continue block10;
                }
                case 25: {
                    System.out.println("\t#" + i + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponentArray[i]);
                    continue block10;
                }
                case 0: {
                    System.out.println("\t#" + i + ": TAG_ORB_TYPE");
                    PrintIOR.printOrbTypeComponent(taggedComponentArray[i]);
                    continue block10;
                }
                case 34: {
                    System.out.println("\t#" + i + ": TAG_NULL_TAG");
                    continue block10;
                }
                default: {
                    System.out.println("\tUnknown tag : " + taggedComponentArray[i].tag);
                }
            }
        }
    }

    private static void printCSIMechComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        CompoundSecMechList compoundSecMechList = CompoundSecMechListHelper.read(cDRInputStream);
        if (compoundSecMechList != null) {
            System.out.println("\t\tis stateful: " + compoundSecMechList.stateful);
            for (int i = 0; i < compoundSecMechList.mechanism_list.length; ++i) {
                System.out.println("\t\tCompoundSecMech #" + i);
                System.out.println("\t\t\ttarget_requires: " + compoundSecMechList.mechanism_list[i].target_requires);
                System.out.print("\t\t\ttransport mechanism tag: ");
                switch (compoundSecMechList.mechanism_list[i].transport_mech.tag) {
                    case 36: {
                        System.out.println("TAG_TLS_SEC_TRANS");
                        PrintIOR.printTlsSecTrans(compoundSecMechList.mechanism_list[i].transport_mech.component_data);
                        break;
                    }
                    case 34: {
                        System.out.println("TAG_NULL_TAG");
                        break;
                    }
                    default: {
                        System.out.println("Unknown tag : " + compoundSecMechList.mechanism_list[i].transport_mech.tag);
                    }
                }
                System.out.println("\t\t\tAS_ContextSec target_supports: " + compoundSecMechList.mechanism_list[i].as_context_mech.target_supports);
                System.out.println("\t\t\tAS_ContextSec target_requires: " + compoundSecMechList.mechanism_list[i].as_context_mech.target_requires);
                System.out.print("\t\t\tAS_ContextSec mech: ");
                PrintIOR.dumpHex(compoundSecMechList.mechanism_list[i].as_context_mech.client_authentication_mech);
                System.out.println();
                System.out.print("\t\t\tAS_ContextSec target_name: ");
                PrintIOR.printNTExportedName(compoundSecMechList.mechanism_list[i].as_context_mech.target_name);
                System.out.println("\t\t\tSAS_ContextSec target_supports: " + compoundSecMechList.mechanism_list[i].sas_context_mech.target_supports);
                System.out.println("\t\t\tSAS_ContextSec target_requires: " + compoundSecMechList.mechanism_list[i].sas_context_mech.target_requires);
                for (int j = 0; j < compoundSecMechList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms.length; ++j) {
                    System.out.print("\t\t\tSAS_ContextSec Naming mech: ");
                    PrintIOR.dumpHex(compoundSecMechList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms[j]);
                    System.out.println();
                }
                System.out.println("\t\t\tSAS_ContextSec Naming types: " + compoundSecMechList.mechanism_list[i].sas_context_mech.supported_identity_types);
                System.out.println();
            }
        }
    }

    private static void printNTExportedName(byte[] byArray) {
        if (byArray.length < 2 || byArray[0] != 4 || byArray[1] != 1) {
            PrintIOR.dumpHex(byArray);
            System.out.println();
            return;
        }
        int n = (byArray[2] << 8) + byArray[3];
        if (n > byArray.length - 8) {
            PrintIOR.dumpHex(byArray);
            System.out.println();
            return;
        }
        int n2 = (byArray[n + 4] << 24) + (byArray[n + 5] << 16) + (byArray[n + 6] << 8) + byArray[n + 7];
        if (n + n2 > byArray.length - 8) {
            PrintIOR.dumpHex(byArray);
            System.out.println();
            return;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n + 8, byArray2, 0, n2);
        System.out.println(new String(byArray2));
    }

    private static void printTlsSecTrans(byte[] byArray) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        try {
            cDRInputStream.openEncapsulatedArray();
            TLS_SEC_TRANS tLS_SEC_TRANS = TLS_SEC_TRANSHelper.read(cDRInputStream);
            System.out.println("\t\t\tTLS SEC TRANS target requires: " + tLS_SEC_TRANS.target_requires);
            System.out.println("\t\t\tTLS SEC TRANS target supports: " + tLS_SEC_TRANS.target_supports);
            for (int i = 0; i < tLS_SEC_TRANS.addresses.length; ++i) {
                int n = tLS_SEC_TRANS.addresses[i].port;
                if (n < 0) {
                    n += 65536;
                }
                System.out.println("\t\t\tTLS SEC TRANS address: " + tLS_SEC_TRANS.addresses[i].host_name + ":" + n);
            }
        }
        catch (Exception exception) {
            System.out.print("\t\t\tTLS SEC TRANS: ");
            PrintIOR.dumpHex(byArray);
            System.out.println();
        }
    }

    private static void printCodeSetComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        CodeSetComponentInfo codeSetComponentInfo = CodeSetComponentInfoHelper.read(cDRInputStream);
        if (codeSetComponentInfo != null) {
            int n;
            System.out.println("\t\tForChar native code set Id: " + CodeSet.csName(codeSetComponentInfo.ForCharData.native_code_set));
            System.out.print("\t\tChar Conversion Code Sets: ");
            for (n = 0; n < codeSetComponentInfo.ForCharData.conversion_code_sets.length; ++n) {
                System.out.println(CodeSet.csName(codeSetComponentInfo.ForCharData.conversion_code_sets[n]));
                if (n >= codeSetComponentInfo.ForCharData.conversion_code_sets.length - 1) continue;
                System.out.print(", ");
            }
            System.out.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSetComponentInfo.ForWcharData.native_code_set));
            System.out.print("\t\tWChar Conversion Code Sets: ");
            for (n = 0; n < codeSetComponentInfo.ForWcharData.conversion_code_sets.length; ++n) {
                System.out.println(CodeSet.csName(codeSetComponentInfo.ForWcharData.conversion_code_sets[n]));
                if (n >= codeSetComponentInfo.ForWcharData.conversion_code_sets.length - 1) continue;
                System.out.print(", ");
            }
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent) {
        SSL sSL = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
            try {
                cDRInputStream.openEncapsulatedArray();
                sSL = SSLHelper.read(cDRInputStream);
            }
            catch (Exception exception) {
                return;
            }
            int n = sSL.port;
            if (n < 0) {
                n += 65536;
            }
            System.out.print("\t\ttarget_supports\t:\t");
            PrintIOR.decodeAssociationOption(sSL.target_supports);
            System.out.println();
            System.out.print("\t\ttarget_requires\t:\t");
            PrintIOR.decodeAssociationOption(sSL.target_requires);
            System.out.println();
            System.out.println("\t\tSSL Port\t:\t" + n);
        }
    }

    private static void decodeAssociationOption(int n) {
        boolean bl = true;
        if ((n & 1) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("NoProtection");
            bl = false;
        }
        if ((n & 2) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("Integrity");
            bl = false;
        }
        if ((n & 4) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("Confidentiality");
            bl = false;
        }
        if ((n & 8) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("DetectReplay");
            bl = false;
        }
        if ((n & 0x10) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("DetectMisordering");
            bl = false;
        }
        if ((n & 0x20) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("EstablishTrustInTarget");
            bl = false;
        }
        if ((n & 0x40) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("EstablishTrustInClient");
            bl = false;
        }
        if ((n & 0x80) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("NoDelegation");
            bl = false;
        }
        if ((n & 0x100) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("SimpleDelegation");
            bl = false;
        }
        if ((n & 0x200) != 0) {
            if (!bl) {
                System.out.print(", ");
            }
            System.out.print("CompositeDelegation");
            bl = false;
        }
    }

    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        String string = cDRInputStream.read_string();
        System.out.println("\t\tCodebase: " + string);
    }

    private static void printOrbTypeComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        int n = cDRInputStream.read_long();
        System.out.print("\t\tType: " + n);
        if (n == 1245790976) {
            System.out.println(" (JacORB)");
        } else {
            System.out.println(" (Foreign)");
        }
    }

    private static void printAlternateAddress(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        System.out.println("\t\tAddress: " + IIOPAddress.read(cDRInputStream));
    }

    public static void dumpHex(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xFF) / 16;
            int n2 = (byArray[i] & 0xFF) % 16;
            char c = (char)(n > 9 ? 65 + (n - 10) : 48 + n);
            char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            System.out.print("" + c + c2 + " ");
        }
    }

    public static void dump(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            PrintIOR.dump(byArray[i]);
            System.out.print(" ");
        }
    }

    public static void dump(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            PrintIOR.dump(nArray[i]);
            System.out.print(" ");
        }
    }

    public static void dump(byte by) {
        System.out.print("" + hexDigit[by >> 4 & 0xF] + hexDigit[by & 0xF]);
    }

    public static void dump(short s) {
        System.out.print("" + hexDigit[s >> 12 & 0xF] + hexDigit[s >> 9 & 0xF] + hexDigit[s >> 4 & 0xF] + hexDigit[s & 0xF]);
    }

    public static void dump(int n) {
        System.out.print("" + hexDigit[n >> 28 & 0xF] + hexDigit[n >> 24 & 0xF] + hexDigit[n >> 20 & 0xF] + hexDigit[n >> 16 & 0xF] + hexDigit[n >> 12 & 0xF] + hexDigit[n >> 8 & 0xF] + hexDigit[n >> 4 & 0xF] + hexDigit[n & 0xF]);
    }

    public static void dump(byte[] byArray, boolean bl) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (0 == i % 16) {
                System.out.println();
            }
            char c = byArray[i] > 31 && byArray[i] < 127 ? (char)((char)byArray[i]) : (char)' ';
            System.out.print(":" + hexDigit[byArray[i] >> 4 & 0xF] + hexDigit[byArray[i] & 0xF] + " " + c);
        }
    }
}

