/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.util.StringPair;

public class RequestQueue
implements Configurable {
    private RequestQueueListener queueListener;
    private RequestController controller;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger;
    private int queueMin;
    private int queueMax;
    private boolean queueWait;
    private boolean configured = false;
    private List queue = new ArrayList(10);

    private RequestQueue() {
    }

    protected RequestQueue(RequestController requestController) {
        this.controller = requestController;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.poa.queue");
        this.queueMax = this.configuration.getAttributeAsInteger("jacorb.poa.queue_max", 100);
        this.queueMin = this.configuration.getAttributeAsInteger("jacorb.poa.queue_min", 10);
        this.queueWait = this.configuration.getAttributeAsBoolean("jacorb.poa.queue_wait", false);
        this.configured = true;
    }

    protected synchronized void add(ServerRequest serverRequest) throws ResourceLimitReachedException {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        if (this.queue.size() >= this.queueMax) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Request queue is full, consider increasing jacorb.poa.queue_max (currently: " + this.queueMax + ")");
            }
            if (this.queueWait) {
                while (this.queue.size() > this.queueMin) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                throw new ResourceLimitReachedException();
            }
        }
        this.queue.add(serverRequest);
        if (this.queue.size() == 1) {
            this.controller.continueToWork();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " is queued (queue size: " + this.queue.size() + ")");
        }
        if (this.queueListener != null) {
            this.queueListener.requestAddedToQueue(serverRequest, this.queue.size());
        }
    }

    protected synchronized void addRequestQueueListener(RequestQueueListener requestQueueListener) {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        this.queueListener = EventMulticaster.add(this.queueListener, requestQueueListener);
    }

    protected synchronized StringPair[] deliverContent() {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        StringPair[] stringPairArray = new StringPair[this.queue.size()];
        Iterator iterator = this.queue.iterator();
        for (int i = 0; i < stringPairArray.length; ++i) {
            ServerRequest serverRequest = (ServerRequest)iterator.next();
            stringPairArray[i] = new StringPair(serverRequest.requestId() + "", new String(serverRequest.objectId()));
        }
        return stringPairArray;
    }

    protected synchronized ServerRequest getElementAndRemove(int n) {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        if (!this.queue.isEmpty()) {
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                ServerRequest serverRequest = (ServerRequest)iterator.next();
                if (serverRequest.requestId() != n) continue;
                iterator.remove();
                this.notifyAll();
                if (this.queueListener != null) {
                    this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
                }
                return serverRequest;
            }
        }
        return null;
    }

    protected synchronized ServerRequest getFirst() {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        if (!this.queue.isEmpty()) {
            return (ServerRequest)this.queue.get(0);
        }
        return null;
    }

    protected boolean isEmpty() {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        return this.queue.isEmpty();
    }

    protected synchronized ServerRequest removeFirst() {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        if (!this.queue.isEmpty()) {
            ServerRequest serverRequest = (ServerRequest)this.queue.get(0);
            this.queue.remove(0);
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized ServerRequest removeLast() {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        if (!this.queue.isEmpty()) {
            int n = this.queue.size() - 1;
            ServerRequest serverRequest = (ServerRequest)this.queue.get(n);
            this.queue.remove(n);
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized void removeRequestQueueListener(RequestQueueListener requestQueueListener) {
        if (!this.configured) {
            throw new Error("RQ.add(): not configured!");
        }
        this.queueListener = EventMulticaster.remove(this.queueListener, requestQueueListener);
    }

    protected int size() {
        return this.queue.size();
    }
}

