/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerContextTransferInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private Codec codec = null;
    private int slot_id = -1;
    private Current ts_current;
    private ORB orb;
    private Logger logger;

    public ServerContextTransferInterceptor(Codec codec, int n, Current current, ORB oRB) {
        this.codec = codec;
        this.slot_id = n;
        this.ts_current = current;
        this.orb = oRB;
        this.logger = ((org.jacorb.orb.ORB)oRB).getConfiguration().getNamedLogger("jacorb.tx_service.interceptor");
    }

    public String name() {
        return "ServerContextTransferInterceptor";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        block2: {
            try {
                ServiceContext serviceContext = serverRequestInfo.get_request_service_context(0);
                serverRequestInfo.set_slot(this.slot_id, this.codec.decode(serviceContext.context_data));
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Exception", exception);
            }
        }
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        block2: {
            try {
                org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                PropagationContext propagationContext = PropagationContextHelper.extract(current.get_slot(this.slot_id));
                Control control = ControlHelper.extract(propagationContext.implementation_specific_data);
                this.ts_current.resume(control);
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Exception", exception);
            }
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.ts_current.suspend();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.ts_current.suspend();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.ts_current.suspend();
    }
}

