/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.Attributes;
import org.apache.commons.attributes.InvalidAttributeTargetError;
import org.apache.commons.attributes.Target;

class Util {
    Util() {
    }

    public static String getSignature(Method m) {
        return m.getName() + "(" + Util.getParameterList(m.getParameterTypes()) + ")";
    }

    public static String getSignature(Constructor c) {
        return "(" + Util.getParameterList(c.getParameterTypes()) + ")";
    }

    public static String decodedClassName(String rawName) throws IllegalArgumentException {
        if (!rawName.startsWith("[")) {
            return rawName;
        }
        StringBuffer nesting = new StringBuffer();
        int i = 0;
        while (rawName.charAt(i) == '[') {
            nesting.append("[]");
            ++i;
        }
        String type = "";
        switch (rawName.charAt(i)) {
            case 'B': {
                type = "byte";
                break;
            }
            case 'C': {
                type = "char";
                break;
            }
            case 'D': {
                type = "double";
                break;
            }
            case 'F': {
                type = "float";
                break;
            }
            case 'I': {
                type = "int";
                break;
            }
            case 'J': {
                type = "long";
                break;
            }
            case 'L': {
                type = rawName.substring(i + 1, rawName.length() - 1);
                break;
            }
            case 'S': {
                type = "short";
                break;
            }
            case 'Z': {
                type = "boolean";
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't decode " + rawName);
            }
        }
        return type + nesting.toString();
    }

    public static String getParameterList(Class[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Util.decodedClassName(params[i].getName()));
        }
        return sb.toString();
    }

    private static void checkTarget(int target, Object attribute, String element) {
        Target targetAttr = (Target)Attributes.getAttribute(attribute.getClass(), Target.class);
        if (targetAttr == null) {
            return;
        }
        if ((targetAttr.getFlags() & target) == 0) {
            throw new InvalidAttributeTargetError(attribute.getClass().getName(), element, targetAttr.getFlags());
        }
    }

    private static void checkTargets(int target, Collection attributes, String element) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            Util.checkTarget(target, iter.next(), element);
        }
    }

    public static void validateRepository(Class owningClass, AttributeRepositoryClass repo) {
        Util.checkTargets(1, repo.getClassAttributes(), owningClass.getName());
        Map fieldAttrs = repo.getFieldAttributes();
        Iterator iter = fieldAttrs.keySet().iterator();
        while (iter.hasNext()) {
            String fieldName = (String)iter.next();
            Util.checkTargets(2, (Collection)fieldAttrs.get(fieldName), owningClass.getName() + "." + fieldName);
        }
        Map ctorAttrs = repo.getConstructorAttributes();
        Iterator iter2 = ctorAttrs.keySet().iterator();
        while (iter2.hasNext()) {
            String ctorName = (String)iter2.next();
            List bundle = (List)ctorAttrs.get(ctorName);
            block9: for (int i = 0; i < bundle.size(); ++i) {
                switch (i) {
                    case 0: {
                        Util.checkTargets(8, (Collection)bundle.get(0), owningClass.getName() + "." + ctorName);
                        continue block9;
                    }
                    default: {
                        Util.checkTargets(32, (Collection)bundle.get(i), "parameter " + i + " of " + owningClass.getName() + ctorName);
                    }
                }
            }
        }
        Map methodAttrs = repo.getMethodAttributes();
        Iterator iter3 = methodAttrs.keySet().iterator();
        while (iter3.hasNext()) {
            String methodName = (String)iter3.next();
            List bundle = (List)methodAttrs.get(methodName);
            block11: for (int i = 0; i < bundle.size(); ++i) {
                switch (i) {
                    case 0: {
                        Util.checkTargets(4, (Collection)bundle.get(0), owningClass.getName() + "." + methodName);
                        continue block11;
                    }
                    case 1: {
                        Util.checkTargets(64, (Collection)bundle.get(1), "return value of " + owningClass.getName() + "." + methodName);
                        continue block11;
                    }
                    default: {
                        Util.checkTargets(16, (Collection)bundle.get(i), "parameter " + (i - 1) + " of " + owningClass.getName() + "." + methodName);
                    }
                }
            }
        }
    }
}

