/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.apache.tomcat.util.res.StringManager;

public class Http11NioProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected JSSEImplementation sslImplementation = null;
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    ObjectName tpOname;
    ObjectName rgOname;
    protected NioEndpoint ep = new NioEndpoint();
    protected boolean secure = false;
    protected Hashtable attributes = new Hashtable();
    private int maxKeepAliveRequests = 100;
    private int timeout = 300000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    protected int processorCache = 200;
    private int socketCloseDelay = -1;
    private boolean disableUploadTimeout = true;
    private int socketBuffer = 9000;
    private Adapter adapter;
    private Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String server;
    protected static Log log = LogFactory.getLog(Http11NioProtocol.class);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public Http11NioProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("http11protocol.setattribute", name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("http11protocol.getattribute", key));
        }
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        if (name != null && (name.startsWith("socket.") || name.startsWith("selectorPool."))) {
            return this.ep.setProperty(name, value);
        }
        return this.ep.setProperty(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        this.ep.setName(this.getName());
        this.ep.setHandler(this.cHandler);
        this.ep.getSocketProperties().setRxBufSize(Math.max(this.ep.getSocketProperties().getRxBufSize(), this.getMaxHttpHeaderSize()));
        this.ep.getSocketProperties().setTxBufSize(Math.max(this.ep.getSocketProperties().getTxBufSize(), this.getMaxHttpHeaderSize()));
        try {
            this.ep.init();
            this.sslImplementation = new JSSEImplementation();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.initerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.init", this.getName()));
        }
    }

    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.ep, this.tpOname, null);
            }
            catch (Exception e) {
                log.error("Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.ep.start();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.starterror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.start", this.getName()));
        }
    }

    public void pause() throws Exception {
        try {
            this.ep.pause();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.pauseerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.pause", this.getName()));
        }
    }

    public void resume() throws Exception {
        try {
            this.ep.resume();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.resumeerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.resume", this.getName()));
        }
    }

    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.stop", this.getName()));
        }
        this.ep.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public void setPollerThreadCount(int count) {
        this.ep.setPollerThreadCount(count);
    }

    public int getPollerThreadCount() {
        return this.ep.getPollerThreadCount();
    }

    public void setSelectorTimeout(long timeout) {
        this.ep.setSelectorTimeout(timeout);
    }

    public long getSelectorTimeout() {
        return this.ep.getSelectorTimeout();
    }

    public Executor getExecutor() {
        return this.ep.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.ep.setExecutor(executor);
    }

    public void setUseExecutor(boolean useexec) {
        this.ep.setUseExecutor(useexec);
    }

    public int getMaxThreads() {
        return this.ep.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public void setThreadPriority(int threadPriority) {
        this.ep.setThreadPriority(threadPriority);
        this.setAttribute("threadPriority", "" + threadPriority);
    }

    public void setAcceptorThreadPriority(int threadPriority) {
        this.ep.setAcceptorThreadPriority(threadPriority);
        this.setAttribute("acceptorThreadPriority", "" + threadPriority);
    }

    public void setPollerThreadPriority(int threadPriority) {
        this.ep.setPollerThreadPriority(threadPriority);
        this.setAttribute("pollerThreadPriority", "" + threadPriority);
    }

    public int getThreadPriority() {
        return this.ep.getThreadPriority();
    }

    public int getAcceptorThreadPriority() {
        return this.ep.getAcceptorThreadPriority();
    }

    public int getPollerThreadPriority() {
        return this.ep.getThreadPriority();
    }

    public boolean getUseSendfile() {
        return this.ep.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.ep.setUseSendfile(useSendfile);
    }

    public int getBacklog() {
        return this.ep.getBacklog();
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public void setPort(int port) {
        this.ep.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.ep.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.ep.getPort();
    }

    public boolean getTcpNoDelay() {
        return this.ep.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
        this.setAttribute("compression", valueS);
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
        this.setAttribute("maxSavePostSize", "" + valueI);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
        this.setAttribute("maxHttpHeaderSize", "" + valueI);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.setAttribute("restrictedUserAgents", valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.setAttribute("noCompressionUserAgents", valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.setAttribute("compressableMimeTypes", valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.setAttribute("compressionMinSize", "" + valueI);
    }

    public int getSoLinger() {
        return this.ep.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.ep.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public String getProtocol() {
        return this.getProperty("protocol");
    }

    public void setProtocol(String k) {
        this.setSecure(true);
        this.setAttribute("protocol", k);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.ep.setSecure(b);
        this.secure = b;
        this.setAttribute("secure", "" + b);
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setAttribute("maxKeepAliveRequests", "" + mkar);
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
        this.setAttribute("socketCloseDelay", "" + d);
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
        this.setAttribute("timeout", "" + timeouts);
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public void setOomParachute(int oomParachute) {
        this.ep.setOomParachute(oomParachute);
        this.setAttribute("oomParachute", oomParachute);
    }

    public String getKeystoreFile() {
        return this.ep.getKeystoreFile();
    }

    public void setKeystoreFile(String s) {
        this.ep.setKeystoreFile(s);
    }

    public void setKeystore(String s) {
        this.setKeystoreFile(s);
    }

    public String getKeystore() {
        return this.getKeystoreFile();
    }

    public String getAlgorithm() {
        return this.ep.getAlgorithm();
    }

    public void setAlgorithm(String s) {
        this.ep.setAlgorithm(s);
    }

    public void setClientauth(String s) {
        this.setClientAuth(s);
    }

    public String getClientauth() {
        return this.getClientAuth();
    }

    public String getClientAuth() {
        return this.ep.getClientAuth();
    }

    public void setClientAuth(String s) {
        this.ep.setClientAuth(s);
    }

    public String getKeystorePass() {
        return this.ep.getKeystorePass();
    }

    public void setKeystorePass(String s) {
        this.ep.setKeystorePass(s);
    }

    public void setKeypass(String s) {
        this.setKeystorePass(s);
    }

    public String getKeypass() {
        return this.getKeystorePass();
    }

    public String getKeystoreType() {
        return this.ep.getKeystoreType();
    }

    public void setKeystoreType(String s) {
        this.ep.setKeystoreType(s);
    }

    public String getKeytype() {
        return this.getKeystoreType();
    }

    public void setKeytype(String s) {
        this.setKeystoreType(s);
    }

    public void setTruststoreFile(String f) {
        this.ep.setTruststoreFile(f);
    }

    public String getTruststoreFile() {
        return this.ep.getTruststoreFile();
    }

    public void setTruststorePass(String p) {
        this.ep.setTruststorePass(p);
    }

    public String getTruststorePass() {
        return this.ep.getTruststorePass();
    }

    public void setTruststoreType(String t) {
        this.ep.setTruststoreType(t);
    }

    public String getTruststoreType() {
        return this.ep.getTruststoreType();
    }

    public String getSslProtocol() {
        return this.ep.getSslProtocol();
    }

    public void setSslProtocol(String s) {
        this.ep.setSslProtocol(s);
    }

    public String getCiphers() {
        return this.ep.getCiphers();
    }

    public void setCiphers(String s) {
        this.ep.setCiphers(s);
    }

    public boolean getSSLEnabled() {
        return this.ep.isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.ep.setSSLEnabled(SSLEnabled);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public int getOomParachute() {
        return this.ep.getOomParachute();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static class Http11ConnectionHandler
    implements NioEndpoint.Handler {
        protected Http11NioProtocol proto;
        protected static int count = 0;
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<NioChannel, Http11NioProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11NioProcessor> recycledProcessors = new ConcurrentLinkedQueue<Http11NioProcessor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11NioProcessor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.deregister(processor);
                }
                return result;
            }

            @Override
            public Http11NioProcessor poll() {
                Http11NioProcessor result = (Http11NioProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11NioProcessor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.deregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };
        AtomicInteger registerCount = new AtomicInteger(0);

        Http11ConnectionHandler(Http11NioProtocol proto) {
            this.proto = proto;
        }

        public void releaseCaches() {
            this.recycledProcessors.clear();
        }

        public void release(NioChannel socket) {
            Http11NioProcessor result = this.connections.remove(socket);
            if (result != null) {
                result.recycle();
                this.recycledProcessors.offer(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NioEndpoint.Handler.SocketState event(NioChannel socket, SocketStatus status) {
            Http11NioProcessor result = this.connections.get(socket);
            NioEndpoint.Handler.SocketState state = NioEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Http11NioProcessor.error=" + result.error);
                }
                try {
                    state = result.event(status);
                }
                catch (SocketException e) {
                    log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
                }
                catch (IOException e) {
                    log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
                }
                catch (Throwable e) {
                    log.error(sm.getString("http11protocol.proto.error"), e);
                }
                finally {
                    if (state != NioEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                        if (state == NioEndpoint.Handler.SocketState.OPEN) {
                            socket.getPoller().add(socket);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Keeping processor[" + result);
                        }
                        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
                        socket.getPoller().add(socket, att.getCometOps());
                    }
                }
            }
            return state;
        }

        public NioEndpoint.Handler.SocketState process(NioChannel socket) {
            Http11NioProcessor processor = null;
            try {
                processor = this.connections.remove(socket);
                if (processor == null) {
                    processor = this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                if (this.proto.ep.getSecure() && this.proto.sslImplementation != null) {
                    if (socket instanceof SecureNioChannel) {
                        SecureNioChannel ch = (SecureNioChannel)socket;
                        processor.setSslSupport(this.proto.sslImplementation.getSSLSupport(ch.getSslEngine().getSession()));
                    } else {
                        processor.setSslSupport(null);
                    }
                } else {
                    processor.setSslSupport(null);
                }
                NioEndpoint.Handler.SocketState state = processor.process(socket);
                if (state == NioEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    if (processor.comet) {
                        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
                        socket.getPoller().add(socket, att.getCometOps());
                    } else {
                        socket.getPoller().add(socket);
                    }
                } else {
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
            }
            catch (IOException e) {
                log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
            }
            catch (Throwable e) {
                log.error(sm.getString("http11protocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return NioEndpoint.Handler.SocketState.CLOSED;
        }

        public Http11NioProcessor createProcessor() {
            Http11NioProcessor processor = new Http11NioProcessor(this.proto.ep.getSocketProperties().getRxBufSize(), this.proto.ep.getSocketProperties().getTxBufSize(), this.proto.maxHttpHeaderSize, this.proto.ep);
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompressionMinSize(this.proto.compressionMinSize);
            processor.setCompression(this.proto.compression);
            processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
            processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
            processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
            processor.setSocketBuffer(this.proto.socketBuffer);
            processor.setMaxSavePostSize(this.proto.maxSavePostSize);
            processor.setServer(this.proto.server);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(Http11NioProcessor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        this.registerCount.addAndGet(1);
                        if (log.isDebugEnabled()) {
                            log.debug("Register [" + processor + "] count=" + this.registerCount.get());
                        }
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count++);
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregister(Http11NioProcessor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        this.registerCount.addAndGet(-1);
                        if (log.isDebugEnabled()) {
                            log.debug("Deregister [" + processor + "] count=" + this.registerCount.get());
                        }
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

