/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.ws.security;

import java.util.List;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.xml.AuthConstraint;
import org.ow2.jonas.deployment.web.xml.JonasWebApp;
import org.ow2.jonas.deployment.web.xml.SecurityConstraint;
import org.ow2.jonas.deployment.web.xml.UserDataConstraint;
import org.ow2.jonas.deployment.web.xml.WebApp;
import org.ow2.jonas.deployment.web.xml.WebResourceCollection;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.ejb.ISecurityConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureWebDeploymentDescBuilder {
    public WebContainerDeploymentDesc createJOnASWebDescriptor(List<ISecurityConstraint> security) throws WSException {
        try {
            return new WebContainerDeploymentDesc(null, this.getClass().getClassLoader(), this.createWebApp(security), new JonasWebApp(), null);
        }
        catch (DeploymentDescException e) {
            throw new WSException("Cannot construct secured web deployment descriptor", (Throwable)e);
        }
    }

    private WebApp createWebApp(List<ISecurityConstraint> constraints) {
        WebApp webApp = new WebApp();
        if (!constraints.isEmpty()) {
            for (ISecurityConstraint constraint : constraints) {
                SecurityConstraint sc = new SecurityConstraint();
                webApp.addSecurityConstraint(sc);
                UserDataConstraint udc = new UserDataConstraint();
                sc.setUserDataConstraint(udc);
                String transportGuarantee = constraint.getTransportGuarantee();
                if (transportGuarantee == null) {
                    transportGuarantee = "NONE";
                }
                udc.setTransportGuarantee(transportGuarantee);
                AuthConstraint ac = new AuthConstraint();
                sc.setAuthConstraint(ac);
                for (String role : constraint.getRoleNames()) {
                    ac.addRoleName(role);
                }
                WebResourceCollection collection = new WebResourceCollection();
                collection.setWebResourceName("default");
                sc.addWebResourceCollection(collection);
                collection.addUrlPattern(constraint.getUrlPattern());
                if (constraint.getHttpMethods() != null) {
                    for (String method : constraint.getHttpMethods()) {
                        collection.addHttpMethod(method);
                    }
                }
                for (String role : constraint.getRoleNames()) {
                    SecurityRole sr = new SecurityRole();
                    sr.setRoleName(role);
                    webApp.addSecurityRole(sr);
                }
            }
        }
        return webApp;
    }
}

