/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.http;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Axis2RequestResponseTransport
implements RequestResponseTransport {
    private static final Log LOG = LogFactory.getLog(Axis2RequestResponseTransport.class);
    private IWSResponse response;
    private CountDownLatch responseReadySignal = new CountDownLatch(1);
    private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.INITIAL;
    private AxisFault faultToBeThrownOut = null;
    private boolean responseWritten;

    public Axis2RequestResponseTransport(IWSResponse response) {
        this.response = response;
    }

    public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
        LOG.debug((Object)"acknowledgeMessage", new Object[0]);
        LOG.debug((Object)"Acking one-way request", new Object[0]);
        this.response.setContentType("text/xml; charset=" + msgContext.getProperty("message.character-set-encoding"));
        this.response.setStatus(202);
        try {
            this.response.flushBuffer();
        }
        catch (IOException e) {
            throw new AxisFault("Error sending acknowledgement", (Throwable)e);
        }
        this.signalResponseReady();
    }

    public void awaitResponse() throws InterruptedException, AxisFault {
        LOG.debug((Object)"Blocking servlet thread -- awaiting response", new Object[0]);
        this.status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        this.responseReadySignal.await();
        if (this.faultToBeThrownOut != null) {
            throw this.faultToBeThrownOut;
        }
    }

    public void signalFaultReady(AxisFault fault) {
        this.faultToBeThrownOut = fault;
        this.signalResponseReady();
    }

    public void signalResponseReady() {
        LOG.debug((Object)"Signalling response available", new Object[0]);
        this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
        this.responseReadySignal.countDown();
    }

    public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
        return this.status;
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public void setResponseWritten(boolean responseWritten) {
        this.responseWritten = responseWritten;
    }
}

