/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.StringTokenizer;
import org.ow2.jonas.ws.axis2.JaxWsImplementorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXWSUtils {
    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuffer namespace = new StringBuffer("http://");
        String dot = "";
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(dot + tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    public static String getPackageName(Class<?> clazz) {
        int pos;
        String className = clazz.getName();
        if (className.startsWith("[L")) {
            className = className.substring(2);
        }
        if ((pos = className.lastIndexOf(46)) != -1) {
            return className.substring(0, pos);
        }
        return "";
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return JAXWSUtils.loadClass2(className, callingClass);
    }

    private static Class<?> loadClass2(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            block5: {
                try {
                    if (JaxWsImplementorInfo.class.getClassLoader() != null) {
                        return JaxWsImplementorInfo.class.getClassLoader().loadClass(className);
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (callingClass == null || callingClass.getClassLoader() == null) break block5;
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
            throw ex;
        }
    }

    public static Class<?> getClassFromType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t;
            return Array.newInstance(JAXWSUtils.getClassFromType(g.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            return JAXWSUtils.getClassFromType(p.getRawType());
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }

    public static String getDefaultNamespace(Class clazz) {
        String pkg = JAXWSUtils.getNamespace(JAXWSUtils.getPackageName(clazz));
        return JAXWSUtils.isEmpty(pkg) ? "http://unknown.namespace/" : pkg;
    }
}

