/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.URLHandlersServiceTracker;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public final class URLHandlersStreamHandlerProxy
extends URLStreamHandler
implements URLStreamHandlerSetter,
InvocationHandler {
    private static final Method EQUALS;
    private static final Method GET_DEFAULT_PORT;
    private static final Method GET_HOST_ADDRESS;
    private static final Method HASH_CODE;
    private static final Method HOSTS_EQUAL;
    private static final Method OPEN_CONNECTION;
    private static final Method SAME_FILE;
    private static final Method TO_EXTERNAL_FORM;
    private final Map m_trackerMap = new HashMap();
    private final String m_protocol;
    private final Object m_service;
    private final SecureAction m_action;
    private final URLStreamHandler m_builtIn;
    private final URL m_builtInURL;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLStreamHandler;
    static /* synthetic */ Class class$org$apache$felix$framework$ExtensionManager;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlersServiceTracker;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerSetter;

    public URLHandlersStreamHandlerProxy(String protocol, SecureAction action, URLStreamHandler builtIn, URL builtInURL) {
        this.m_protocol = protocol;
        this.m_service = null;
        this.m_action = action;
        this.m_builtIn = builtIn;
        this.m_builtInURL = builtInURL;
    }

    private URLHandlersStreamHandlerProxy(Object service, SecureAction action) {
        this.m_protocol = null;
        this.m_service = service;
        this.m_action = action;
        this.m_builtIn = null;
        this.m_builtInURL = null;
    }

    protected boolean equals(URL url1, URL url2) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).equals(url1, url2);
        }
        try {
            return (Boolean)EQUALS.invoke(svc, url1, url2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected int getDefaultPort() {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Stream handler unavailable.");
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).getDefaultPort();
        }
        try {
            return (Integer)GET_DEFAULT_PORT.invoke(svc, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected InetAddress getHostAddress(URL url) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).getHostAddress(url);
        }
        try {
            return (InetAddress)GET_HOST_ADDRESS.invoke(svc, url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected int hashCode(URL url) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).hashCode(url);
        }
        try {
            return (Integer)HASH_CODE.invoke(svc, url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected boolean hostsEqual(URL url1, URL url2) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).hostsEqual(url1, url2);
        }
        try {
            return (Boolean)HOSTS_EQUAL.invoke(svc, url1, url2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected URLConnection openConnection(URL url) throws IOException {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new MalformedURLException("Unknown protocol: " + url.toString());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).openConnection(url);
        }
        try {
            if ("http".equals(url.getProtocol()) && "felix.extensions".equals(url.getHost()) && 9 == url.getPort()) {
                try {
                    Object handler = this.m_action.getDeclaredField(class$org$apache$felix$framework$ExtensionManager == null ? (class$org$apache$felix$framework$ExtensionManager = URLHandlersStreamHandlerProxy.class$("org.apache.felix.framework.ExtensionManager")) : class$org$apache$felix$framework$ExtensionManager, "m_extensionManager", null);
                    if (handler != null) {
                        return (URLConnection)this.m_action.invoke(this.m_action.getMethod(handler.getClass(), "openConnection", new Class[]{class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL}), handler, new Object[]{url});
                    }
                    throw new IOException("Extensions not supported or ambiguous context.");
                }
                catch (Exception ex) {
                    throw new IOException(ex.getMessage());
                }
            }
            return (URLConnection)OPEN_CONNECTION.invoke(svc, url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            ((URLStreamHandlerService)svc).parseURL(this, url, spec, start, limit);
        } else {
            try {
                URL test = null;
                test = this.m_builtInURL != null ? new URL(new URL(this.m_builtInURL, url.toExternalForm()), spec) : this.m_action.createURL(url, spec, (URLStreamHandler)svc);
                super.setURL(url, test.getProtocol(), test.getHost(), test.getPort(), test.getAuthority(), test.getUserInfo(), test.getPath(), test.getQuery(), test.getRef());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
            }
        }
    }

    protected boolean sameFile(URL url1, URL url2) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).sameFile(url1, url2);
        }
        try {
            return (Boolean)SAME_FILE.invoke(svc, url1, url2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    public void setURL(URL url, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(url, protocol, host, port, authority, userInfo, path, query, ref);
    }

    public void setURL(URL url, String protocol, String host, int port, String file, String ref) {
        super.setURL(url, protocol, host, port, null, null, file, null, ref);
    }

    protected String toExternalForm(URL url) {
        return this.toExternalForm(url, this.getStreamHandlerService());
    }

    private String toExternalForm(URL url, Object svc) {
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).toExternalForm(url);
        }
        try {
            return (String)TO_EXTERNAL_FORM.invoke(svc, url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getStreamHandlerService() {
        try {
            Object service;
            Object tracker;
            Object framework = URLHandlers.getFrameworkFromContext();
            if (framework == null) {
                return this.m_builtIn;
            }
            Map map = this.m_trackerMap;
            synchronized (map) {
                tracker = this.m_trackerMap.get(framework);
            }
            if (tracker == null) {
                String filter = "(&(objectClass=" + (class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName() + ")(" + "url.handler.protocol" + "=" + this.m_protocol + "))";
                tracker = this.m_action.invoke(this.m_action.getConstructor(framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$URLHandlersServiceTracker == null ? (class$org$apache$felix$framework$URLHandlersServiceTracker = URLHandlersStreamHandlerProxy.class$("org.apache.felix.framework.URLHandlersServiceTracker")) : class$org$apache$felix$framework$URLHandlersServiceTracker).getName()), new Class[]{framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = URLHandlersStreamHandlerProxy.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getName()), class$java$lang$String == null ? (class$java$lang$String = URLHandlersStreamHandlerProxy.class$("java.lang.String")) : class$java$lang$String}), new Object[]{framework, filter});
                Map map2 = this.m_trackerMap;
                synchronized (map2) {
                    if (!this.m_trackerMap.containsKey(framework)) {
                        this.m_trackerMap.put(framework, tracker);
                    } else {
                        this.unregister(tracker);
                        tracker = this.m_trackerMap.get(framework);
                    }
                }
            }
            if ((service = tracker instanceof URLHandlersServiceTracker ? ((URLHandlersServiceTracker)tracker).getService() : this.m_action.invokeDirect(this.m_action.getMethod(tracker.getClass(), "getService", null), tracker, null)) == null) {
                return this.m_builtIn;
            }
            if (service instanceof URLStreamHandlerService) {
                return (URLStreamHandlerService)service;
            }
            return (URLStreamHandlerService)Proxy.newProxyInstance((class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getClassLoader(), new Class[]{class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService}, (InvocationHandler)new URLHandlersStreamHandlerProxy(service, this.m_action));
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return this.m_builtIn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        Map map = this.m_trackerMap;
        synchronized (map) {
            Iterator iter = this.m_trackerMap.values().iterator();
            while (iter.hasNext()) {
                this.unregister(iter.next());
            }
            this.m_trackerMap.clear();
        }
    }

    private void unregister(Object tracker) {
        if (tracker instanceof URLHandlersServiceTracker) {
            ((URLHandlersServiceTracker)tracker).unregister();
        } else {
            try {
                this.m_action.invokeDirect(this.m_action.getMethod(tracker.getClass(), "unregister", null), tracker, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object invoke(Object obj, Method method, Object[] params) throws Throwable {
        Class[] types = method.getParameterTypes();
        if ("parseURL".equals(method.getName())) {
            types[0] = this.m_service.getClass().getClassLoader().loadClass((class$org$osgi$service$url$URLStreamHandlerSetter == null ? (class$org$osgi$service$url$URLStreamHandlerSetter = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerSetter")) : class$org$osgi$service$url$URLStreamHandlerSetter).getName());
            params[0] = Proxy.newProxyInstance(this.m_service.getClass().getClassLoader(), new Class[]{types[0]}, (InvocationHandler)((URLHandlersStreamHandlerProxy)params[0]));
        }
        return this.m_action.invokeDirect(this.m_action.getMethod(this.m_service.getClass(), method.getName(), types), this.m_service, params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            SecureAction action = new SecureAction();
            EQUALS = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("equals", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL, class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(EQUALS);
            GET_DEFAULT_PORT = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("getDefaultPort", null);
            action.setAccesssible(GET_DEFAULT_PORT);
            GET_HOST_ADDRESS = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("getHostAddress", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(GET_HOST_ADDRESS);
            HASH_CODE = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("hashCode", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(HASH_CODE);
            HOSTS_EQUAL = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("hostsEqual", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL, class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(HOSTS_EQUAL);
            OPEN_CONNECTION = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("openConnection", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(OPEN_CONNECTION);
            SAME_FILE = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("sameFile", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL, class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(SAME_FILE);
            TO_EXTERNAL_FORM = (class$java$net$URLStreamHandler == null ? (class$java$net$URLStreamHandler = URLHandlersStreamHandlerProxy.class$("java.net.URLStreamHandler")) : class$java$net$URLStreamHandler).getDeclaredMethod("toExternalForm", class$java$net$URL == null ? (class$java$net$URL = URLHandlersStreamHandlerProxy.class$("java.net.URL")) : class$java$net$URL);
            action.setAccesssible(TO_EXTERNAL_FORM);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }
}

