/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.carol.util.configuration.ProtocolConfigurationImpl;
import org.ow2.carol.util.configuration.ProviderURLsParser;
import org.ow2.carol.util.configuration.ServerConfiguration;
import org.ow2.carol.util.configuration.ServerConfigurationImpl;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.config.CMIConfigException;
import org.ow2.cmi.config.CMIConfigurator;
import org.ow2.cmi.config.CMIProperty;
import org.ow2.cmi.config.JNDIConfig;
import org.ow2.cmi.config.ProtocolConfig;
import org.ow2.cmi.config.ProviderUrls;
import org.ow2.cmi.controller.client.Config;
import org.ow2.cmi.controller.common.IConfig;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.factory.client.ClusterViewManagerFactoryConfig;
import org.ow2.cmi.jndi.context.CMIInitialContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CMIConfigurationHelper {
    private static Log logger = LogFactory.getLog(CMIConfigurationHelper.class);

    private CMIConfigurationHelper() {
    }

    protected static boolean enableCMI(ServerConfiguration sc, String domainName, String serverName, String agentId, URL cmiConfigUrl) throws ConfigurationException {
        CMIConfig cmiConfig;
        if (cmiConfigUrl == null) {
            ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
            if (protocolConfigurations.length != 1) {
                logger.debug((Object)"Many protocols: CMI client only supports one protocol so you need to specify one of them.");
                return false;
            }
            Properties cmiEnv = CMIConfigurationHelper.getDefaultCMIEnv(protocolConfigurations[0].getProtocol().getName());
            try {
                cmiConfig = CMIConfigurator.extractCMIConfig((Hashtable)cmiEnv, (boolean)false);
            }
            catch (CMIConfigException e) {
                logger.error((Object)"Unable to extract a configuration for CMI", (Throwable)e);
                throw new ConfigurationException("Unable to extract a configuration for CMI", e);
            }
        }
        try {
            cmiConfig = CMIConfigurator.extractCMIConfig((URL)cmiConfigUrl);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to extract a configuration for CMI", (Throwable)e);
            throw new ConfigurationException("Unable to extract a configuration for CMI", e);
        }
        return CMIConfigurationHelper.configure(sc, domainName, serverName, agentId, cmiConfig);
    }

    protected static boolean enableCMI(ServerConfigurationImpl sc, String domainName, String serverName, String agentId, Properties env) throws ConfigurationException {
        CMIConfig cmiConfig;
        Properties cmiEnv;
        if (env == null || env.isEmpty()) {
            ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
            if (protocolConfigurations.length != 1) {
                logger.debug((Object)"Many protocols: CMI client only supports one protocol so you need to specify one of them.");
                return false;
            }
            cmiEnv = CMIConfigurationHelper.getDefaultCMIEnv(protocolConfigurations[0].getProtocol().getName());
        } else {
            cmiEnv = env;
        }
        try {
            cmiConfig = CMIConfigurator.extractCMIConfig((Hashtable)cmiEnv, (boolean)false);
        }
        catch (CMIConfigException e) {
            logger.error((Object)"Unable to extract a configuration for CMI", (Throwable)e);
            throw new ConfigurationException("Unable to extract a configuration for CMI", e);
        }
        return CMIConfigurationHelper.configure(sc, domainName, serverName, agentId, cmiConfig);
    }

    private static Properties getDefaultCMIEnv(String protocolName) {
        Properties cmiEnv = new Properties();
        cmiEnv.setProperty(CMIProperty.WRAPPED_PROTOCOL.getPropertyName(), protocolName);
        return cmiEnv;
    }

    private static boolean configure(ServerConfiguration sc, String domainName, String serverName, String agentId, CMIConfig<?> cmiConfig) throws ConfigurationException {
        boolean cmiClient;
        org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig clusterViewManagerFactoryConfig = cmiConfig.getClusterViewManagerFactoryConfig();
        if (clusterViewManagerFactoryConfig == null) {
            ClusterViewManagerFactoryConfig clientClusterViewManagerFactoryConfig = new ClusterViewManagerFactoryConfig();
            clusterViewManagerFactoryConfig = clientClusterViewManagerFactoryConfig;
            cmiConfig.setClusterViewManagerFactoryConfig((org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig)clientClusterViewManagerFactoryConfig);
        }
        if (cmiClient = clusterViewManagerFactoryConfig instanceof ClusterViewManagerFactoryConfig) {
            if (cmiConfig.isNoCmi()) {
                logger.info((Object)"CMI disabled by the XML configuration file.");
                return false;
            }
            if (clusterViewManagerFactoryConfig.getConfig() == null) {
                ((ClusterViewManagerFactoryConfig)clusterViewManagerFactoryConfig).setConfig((IConfig)new Config());
            }
        }
        try {
            if (!CMIConfigurationHelper.enableCMIOnEachProtocol(sc, cmiConfig, cmiClient)) {
                return false;
            }
        }
        catch (Exception e) {
            if (sc.isServer()) {
                logger.error((Object)"CMI cannot be enabled", (Throwable)e);
                throw new ConfigurationException("CMI cannot be enabled", e);
            }
            logger.debug((Object)"CMI cannot be enabled", (Throwable)e);
            return false;
        }
        if (sc.isServer() && cmiConfig.getClusterViewManagerFactoryConfig().getConfig().isAdminEnabled()) {
            MBeanUtils.setMBeanParameters((String)domainName, (String)serverName, (String)agentId);
        }
        try {
            CMIConfigurator.configure((ClusterViewManagerFactory)ClusterViewManagerFactory.getFactory(), cmiConfig);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to configure CMI", (Throwable)e);
            throw new ConfigurationException("Unable to configure CMI", e);
        }
        return true;
    }

    private static boolean enableCMIOnEachProtocol(ServerConfiguration sc, CMIConfig<?> cmiConfig, boolean cmiClient) throws ConfigurationException {
        boolean cmiEnabled = false;
        for (ProtocolConfiguration protocol : ConfigurationRepository.getConfigurations()) {
            cmiEnabled |= CMIConfigurationHelper.enableCmiOnProtocol((ProtocolConfigurationImpl)protocol, sc, cmiConfig, cmiClient);
        }
        return cmiEnabled;
    }

    private static boolean enableCmiOnProtocol(ProtocolConfigurationImpl protocolConfiguration, ServerConfiguration sc, CMIConfig<?> cmiConfig, boolean cmiClient) throws ConfigurationException {
        String protocolName = protocolConfiguration.getProtocol().getName();
        Properties cmiEnv = CMIConfigurationHelper.extractCMIProperties(protocolConfiguration, sc.isServer(), cmiConfig, cmiClient);
        List<String> providerUrls = null;
        if (cmiClient) {
            String clusterViewProviderUrls = cmiEnv.getProperty(CMIProperty.CLUSTER_VIEW_PROVIDER_URLS.getPropertyName());
            if (clusterViewProviderUrls == null) {
                logger.error((Object)"Provider URL missing");
                throw new ConfigurationException("Provider URL missing");
            }
            try {
                providerUrls = ProviderURLsParser.parse(protocolName, clusterViewProviderUrls);
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to activate CMI", (Throwable)e);
                throw new ConfigurationException("Unable to activate CMI", e);
            }
            if (!sc.isServer() && !CMIConfigurationHelper.checkCmiEnabling(protocolConfiguration.getProtocol(), providerUrls, cmiConfig.getClusterViewManagerFactoryConfig().getConfig().getClientProviderName())) {
                return false;
            }
        }
        JNDIConfig jndiConfig = cmiConfig.getJNDIConfig();
        ProtocolConfig protocolConfig = null;
        if (!cmiClient) {
            if (jndiConfig != null) {
                Set protocolConfigs = jndiConfig.getProtocolConfigs();
                for (ProtocolConfig protoConfig : protocolConfigs) {
                    if (!protocolName.equals(protoConfig.getName())) continue;
                    protocolConfig = protoConfig;
                }
                if (protocolConfig != null && protocolConfig.isNoCmi()) {
                    return false;
                }
            }
        } else {
            if (jndiConfig == null) {
                jndiConfig = new JNDIConfig();
                cmiConfig.setJNDIConfig(jndiConfig);
            } else {
                Set protocolConfigs = jndiConfig.getProtocolConfigs();
                for (ProtocolConfig protoConfig : protocolConfigs) {
                    if (!protocolName.equals(protoConfig.getName())) continue;
                    protocolConfig = protoConfig;
                }
            }
            if (protocolConfig == null) {
                protocolConfig = new ProtocolConfig();
                jndiConfig.addProtocolConfig(protocolConfig);
            }
            protocolConfig.setName(protocolName);
            protocolConfig.setInitialContextFactoryName(protocolConfiguration.getProtocol().getInitialContextFactoryClassName());
            if (providerUrls != null) {
                ProviderUrls pUrls = new ProviderUrls();
                pUrls.setProviderUrls(providerUrls);
                protocolConfig.setProviderUrls(pUrls);
            }
        }
        protocolConfiguration.enableCmi(cmiEnv);
        return true;
    }

    private static Properties extractCMIProperties(ProtocolConfigurationImpl protocolConfiguration, boolean isServer, CMIConfig<?> cmiConfig, boolean cmiClient) throws ConfigurationException {
        String protocolName = protocolConfiguration.getProtocol().getName();
        String prefixProtocol = "carol." + protocolName + ".";
        Properties cmiEnv = new Properties();
        cmiEnv.setProperty(CMIProperty.WRAPPED_PROTOCOL.getPropertyName(), protocolName);
        String carolProviderUrl = protocolConfiguration.getValue(prefixProtocol + "url");
        String clusterViewProviderURLs = null;
        if (isServer) {
            cmiEnv.setProperty(CMIProperty.LOCAL_REGISTRY_URL.getPropertyName(), carolProviderUrl);
        }
        if (cmiClient) {
            JNDIConfig jndiConfig = cmiConfig.getJNDIConfig();
            if (jndiConfig != null) {
                Set protocolConfigs = jndiConfig.getProtocolConfigs();
                ProtocolConfig currentProtocolConfig = null;
                String protocol = JNDIConfig.getCurrentProtocolName();
                if (protocol != null) {
                    for (ProtocolConfig protocolConfig : protocolConfigs) {
                        if (!protocolConfig.getName().equals(protocol)) continue;
                        currentProtocolConfig = protocolConfig;
                    }
                } else if (protocolConfigs.size() == 1 && ConfigurationRepository.getConfigurations().length == 1) {
                    currentProtocolConfig = (ProtocolConfig)protocolConfigs.toArray()[0];
                    if (currentProtocolConfig.getName() == null || currentProtocolConfig.getName().equals(protocolName)) {
                        currentProtocolConfig.setName(protocolName);
                    } else {
                        currentProtocolConfig = null;
                    }
                }
                if (currentProtocolConfig != null) {
                    ProviderUrls pUrls = currentProtocolConfig.getProviderUrls();
                    ArrayList<String> urls = new ArrayList<String>();
                    if (pUrls != null) {
                        urls.addAll(pUrls.getProviderUrls());
                    }
                    if (!isServer) {
                        urls.add(carolProviderUrl);
                    }
                    if (!urls.isEmpty()) {
                        clusterViewProviderURLs = ProviderURLsParser.parse(urls);
                    }
                }
            }
            if (clusterViewProviderURLs != null) {
                cmiEnv.setProperty(CMIProperty.CLUSTER_VIEW_PROVIDER_URLS.getPropertyName(), clusterViewProviderURLs);
            }
        }
        cmiEnv.setProperty(CMIProperty.WRAPPED_INITIAL_CONTEXT_FACTORY.getPropertyName(), protocolConfiguration.getProtocol().getInitialContextFactoryClassName());
        cmiEnv.setProperty(CMIProperty.SERVER_MODE.getPropertyName(), Boolean.toString(!cmiClient));
        cmiEnv.setProperty("java.naming.factory.initial", CMIInitialContextFactory.class.getName());
        return cmiEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkCmiEnabling(Protocol protocol, List<String> providerUrls, String providerName) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", protocol.getInitialContextFactoryClassName());
        for (String providerUrl : providerUrls) {
            env.put("java.naming.provider.url", providerUrl);
            InitialContext context = null;
            try {
                context = new InitialContext(env);
                context.lookup(providerName);
                boolean bl = true;
                return bl;
            }
            catch (NamingException e) {
                logger.debug((Object)("Unable to use CMI with the provider URL " + providerUrl), (Throwable)e);
            }
            finally {
                if (context == null) continue;
                try {
                    context.close();
                }
                catch (NamingException e) {
                    logger.debug((Object)"Unable to close the context", (Throwable)e);
                }
            }
        }
        return false;
    }
}

