/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ConfigurationUtil;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.carol.util.configuration.ProtocolConfigurationImplMBean;
import org.ow2.carol.util.configuration.ServerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolConfigurationImpl
implements ProtocolConfiguration,
ProtocolConfigurationImplMBean {
    private static Log logger = LogFactory.getLog(ProtocolConfigurationImpl.class);
    private final String name;
    private final Protocol protocol;
    private Properties properties = null;
    private Hashtable<Object, Object> jndiEnv = null;
    private Properties cmiEnv;
    private String host = null;
    private int port = 0;
    private String objectName = null;
    private boolean cmiEnabled = true;
    private final ServerConfiguration sc;

    public ProtocolConfigurationImpl(String name, Protocol protocol, Properties properties, ServerConfiguration serverConfiguration) throws ConfigurationException {
        this.name = name;
        this.protocol = protocol;
        this.sc = serverConfiguration;
        this.configure(properties);
    }

    @Override
    public void configure(Properties properties) throws ConfigurationException {
        if (properties == null) {
            throw new ConfigurationException("Cannot build a configuration with a null properties object");
        }
        this.properties = properties;
        this.extractJNDIProperties();
        this.parseURL();
    }

    protected void extractJNDIProperties() throws ConfigurationException {
        this.jndiEnv = new Hashtable();
        String prefixProtocol = "carol." + this.protocol.getName() + ".";
        this.jndiEnv.put("java.naming.provider.url", this.getValue(prefixProtocol + "url"));
        this.jndiEnv.put("java.naming.factory.initial", this.protocol.getInitialContextFactoryClassName());
    }

    protected void parseURL() throws ConfigurationException {
        String url = this.getProviderURL();
        this.port = ConfigurationUtil.getPortOfUrl(url);
        this.host = ConfigurationUtil.getHostOfUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        Hashtable newEnv = new Hashtable(env);
        newEnv.putAll(this.jndiEnv);
        Object cmiDisabled = env.get("cmi.disabled");
        ProtocolConfiguration protocolConfiguration = null;
        if (this.sc.isStartCMI() && this.cmiEnabled && this.cmiEnv != null && (cmiDisabled == null || cmiDisabled != null && !Boolean.parseBoolean((String)cmiDisabled))) {
            if (this.sc.isServer()) {
                protocolConfiguration = ConfigurationRepository.setCurrentConfiguration(this);
            }
            newEnv.putAll(this.cmiEnv);
        }
        try {
            InitialContext initialContext = new InitialContext(newEnv);
            return initialContext;
        }
        finally {
            if (protocolConfiguration != null) {
                ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            }
        }
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProviderURL() {
        return (String)this.jndiEnv.get("java.naming.provider.url");
    }

    protected String getValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return s;
    }

    @Override
    public Hashtable<Object, ?> getJndiEnv() {
        return this.jndiEnv;
    }

    @Override
    public String getInitialContextFactoryClassName() {
        return this.protocol.getInitialContextFactoryClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getNames() throws NamingException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Context ctx = this.getInitialContext(this.getJndiEnv());
            ArrayList<String> names = new ArrayList<String>();
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            String n = null;
            while (ne.hasMore()) {
                NameClassPair ncp = ne.next();
                n = ncp.getName();
                names.add(n);
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public String getobjectName() {
        return this.objectName;
    }

    @Override
    public void setobjectName(String name) {
        this.objectName = name;
    }

    @Override
    public boolean iseventProvider() {
        return false;
    }

    @Override
    public boolean isstateManageable() {
        return false;
    }

    @Override
    public boolean isstatisticsProvider() {
        return false;
    }

    @Override
    public synchronized boolean isCmiEnabled() {
        return this.cmiEnabled;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public synchronized void enableCmi(Properties cmiEnv) {
        this.cmiEnv = cmiEnv;
        this.cmiEnabled = true;
        logger.debug((Object)("CMI enabled for protocol " + this.protocol.getName() + " with environment " + cmiEnv));
    }

    @Override
    public synchronized void disableCmi() {
        this.cmiEnabled = false;
        logger.debug((Object)("CMI enabled for protocol " + this.protocol.getName()));
    }
}

