/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.generator.rdb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.objectweb.jorm.api.PNameIterator;
import org.objectweb.jorm.api.PPrefetchTupleCollection;
import org.objectweb.jorm.facility.naming.generator.rdb.LongGenIncrMapping;
import org.objectweb.jorm.mapper.rdb.lib.RdbTupleCollection;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.medor.api.MedorException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

class LongGenIncrResultIterator
implements PNameIterator {
    ResultSet rs;
    private PBinder binder;
    private LongGenIncrMapping pclassMapping;
    private boolean hasNext;
    private boolean isForw;
    private PreparedStatement ps;
    private Logger logger;
    private boolean prefetching;
    private PPrefetchTupleCollection tc = null;
    private int pnameIndex;

    LongGenIncrResultIterator(Object txctx, PreparedStatement ps, ResultSet r, PBinder binder, boolean prefetching, boolean withSubType, Logger l, int pi, LongGenIncrMapping pcm) throws SQLException, MedorException {
        this.ps = ps;
        this.binder = binder;
        this.prefetching = prefetching;
        this.rs = r;
        this.logger = l;
        this.pclassMapping = pcm;
        if (!prefetching) {
            this.pnameIndex = 1;
        } else {
            this.pnameIndex = pi;
            this.tc = new RdbTupleCollection(txctx, r, ps, this.pnameIndex, this.logger, this.pclassMapping, withSubType, this);
        }
        this.hasNext = !prefetching ? this.rs.next() : this.tc.next();
        this.isForw = true;
    }

    public void finalize() throws Throwable {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        super.finalize();
    }

    public void close() {
        if (!this.prefetching) {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.rs = null;
            }
            this.hasNext = false;
            this.isForw = false;
        }
    }

    public boolean hasNext() {
        boolean res;
        if (this.isForw) {
            res = this.hasNext;
        } else {
            this.isForw = true;
            try {
                res = this.hasNext = !this.prefetching ? this.rs.next() : this.tc.next();
            }
            catch (Exception e) {
                e.printStackTrace();
                res = false;
            }
        }
        if (!res) {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.ps != null) {
                    this.ps.close();
                    this.ps = null;
                }
            }
            catch (SQLException e) {
                this.rs = null;
                this.ps = null;
            }
        }
        return res;
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public Object next() throws NoSuchElementException {
        try {
            if (!this.isForw) {
                this.hasNext = !this.prefetching ? this.rs.next() : this.tc.next();
                this.isForw = true;
            }
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.isForw = false;
            if (this.prefetching) {
                this.tc.getPrefetchBuffer().addPrefetchTuple();
            }
            return this.pclassMapping.decode(this.rs, this.pnameIndex, null);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.ERROR, (Object)"Impossible to fetch the next element", (Throwable)e);
            }
            throw new NoSuchElementException("Impossible to decode to an ID PName: " + e.getMessage());
        }
    }
}

