/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class FirebirdAdapter
extends BasicRdbAdapter {
    public FirebirdAdapter() {
        super("firebird");
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        String res;
        switch (typeCode) {
            case 0: 
            case 8: {
                res = "char(1)";
                break;
            }
            case 5: 
            case 13: {
                res = "NUMERIC(18)";
                break;
            }
            case 2: 
            case 10: {
                return "SMALLINT";
            }
            case 6: 
            case 14: {
                return "FLOAT";
            }
            case 7: 
            case 15: {
                return "DOUBLE PRECISION";
            }
            case 19: 
            case 20: {
                if (size != -1) {
                    res = "BLOB(" + size + ")";
                }
                res = "BLOB";
                break;
            }
            case 21: {
                if (size != -1) {
                    String res2 = "DECIMAL(" + size + ",0)";
                }
                return "DECIMAL(18,0)";
            }
            case 22: {
                if (size != -1) {
                    String res3 = "DECIMAL(" + size + ",4)";
                }
                return "DECIMAL(18,4)";
            }
            default: {
                res = super.getSqlType(typeCode, usedInPK, size, scale);
            }
        }
        if (usedInPK) {
            res = res + " NOT NULL";
        }
        return res;
    }

    public boolean getBoolean(ResultSet rs, int idx, boolean nullValue) throws SQLException {
        String res = rs.getString(idx);
        return rs.wasNull() || res == null ? nullValue : res.equals("T");
    }

    public Boolean getOboolean(ResultSet rs, int idx, Boolean nullValue) throws SQLException {
        String res = rs.getString(idx);
        return rs.wasNull() || res == null ? nullValue : Boolean.valueOf(res.equals("T"));
    }

    public void setBoolean(PreparedStatement ps, int idx, boolean o) throws SQLException {
        ps.setString(idx, o ? "T" : "F");
    }

    public void setOboolean(PreparedStatement ps, int idx, Boolean o) throws SQLException {
        ps.setString(idx, o != false ? "T" : "F");
    }

    public void setOchar(PreparedStatement ps, int idx, Character o) throws SQLException {
        ps.setString(idx, o.toString());
    }

    public void writeTableAlias(String alias, StringBuffer sb) {
        sb.append(" ");
        sb.append(alias);
    }

    public boolean supportBatchPreparedStatement() {
        return false;
    }
}

