/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class SqlserverAdapter
extends BasicRdbAdapter {
    public SqlserverAdapter() {
        super("sqlserver");
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        switch (typeCode) {
            case 2: 
            case 10: {
                return "SMALLINT";
            }
            case 19: {
                if (size != -1 && size <= 8000) {
                    return "VARBINARY(" + size + ")";
                }
                return "IMAGE";
            }
            case 18: {
                if (size != -1 && size <= 8000) {
                    return "VARCHAR(" + size + ")";
                }
                return "TEXT";
            }
            case 6: 
            case 14: {
                return "FLOAT(24)";
            }
            case 7: 
            case 15: {
                return "FLOAT(53)";
            }
            case 17: {
                return "DATETIME";
            }
            case 21: 
            case 22: {
                return "MONEY";
            }
        }
        return super.getSqlType(typeCode, usedInPK, size, scale);
    }

    public char[] getCharArray(ResultSet rs, int idx, char[] nullValue) throws SQLException {
        String res = rs.getString(idx);
        try {
            return rs.wasNull() || res == null ? nullValue : SqlserverAdapter.getCharArray(res);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void setObyte(PreparedStatement ps, int idx, Byte o) throws SQLException {
        ps.setObject(idx, (Object)o, 5);
    }

    public void setOchar(PreparedStatement ps, int idx, Character o) throws SQLException {
        ps.setString(idx, o.toString());
    }

    public void setCharArray(PreparedStatement ps, int idx, char[] o) throws SQLException {
        ps.setString(idx, new String(o));
    }

    public String getCreateSequence(String seqName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("SQL Server does not support SEQUENCE");
    }

    public String getCreateSequence(String seqName, Integer startid, Integer inc, Integer cache) {
        throw new UnsupportedOperationException("SQL Server does not support SEQUENCE");
    }

    public String getDropSequence(String seqName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("SQL Server does not support SEQUENCE");
    }

    public String getLengthOperator() throws RdbAdapterException {
        return "len";
    }
}

