/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.api;

import java.io.PrintStream;
import java.util.Iterator;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.MappingStructure;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.api.TypedElement;

public abstract class MappingPrinter {
    public static final String TAB = "    ";

    public boolean canPrint(MappingStructure pem) {
        return false;
    }

    public abstract void print(String var1, PrimitiveElementMapping var2, PrintStream var3);

    public void print(String p, ClassMapping cm, PrintStream out) {
        NameDef nd = (NameDef)cm.getIdentifierMapping().getLinkedMO();
        out.println(p + "The name def '" + nd.getName() + "' is used for the class");
        Iterator it = cm.getReferenceMappings().iterator();
        while (it.hasNext()) {
            nd = (NameDef)((ReferenceMapping)it.next()).getLinkedMO();
            out.println(p + "The name def '" + nd.getName() + "' is used for the reference '" + ((TypedElement)nd.getParent()).getName() + "'");
        }
        it = cm.getParentClassMappings().iterator();
        if (!it.hasNext()) {
            out.println(p + "No ParentClassMapping");
        } else {
            while (it.hasNext()) {
                this.print(p + TAB, (ParentClassMapping)it.next(), out);
            }
        }
    }

    public void print(String p, ParentClassMapping pcm, PrintStream out) {
        out.println(p + "Super class: " + pcm.getMOClass().getFQName() + ", RuleName: " + pcm.getRuleName());
    }

    public void print(String p, GenClassMapping gcm, PrintStream out) {
        NameDef nd = (NameDef)gcm.getIdentifierMapping().getLinkedMO();
        out.println(p + "The name def '" + nd.getName() + "' is used for the generic class '" + ((GenClassRef)gcm.getLinkedMO()).getGenClassId() + "'");
        ReferenceMapping rm = gcm.getReferenceMapping();
        if (rm != null) {
            nd = (NameDef)rm.getLinkedMO();
            out.println(p + "The name def '" + nd.getName() + "' is used for the element of the generic class '" + ((GenClassRef)gcm.getLinkedMO()).getGenClassId() + "'");
        }
    }
}

