/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.jorm.metainfo.api.CommonClassMapping;
import org.objectweb.jorm.metainfo.api.IdentifierMapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.lib.BasicIdentifierMapping;
import org.objectweb.jorm.metainfo.lib.BasicMappingStructure;
import org.objectweb.jorm.metainfo.lib.BasicReferenceMapping;
import org.objectweb.jorm.metainfo.lib.FieldComparator;

public class BasicCommonClassMapping
extends BasicMappingStructure
implements CommonClassMapping {
    private String ruleName;
    private Map primitiveElementMappings;
    private IdentifierMapping identifierMapping;
    private Set dependencies;

    public BasicCommonClassMapping(String ruleName, MetaObject linkedMO, MetaObject parent) {
        super(parent, linkedMO);
        this.ruleName = ruleName;
        this.primitiveElementMappings = new HashMap();
        this.identifierMapping = null;
        this.dependencies = new HashSet();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String rulename) {
        this.ruleName = rulename;
    }

    public IdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    public void setIdentifierMapping(IdentifierMapping idmapping) {
        this.identifierMapping = idmapping;
    }

    public Collection getPrimitiveElementMappings() {
        ArrayList list = null;
        try {
            list = new ArrayList(this.primitiveElementMappings.values());
            Collections.sort(list, FieldComparator.instance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List getAllPrimitiveElementMappings() {
        return (List)this.getPrimitiveElementMappings();
    }

    public PrimitiveElementMapping getPrimitiveElementMapping(String fieldName) {
        return (PrimitiveElementMapping)this.primitiveElementMappings.get(fieldName);
    }

    public void addPrimitiveElementMapping(PrimitiveElementMapping peMapping) {
        this.addPrimitiveElementMapping(((PrimitiveElement)peMapping.getLinkedMO()).getName(), peMapping);
    }

    public void addPrimitiveElementMapping(String fieldName, PrimitiveElementMapping peMapping) {
        this.primitiveElementMappings.put(fieldName, peMapping);
    }

    public Iterator primitiveElementMappingsIterator() {
        return this.primitiveElementMappings.values().iterator();
    }

    public IdentifierMapping createIdentifierMapping(NameDef nd) {
        IdentifierMapping res = this.getIdentifierMapping();
        if (res == null) {
            res = new BasicIdentifierMapping(nd, (MetaObject)this);
            this.setIdentifierMapping(res);
        }
        return res;
    }

    public ReferenceMapping createReferenceMapping(String ruleName, NameDef nd) {
        return new BasicReferenceMapping(ruleName, nd, this);
    }

    public void addDependency(String jormClassName) {
        this.dependencies.add(jormClassName);
    }

    public void removeDependency(String jormClassName) {
        this.dependencies.remove(jormClassName);
    }

    public Collection getDependencies() {
        return this.dependencies;
    }

    protected Collection getChildren() {
        ArrayList<IdentifierMapping> al = new ArrayList<IdentifierMapping>();
        al.add(this.identifierMapping);
        al.addAll(this.primitiveElementMappings.values());
        return al;
    }
}

