/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.type.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.jorm.type.api.PExceptionTyping;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.jorm.type.lib.PTypeGenClass;
import org.objectweb.jorm.type.lib.PTypeHashMapEntry;
import org.objectweb.jorm.type.lib.PTypePAAH;

public class PTypeSpacePAAH
implements PTypeSpace {
    private HashMap types = new HashMap();

    public PTypeSpacePAAH() {
        for (int i = 0; i < PTypeSpace.PREDEFINEDPTYPES.length; ++i) {
            this.types.put(PTypeSpace.PREDEFINEDPTYPES[i].getJormName(), new PTypeHashMapEntry(PTypeSpace.PREDEFINEDPTYPES[i], this));
        }
    }

    public synchronized PType createPType(String classname) throws PExceptionTyping {
        if (this.isConflict(classname, NULLSUPERCLASSNAMES)) {
            throw new PExceptionTyping("Cannot create type <" + classname + ">: it conflicts with existing types.");
        }
        return this.definePType((String)classname, (String[][])PTypeSpacePAAH.NULLSUPERCLASSNAMES).entryPType;
    }

    public synchronized PType createPType(String classname, String[][] superclassnames) throws PExceptionTyping {
        if (this.isConflict(classname, superclassnames)) {
            throw new PExceptionTyping("Cannot create type <" + classname + ">: it conflicts with existing types.");
        }
        return this.definePType((String)classname, (String[][])superclassnames).entryPType;
    }

    public PType createPType(String[] gcnames, PType ptype) throws PExceptionTyping {
        return ((PTypeHashMapEntry)this.types.get(ptype.getJormName())).addGcPType(gcnames, (short)(gcnames.length - 1));
    }

    public synchronized PType createPType(String[] gcnames, String typename, String[][] superclassnames) throws PExceptionTyping {
        if (this.isConflict(typename, superclassnames)) {
            throw new PExceptionTyping("Cannot create type <" + typename + ">: it conflicts with existing types.");
        }
        return this.defineGcPType(gcnames, typename, superclassnames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PType getPType(String classname) {
        HashMap hashMap = this.types;
        synchronized (hashMap) {
            PTypeHashMapEntry entry = (PTypeHashMapEntry)this.types.get(classname);
            if (entry == null) {
                return null;
            }
            return entry.entryPType;
        }
    }

    public PType[] getSubTypes(PType pt) {
        ArrayList<PType> subtypes = new ArrayList<PType>();
        Iterator it = this.types.values().iterator();
        while (it.hasNext()) {
            PTypeHashMapEntry entry = (PTypeHashMapEntry)it.next();
            if (entry.entryPType == pt || !entry.entryPType.isa(pt)) continue;
            subtypes.add(entry.entryPType);
        }
        return subtypes.toArray(new PType[subtypes.size()]);
    }

    public boolean isa(PType pt1, PType pt2) {
        if (pt1 == null || pt2 == null) {
            return false;
        }
        if (pt1 == pt2) {
            return true;
        }
        if (pt1 instanceof PTypePAAH && pt2 instanceof PTypePAAH) {
            return ((PTypePAAH)pt1).belongsToInherited(pt2);
        }
        if (pt1 instanceof PTypeGenClass && pt2 instanceof PTypeGenClass && pt1.getJormName().equals(pt2.getJormName())) {
            return this.isa(pt1.getNestedPType(), pt2.getNestedPType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        HashMap hashMap = this.types;
        synchronized (hashMap) {
            this.types.clear();
        }
    }

    private boolean isConflict(String classname, String[][] superclasses) {
        int i;
        PTypeHashMapEntry entry = (PTypeHashMapEntry)this.types.get(classname);
        if (entry == null) {
            return false;
        }
        for (i = 0; i < superclasses.length && !superclasses[i][0].equals(classname); i = (int)((short)(i + 1))) {
        }
        if (i == superclasses.length) {
            return ((PTypePAAH)entry.entryPType).superTypes.length != 0;
        }
        if (((PTypePAAH)entry.entryPType).superTypes.length != superclasses[i].length - 1) {
            return true;
        }
        for (int k = 0; k < ((PTypePAAH)entry.entryPType).superTypes.length; k = (int)((short)(k + 1))) {
            int j;
            for (j = 1; j < superclasses[i].length; j = (int)((short)(j + 1))) {
                if (!((PTypePAAH)entry.entryPType).superTypes[k].getJormName().equals(superclasses[i][j])) continue;
                if (!this.isConflict(superclasses[i][j], superclasses)) break;
                return true;
            }
            if (j != superclasses[i].length) continue;
            return true;
        }
        return false;
    }

    private PTypeHashMapEntry definePType(String classname, String[][] superclasses) {
        int i;
        PTypeHashMapEntry entry = (PTypeHashMapEntry)this.types.get(classname);
        if (entry != null) {
            return entry;
        }
        for (i = 0; i < superclasses.length && !superclasses[i][0].equals(classname); i = (int)((short)(i + 1))) {
        }
        if (i == superclasses.length) {
            entry = new PTypeHashMapEntry(new PTypePAAH(classname, this, NULLSUPERTYPES), this);
        } else {
            PType[] supertypes = new PType[superclasses[i].length - 1];
            for (int j = 1; j < superclasses[i].length; j = (int)((short)(j + 1))) {
                supertypes[j - 1] = this.definePType((String)superclasses[i][j], (String[][])superclasses).entryPType;
            }
            entry = new PTypeHashMapEntry(new PTypePAAH(classname, this, supertypes), this);
        }
        this.types.put(classname, entry);
        return entry;
    }

    private PType defineGcPType(String[] gcnames, String typename, String[][] superclasses) {
        PTypeHashMapEntry typeentry = (PTypeHashMapEntry)this.types.get(typename);
        if (typeentry == null) {
            typeentry = this.definePType(typename, superclasses);
        }
        return typeentry.addGcPType(gcnames, (short)(gcnames.length - 1));
    }
}

