/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.CalculatedParameterOperand;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.AbstractCalculatedParameterOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;

public class StringComparatorParameterOperand
extends AbstractCalculatedParameterOperand
implements CalculatedParameterOperand {
    private static final long serialVersionUID = 4081267250869990728L;
    String prefix;
    String suffix;

    public StringComparatorParameterOperand(BasicParameterOperand po, String prefix, String suffix) {
        super(po);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public StringComparatorParameterOperand(String name, String prefix, String suffix) {
        super(PTypeSpace.STRING, name);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public void evaluate(ParameterOperand[] pos) throws ExpressionException {
        ParameterOperand po = this.getPO(pos);
        if (po == null) {
            throw new ExpressionException("Impossible to evaluate this parameter wihtout the parameter " + this.name);
        }
        String res = po.getString();
        if (this.suffix != null) {
            res = res + this.suffix;
        }
        if (this.prefix != null) {
            res = this.prefix + res;
        }
        this.setValue(res);
    }
}

