/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.rdb;

import java.util.Map;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.util.monolog.api.BasicLevel;

public class RdbAssignRdbAdapterRule
extends BasicRule {
    protected Map name2Adapter = null;

    public RdbAssignRdbAdapterRule() {
        super("RdbAssignRdbAdapterRule");
    }

    public RdbAssignRdbAdapterRule(Map m) {
        this();
        this.name2Adapter = m;
    }

    public void setName2Adapter(Map m) {
        this.name2Adapter = m;
    }

    public Map getName2Adapter() {
        return this.name2Adapter;
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        this.log.log(BasicLevel.DEBUG, (Object)"Assignation of relational adapters");
        if (this.name2Adapter != null && this.name2Adapter.size() > 0) {
            this.assignAdapter(qt);
        }
        return qt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assignAdapter(QueryTree qt) throws MedorException {
        if (qt instanceof RdbExpQueryLeaf) {
            RdbExpQueryLeaf ql = (RdbExpQueryLeaf)qt;
            String name = ql.getRdbAdapterName();
            if (name == null) {
                this.log.log(BasicLevel.DEBUG, (Object)("No adapter specified for the RdbExpQueryLeaf: " + ql.getName()));
                return;
            }
            RdbAdapter adapter = (RdbAdapter)this.name2Adapter.get(name);
            if (adapter == null) throw new MedorException("No adapter " + name + " found for the RdbExpQueryLeaf: " + ql.getName());
            ql.setRdbAdapter(adapter);
            this.log.log(BasicLevel.DEBUG, (Object)("Assign the adapter " + ql.getRdbAdapterName() + "to the RdbExpQueryLeaf: " + ql.getName()));
            return;
        } else {
            if (!(qt instanceof QueryNode)) return;
            QueryTree[] qts = ((QueryNode)qt).getChildren();
            for (int i = 0; i < qts.length; ++i) {
                this.assignAdapter(qts[i]);
            }
        }
    }
}

