/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.distributed.globallock.lib;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import org.objectweb.perseus.concurrency.distributed.globallock.lib.GlobalLockMessage;
import org.objectweb.perseus.concurrency.distributed.globallock.lib.GlobalLockUser;
import org.objectweb.perseus.concurrency.lib.LockValue;
import org.objectweb.perseus.distribution.api.DistResCoordinator;
import org.objectweb.perseus.distribution.api.DistResCoordinatorService;
import org.objectweb.perseus.distribution.api.NotCoordinatorException;

public class GlobalLockCoordinator
implements DistResCoordinator,
Serializable {
    static final boolean trace = true;
    private Object objId;
    private HashSet users;
    private byte maxGrantedLock;
    private LinkedList waiting;
    private byte requestedDowngrade;
    private int nbDowngradeRequests;
    transient DistResCoordinatorService drcs;
    transient LockValue lockValue;
    private transient int lastCBnumber;

    public GlobalLockCoordinator(Object resId, DistResCoordinatorService drcs, LockValue lockValue) {
        this.initCopy(resId, drcs, lockValue);
        this.users = new HashSet();
        this.waiting = new LinkedList();
        this.maxGrantedLock = 0;
        this.requestedDowngrade = lockValue.maxValue();
        this.nbDowngradeRequests = 0;
        this.lastCBnumber = new Random().nextInt();
    }

    public GlobalLockCoordinator(GlobalLockCoordinator glc) {
        this.objId = glc.objId;
        this.users = glc.users;
        this.maxGrantedLock = glc.maxGrantedLock;
        this.waiting = glc.waiting;
        this.requestedDowngrade = glc.requestedDowngrade;
        this.nbDowngradeRequests = glc.nbDowngradeRequests;
        this.drcs = glc.drcs;
        this.lockValue = glc.lockValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void receive(Object objId, Serializable user, Serializable msg) {
        if (!objId.equals(this.objId)) {
            throw new InternalError();
        }
        if (!(msg instanceof GlobalLockMessage)) throw new InternalError("Unexpected message type");
        GlobalLockMessage req = (GlobalLockMessage)msg;
        if (req.type == 0) {
            this.upgrade(user, req.lck);
            return;
        } else if (req.type == 1) {
            this.downgrade(user, req.lck, req.serialNumber);
            return;
        } else {
            if (req.type != 2) throw new InternalError();
            this.cancelUpgrade(user);
        }
    }

    public synchronized Serializable freeze(Object resId) {
        this.trace("Freeze !!");
        return this;
    }

    public synchronized boolean joinUsersRequest(Object resId, Serializable node) {
        this.users.add(node);
        this.trace("Accept user: " + node);
        return true;
    }

    public void recover(Object resId, Map userStates) {
        Iterator it = userStates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Serializable nodeId = (Serializable)entry.getKey();
            GlobalLockUser glu = (GlobalLockUser)entry.getValue();
            this.trace("Received state from " + nodeId + ": " + glu);
            this.users.add(nodeId);
            if (this.maxGrantedLock < glu.locallyGranted) {
                this.maxGrantedLock = glu.locallyGranted;
            }
            if (glu.globallyRequested == 0) continue;
            this.waiting.addLast(new Waiter(nodeId, glu.globallyRequested));
        }
        if (!this.waiting.isEmpty()) {
            Waiter firstWaiting = (Waiter)this.waiting.get(0);
            this.callBackLocks(firstWaiting.nodeId, firstWaiting.lck);
        }
    }

    public void nodeFailed(Object resId, Serializable nodeId) {
        Iterator it = this.waiting.iterator();
        while (it.hasNext()) {
            Waiter waiter = (Waiter)it.next();
            if (!waiter.nodeId.equals(nodeId)) continue;
            it.remove();
        }
    }

    void initCopy(Object resId, DistResCoordinatorService drcs, LockValue lockValue) {
        this.objId = resId;
        this.drcs = drcs;
        this.lockValue = lockValue;
    }

    private void upgrade(Serializable n, byte lck) {
        try {
            this.trace("From: " + n + " GLOBAL REQUEST: " + lck);
            if (this.requestedDowngrade != this.lockValue.maxValue()) {
                System.out.println(this + "From: " + n + " ALREADY PENDING REQUEST: " + lck);
                this.waiting.addLast(new Waiter(n, lck));
                System.out.println(this + "From: " + n + " GLOBAL REQUEST QUEUED (NOT FIRST): " + lck);
                return;
            }
            if (this.lockValue.isCompatibleWith(lck, this.maxGrantedLock)) {
                if (this.maxGrantedLock < lck) {
                    this.maxGrantedLock = lck;
                }
                this.drcs.sendToUser(this.objId, (Serializable)new GlobalLockMessage(2, lck, 0L, null), (Object)n);
                return;
            }
            if (this.lockValue.isCompatibleWith(lck, this.maxGrantedLock) || this.users.size() == 1 && this.users.contains(n)) {
                this.maxGrantedLock = lck;
                this.drcs.sendToUser(this.objId, (Serializable)new GlobalLockMessage(2, lck, 0L, null), (Object)n);
                return;
            }
            byte downgradeLock = this.lockValue.getCompatibleWith(this.lockValue.maxValue(), lck);
            Waiter w = new Waiter(n, lck);
            this.waiting.addLast(w);
            this.callBackLocks(n, downgradeLock);
            this.trace("From: " + n + " GLOBAL REQUEST QUEUED (FIRST): " + lck);
        }
        catch (NotCoordinatorException e) {
            throw new InternalError("Not coordinator of this resource !!!");
        }
    }

    private void callBackLocks(Serializable n, byte downgradeLock) {
        try {
            this.requestedDowngrade = downgradeLock;
            HashSet dest = new HashSet(this.users);
            dest.remove(n);
            this.nbDowngradeRequests = dest.size();
            this.trace("From: " + n + " SND CALLBACK: " + downgradeLock + " TO: " + dest);
            ++this.lastCBnumber;
            this.drcs.sendToUsers(this.objId, (Serializable)new GlobalLockMessage(3, downgradeLock, 0L, n, this.lastCBnumber), dest);
        }
        catch (NotCoordinatorException e) {
            throw new InternalError("Not coordinator of this resource !!!");
        }
    }

    private void downgrade(Object n, byte lck, int serialNumber) {
        try {
            if (serialNumber != this.lastCBnumber) {
                this.trace("From: " + n + " GLOBAL RELEASE IGNORED " + lck);
                return;
            }
            --this.nbDowngradeRequests;
            this.trace("From: " + n + " GLOBAL RELEASE: " + lck);
            if (this.nbDowngradeRequests > 0) {
                return;
            }
            this.maxGrantedLock = this.requestedDowngrade;
            this.requestedDowngrade = this.lockValue.maxValue();
            Iterator it = this.waiting.iterator();
            while (it.hasNext()) {
                Waiter w = (Waiter)it.next();
                if (this.lockValue.isCompatibleWith(w.lck, this.maxGrantedLock)) {
                    if (this.maxGrantedLock < w.lck) {
                        this.maxGrantedLock = w.lck;
                    }
                    it.remove();
                    this.trace("To: " + w.nodeId + " NOTIFY GLOBAL UPGRADE: " + lck);
                    this.drcs.sendToUser(this.objId, (Serializable)new GlobalLockMessage(2, w.lck, 0L, null), (Object)w.nodeId);
                    continue;
                }
                this.callBackLocks(w.nodeId, this.lockValue.getCompatibleWith(this.lockValue.maxValue(), w.lck));
                break;
            }
        }
        catch (NotCoordinatorException e) {
            throw new InternalError("Not coordinator of this resource !!!");
        }
    }

    private void cancelUpgrade(Object n) {
        Waiter w = null;
        Iterator it = this.waiting.iterator();
        while (it.hasNext()) {
            w = (Waiter)it.next();
            if (!w.nodeId.equals(n)) continue;
        }
        if (w == null || !w.nodeId.equals(n)) {
            this.trace("From: " + n + " UNEXPECTED CANCELATION !! (IGNORE IT)");
        }
        if (this.waiting.indexOf(w) == 0) {
            this.trace("From: " + n + " CANCEL PENDING REQUEST (FIRST WAITING)");
            this.waiting.removeFirst();
            if (!this.waiting.isEmpty()) {
                w = (Waiter)this.waiting.getFirst();
                this.trace("From: " + n + " CANCEL PENDING REQUEST (NEW CALL BACK)");
                this.callBackLocks(w.nodeId, this.lockValue.getCompatibleWith(this.lockValue.maxValue(), w.lck));
            } else {
                this.requestedDowngrade = this.lockValue.maxValue();
                this.nbDowngradeRequests = 0;
                this.trace("From: " + n + " CANCEL PENDING REQUEST (NO MORE PENDING)");
            }
        } else {
            this.waiting.remove(w);
            this.trace("From: " + n + " CANCEL PENDING REQUEST (NOT FIRST WAITING)");
        }
    }

    public String toString() {
        return "=====MASTER OF " + this.objId + "(" + this.drcs.getNodeId() + ")[" + this.maxGrantedLock + this.requestedDowngrade + "(" + this.nbDowngradeRequests + "/" + this.users.size() + ")] T=" + Thread.currentThread().hashCode() + " ";
    }

    private void trace(String s) {
        System.out.println(this + " " + s);
    }

    private class Waiter
    implements Serializable {
        public Serializable nodeId;
        byte lck;

        Waiter(Serializable n, byte lck) {
            this.lck = lck;
            this.nodeId = n;
        }
    }
}

