/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.server;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.management.extensions.server.api.IServerManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManagement
extends BaseManagement
implements IServerManagement {
    protected static Logger logger = Log.getLogger((String)"org.ow2.jonas.lib.management.extensions.server");
    private static String connector_prefix = "connector_";

    public List<List<String>> getServerThreadsInformation(String serverName) throws Exception {
        ObjectName on = null;
        String operation = "getThreadStackDumpList";
        String server = this.getDomainName() + ":j2eeType=J2EEServer,name=" + serverName;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try {
            on = new ObjectName(server);
            Object[] param = null;
            String[] signature = null;
            TabularData tabData = (TabularData)JonasManagementRepr.invoke(on, operation, param, signature, serverName);
            CompositeDataSupport cmpData = null;
            for (Object ob : tabData.values()) {
                cmpData = (CompositeDataSupport)ob;
                ArrayList<String> subResult = new ArrayList<String>();
                subResult.add(cmpData.get("id").toString());
                subResult.add(cmpData.get("name").toString());
                subResult.add(cmpData.get("priority").toString());
                subResult.add(cmpData.get("is alive").toString());
                subResult.add(cmpData.get("is interrupted").toString());
                subResult.add(cmpData.get("state").toString());
                subResult.add(cmpData.get("is daemon").toString());
                subResult.add(cmpData.get("stackTrace").toString());
                result.add(subResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not invoke method \"" + operation + "\" on server \"" + server + "\"");
        }
        return result;
    }

    public List<List<String>> getServerThreadsInformation(String jmxUrl, String username, String password) throws Exception {
        ObjectName on = null;
        String operation = "getThreadStackDumpList";
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try {
            on = this.getServerOn(jmxUrl);
            Object[] param = null;
            String[] signature = null;
            TabularData tabData = (TabularData)JonasManagementRepr.invoke(on, operation, param, signature, jmxUrl, username, password);
            CompositeDataSupport cmpData = null;
            for (Object ob : tabData.values()) {
                cmpData = (CompositeDataSupport)ob;
                ArrayList<String> subResult = new ArrayList<String>();
                subResult.add(cmpData.get("id").toString());
                subResult.add(cmpData.get("name").toString());
                subResult.add(cmpData.get("priority").toString());
                subResult.add(cmpData.get("is alive").toString());
                subResult.add(cmpData.get("is interrupted").toString());
                subResult.add(cmpData.get("state").toString());
                subResult.add(cmpData.get("is daemon").toString());
                subResult.add(cmpData.get("stackTrace").toString());
                result.add(subResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not invoke method \"" + operation + "\" on server \"" + on.getKeyProperty("name") + "\"");
        }
        return result;
    }

    private ObjectName getServerOn(String jmxUrl) throws MalformedObjectNameException {
        JMXServiceURL url = null;
        ObjectName on = null;
        try {
            url = new JMXServiceURL(jmxUrl);
            String urlPath = url.getURLPath();
            int prefixIndex = urlPath.indexOf(connector_prefix);
            int serverNameIndex = prefixIndex + connector_prefix.length();
            String serverName = urlPath.substring(serverNameIndex);
            String server = this.getDomainName() + ":j2eeType=J2EEServer,name=" + serverName;
            on = ObjectName.getInstance(server);
        }
        catch (MalformedURLException me) {
            logger.log(BasicLevel.ERROR, (Object)("Malformed URL:" + jmxUrl));
        }
        return on;
    }
}

