/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.execution;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunnableHelper {
    private RunnableHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ExecutionResult<T> execute(ClassLoader loader, IExecution<T> exec) {
        ExecutionResult<T> result = new ExecutionResult<T>();
        ClassLoader old = RunnableHelper.getThreadContextClassLader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            result.setResult(exec.execute());
        }
        catch (Exception e) {
            result.setException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return result;
    }

    public static ClassLoader getThreadContextClassLader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

