/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.PrefixCollector;
import org.w3c.dom.Node;

public class NodeNamespaceContext
implements NamespacePrefixList {
    private static final Collection XML_NS_PREFIX_COLLECTION = Collections.singletonList("xml");
    private static final Collection XMLNS_ATTRIBUTE_COLLECTION = Collections.singletonList("xmlns");
    private Node node;
    private Map declarations;
    private String[] prefixes;

    public NodeNamespaceContext(Node pNode) {
        this.node = pNode;
    }

    private Map getDeclarations() {
        if (this.declarations == null) {
            this.declarations = new HashMap();
            new PrefixCollector(){

                protected void declare(String pPrefix, String pNamespaceURI) {
                    NodeNamespaceContext.this.declarations.put(pPrefix, pNamespaceURI);
                }
            }.searchAllPrefixDeclarations(this.node);
            Set keys = this.declarations.keySet();
            this.prefixes = keys.toArray(new String[keys.size()]);
        }
        return this.declarations;
    }

    public String getNamespaceURI(String pPrefix) {
        if (pPrefix == null) {
            throw new IllegalArgumentException("The prefix must not be null.");
        }
        if ("xml".equals(pPrefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(pPrefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String uri = (String)this.getDeclarations().get(pPrefix);
        return uri == null ? "" : uri;
    }

    public String getPrefix(String pNamespaceURI) {
        if (pNamespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI must not be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pNamespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pNamespaceURI)) {
            return "xmlns";
        }
        Map decl = this.getDeclarations();
        Iterator iter = decl.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!pNamespaceURI.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String pNamespaceURI) {
        if (pNamespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI must not be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pNamespaceURI)) {
            return XML_NS_PREFIX_COLLECTION.iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pNamespaceURI)) {
            return XMLNS_ATTRIBUTE_COLLECTION.iterator();
        }
        ArrayList list = new ArrayList();
        Iterator iter = this.getDeclarations().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!pNamespaceURI.equals(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    public String[] getDeclaredPrefixes() {
        this.getDeclarations();
        return this.prefixes;
    }
}

