/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.stax.ElementReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);
    private AegisDatabinding databinding;
    private Context context;
    private Map<String, Object> properties;

    public XMLStreamDataReader(AegisDatabinding databinding) {
        this.databinding = databinding;
        this.context = new Context(false);
    }

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader input) {
        ElementReader elReader;
        Type type = this.databinding.getType(part);
        if ((type = TypeUtil.getReadType(input, this.context, type)) == null) {
            throw new Fault(new Message("NO_MESSAGE_FOR_PART", LOG, new Object[0]));
        }
        Map<String, Object> props = (Endpoint)this.getProperty(ENDPOINT);
        if (props == null) {
            props = new HashMap();
        }
        this.context.setDelegateProperties(props);
        this.context.setTypeMapping(type.getTypeMapping());
        this.context.setOverrideTypes(CastUtils.cast(this.databinding.getOverrideTypes(), String.class));
        this.context.setFault((Fault)this.getProperty(DataReader.FAULT));
        Object val = this.databinding.getService().get("readXsiType");
        if ("false".equals(val) || Boolean.FALSE.equals(val)) {
            this.context.setReadXsiTypes(false);
        }
        if ((elReader = new ElementReader(input)).isXsiNil()) {
            elReader.readToEnd();
            return null;
        }
        try {
            return type.readObject(elReader, this.context);
        }
        catch (DatabindingException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    @Override
    public Object read(QName name, XMLStreamReader input, Class type) {
        return null;
    }

    @Override
    public Object read(XMLStreamReader input) {
        return null;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.context.setAttachments(attachments);
    }

    @Override
    public void setProperty(String prop, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(prop, value);
    }

    @Override
    public void setSchema(Schema s) {
    }
}

