/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.wsdl11;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;
import org.apache.cxf.tools.wsdlto.core.AbstractWSDLBuilder;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.CustomizationParser;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBindingDeserializer;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBindingSerializer;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.wsdl11.CustomizedWSDLLocator;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLDefinitionBuilder;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDefinitionBuilder
extends AbstractWSDLBuilder<Definition> {
    protected static final Logger LOG = LogUtils.getL7dLogger(JAXWSDefinitionBuilder.class);
    protected CustomizationParser cusParser;
    private Definition wsdlDefinition;
    private List<InputSource> jaxbBindings;
    private Element handlerChain;

    public Definition build() {
        String wsdlURL = (String)this.context.get("wsdlurl");
        return this.build(wsdlURL);
    }

    @Override
    public Definition build(String wsdlURL) {
        WSDLManager mgr = this.bus.getExtension(WSDLManager.class);
        this.registerJaxwsExtension(mgr.getExtensionRegistry());
        WSDLDefinitionBuilder builder = new WSDLDefinitionBuilder(this.bus);
        this.wsdlDefinition = builder.build(wsdlURL);
        this.context.put(Bus.class, this.bus);
        this.context.put("importedDefinition", builder.getImportedDefinitions());
        this.checkSupported(this.wsdlDefinition);
        return this.wsdlDefinition;
    }

    private void registerJaxwsExtension(ExtensionRegistry registry) {
        this.registerJAXWSBinding(registry, Definition.class);
        this.registerJAXWSBinding(registry, Service.class);
        this.registerJAXWSBinding(registry, Fault.class);
        this.registerJAXWSBinding(registry, PortType.class);
        this.registerJAXWSBinding(registry, Operation.class);
        this.registerJAXWSBinding(registry, Binding.class);
        this.registerJAXWSBinding(registry, BindingOperation.class);
    }

    private void registerJAXWSBinding(ExtensionRegistry registry, Class clz) {
        registry.registerSerializer(clz, ToolConstants.JAXWS_BINDINGS, (ExtensionSerializer)new JAXWSBindingSerializer());
        registry.registerDeserializer(clz, ToolConstants.JAXWS_BINDINGS, (ExtensionDeserializer)new JAXWSBindingDeserializer());
        registry.mapExtensionTypes(clz, ToolConstants.JAXWS_BINDINGS, JAXWSBinding.class);
    }

    @Override
    public void customize() {
        if (!this.context.containsKey("binding")) {
            return;
        }
        WSDLManager mgr = this.bus.getExtension(WSDLManager.class);
        mgr.removeDefinition(this.wsdlDefinition);
        this.cusParser = new CustomizationParser();
        this.cusParser.parse(this.context);
        this.jaxbBindings = this.cusParser.getJaxbBindings();
        this.handlerChain = this.cusParser.getHandlerChains();
        this.context.setJaxbBindingFiles(this.jaxbBindings);
        this.context.put("handler-chain", this.handlerChain);
        try {
            this.wsdlDefinition = this.buildCustomizedDefinition();
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, (String)this.context.get("wsdlurl"));
            throw new RuntimeException(msg.toString(), e);
        }
    }

    private void checkSupported(Definition def) throws ToolException {
        if (this.isRPCEncoded(def)) {
            Message msg = new Message("UNSUPPORTED_RPC_ENCODED", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private boolean isRPCEncoded(Definition def) {
        for (Binding binding : def.getBindings().values()) {
            String bindingStyle = SOAPBindingUtil.getBindingStyle(binding);
            for (BindingOperation bop : binding.getBindingOperations()) {
                String bopStyle = SOAPBindingUtil.getSOAPOperationStyle(bop);
                String outputUse = "";
                if (SOAPBindingUtil.getBindingOutputSOAPBody(bop) != null) {
                    outputUse = SOAPBindingUtil.getBindingOutputSOAPBody(bop).getUse();
                }
                String inputUse = "";
                if (SOAPBindingUtil.getBindingInputSOAPBody(bop) != null) {
                    inputUse = SOAPBindingUtil.getBindingInputSOAPBody(bop).getUse();
                }
                if (!SOAPBinding.Style.RPC.name().equalsIgnoreCase(bindingStyle) && !SOAPBinding.Style.RPC.name().equalsIgnoreCase(bopStyle) || !SOAPBinding.Use.ENCODED.name().equalsIgnoreCase(inputUse) && !SOAPBinding.Use.ENCODED.name().equalsIgnoreCase(outputUse)) continue;
                return true;
            }
        }
        return false;
    }

    private Definition buildCustomizedDefinition() throws Exception {
        Map<String, Element> eleMap = this.cusParser.getCustomizedWSDLElements();
        String wsdlUrl = URIParserUtil.getAbsoluteURI((String)this.context.get("wsdlurl"));
        CustomizedWSDLLocator wsdlLocator = new CustomizedWSDLLocator(wsdlUrl, eleMap);
        wsdlLocator.setCatalogResolver(OASISCatalogManager.getCatalogManager(this.bus).getCatalog());
        WSDLManager mgr = this.bus.getExtension(WSDLManager.class);
        WSDLReader reader = mgr.getWSDLFactory().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(mgr.getExtensionRegistry());
        return reader.readWSDL((WSDLLocator)wsdlLocator);
    }

    @Override
    public Definition getWSDLModel() {
        if (this.wsdlDefinition == null) {
            this.build();
            this.customize();
        }
        return this.wsdlDefinition;
    }

    @Override
    public boolean validate(Definition def) throws ToolException {
        return new WSDL11Validator(def, this.context, this.bus).isValid();
    }
}

