/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.SimpleMessageConverter102;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMSUtils {
    static final Logger LOG = LogUtils.getL7dLogger(JMSUtils.class);

    private JMSUtils() {
    }

    public static long getTimeToLive(JMSMessageHeadersType headers) {
        long ttl = -1L;
        if (headers != null && headers.isSetTimeToLive()) {
            ttl = headers.getTimeToLive();
        }
        return ttl;
    }

    public static void setMessageProperties(JMSMessageHeadersType headers, javax.jms.Message message) throws JMSException {
        if (headers != null && headers.isSetProperty()) {
            List<JMSPropertyType> props = headers.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                message.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    public static javax.jms.Message createAndSetPayload(Object payload, Session session, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        return message;
    }

    public static byte[] retrievePayload(javax.jms.Message message) {
        Object converted;
        try {
            converted = new SimpleMessageConverter102().fromMessage(message);
        }
        catch (MessageConversionException e) {
            throw new RuntimeException("Conversion failed", e);
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        if (converted instanceof String) {
            return ((String)converted).getBytes();
        }
        if (converted instanceof byte[]) {
            return (byte[])converted;
        }
        return (byte[])converted;
    }

    public static void populateIncomingContext(javax.jms.Message message, Message inMessage, String headerType) {
        try {
            JMSMessageHeadersType headers = null;
            headers = (JMSMessageHeadersType)inMessage.get(headerType);
            if (headers == null) {
                headers = new JMSMessageHeadersType();
                inMessage.put(headerType, headers);
            }
            headers.setJMSCorrelationID(message.getJMSCorrelationID());
            headers.setJMSDeliveryMode(new Integer(message.getJMSDeliveryMode()));
            headers.setJMSExpiration(new Long(message.getJMSExpiration()));
            headers.setJMSMessageID(message.getJMSMessageID());
            headers.setJMSPriority(new Integer(message.getJMSPriority()));
            headers.setJMSRedelivered(message.getJMSRedelivered());
            headers.setJMSTimeStamp(new Long(message.getJMSTimestamp()));
            headers.setJMSType(message.getJMSType());
            HashMap<String, List<String>> protHeaders = new HashMap<String, List<String>>();
            List<JMSPropertyType> props = headers.getProperty();
            Enumeration enm = message.getPropertyNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                String val = message.getStringProperty(name);
                JMSPropertyType prop = new JMSPropertyType();
                prop.setName(name);
                prop.setValue(val);
                props.add(prop);
                protHeaders.put(name, Collections.singletonList(val));
                if (name.equals("Content-Type") || name.equals("SOAPJMS_contentType") && val != null) {
                    inMessage.put("Content-Type", val);
                }
                protHeaders.put(name, Collections.singletonList(val));
                if (!name.equals("Content-Type") && (!name.equals("SOAPJMS_contentType") || val == null)) continue;
                inMessage.put("Content-Type", val);
            }
            inMessage.put(Message.PROTOCOL_HEADERS, protHeaders);
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    protected static void addProtocolHeaders(javax.jms.Message message, Map<String, List<String>> headers) throws JMSException {
        if (headers == null) {
            return;
        }
        StringBuilder value = new StringBuilder(256);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            value.setLength(0);
            boolean first = true;
            for (String s : entry.getValue()) {
                if (!first) {
                    value.append("; ");
                }
                value.append(s);
                first = false;
            }
            if (entry.getKey().equals("Content-Type")) {
                message.setStringProperty("SOAPJMS_contentType", value.toString());
                continue;
            }
            message.setStringProperty(entry.getKey(), value.toString());
        }
    }

    public static void addContentTypeToProtocolHeader(Message message) {
        List<String> ct;
        String contentType = (String)message.get("Content-Type");
        Map headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (null == headers) {
            headers = new HashMap();
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        if (headers.get("SOAPJMS_contentType") != null) {
            ct = (ArrayList<String>)headers.get("SOAPJMS_contentType");
        } else if (headers.get("Content-Type") != null) {
            ct = (List)headers.get("Content-Type");
        } else {
            ct = new ArrayList<String>();
            headers.put("SOAPJMS_contentType", ct);
        }
        ct.add(contentType);
    }

    public static javax.jms.Message buildJMSMessageFromCXFMessage(Message outMessage, Object payload, String messageType, Session session, Destination replyTo, String correlationId) throws JMSException {
        JMSMessageHeadersType headers;
        javax.jms.Message jmsMessage = JMSUtils.createAndSetPayload(payload, session, messageType);
        if (replyTo != null) {
            jmsMessage.setJMSReplyTo(replyTo);
        }
        if ((headers = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.client.request.headers")) == null) {
            headers = new JMSMessageHeadersType();
        }
        JMSUtils.setMessageProperties(headers, jmsMessage);
        JMSUtils.addContentTypeToProtocolHeader(outMessage);
        Map<String, List<String>> protHeaders = CastUtils.cast((Map)outMessage.get(Message.PROTOCOL_HEADERS));
        JMSUtils.addProtocolHeaders(jmsMessage, protHeaders);
        jmsMessage.setJMSCorrelationID(correlationId);
        return jmsMessage;
    }

    public static String generateCorrelationId() {
        String host = "localhost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            host = addr.getHostName();
        }
        catch (UnknownHostException ukex) {
            // empty catch block
        }
        long time = Calendar.getInstance().getTimeInMillis();
        return host + "_" + System.getProperty("user.name") + "_" + Thread.currentThread() + time;
    }
}

