/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.mi2xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbGenClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.IdentifierMapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.mi2xml.lib.BasicMappingDomtreeBuilder;
import org.objectweb.util.monolog.api.BasicLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RdbDomtreeBuilder
extends BasicMappingDomtreeBuilder {
    public static final String RDB_CLASS_MAPPING = "rdb-class-mapping";
    public static final String COLOCATED_CLASS = "colocated-class";
    public static final String RDB_TABLE_SPEC = "rdb-table-spec";
    public static final String ID_MAPPING = "id-mapping";
    public static final String RDB_CLASS_REF_MAPPING = "rdb-class-ref-mapping";
    public static final String RDB_GEN_CLASS_REF_MAPPING = "rdb-gen-class-ref-mapping";
    public static final String RDB_REF_MAPPING = "rdb-ref-mapping";
    public static final String RDB_EXTERNAL_TABLE_SPEC = "rdb-external-table-spec";
    public static final String RDB_JOIN = "rdb-join";
    public static final String RDB_FILTER_SPEC = "rdb-filter-spec";
    public static final String RDB_FILTER = "rdb-filter";
    public static final String RDB_COLUMN_SPEC = "rdb-column-spec";
    public static final String RDB_COLUMN_MATCH = "rdb-column-match";
    public static final String RDB_GEN_CLASS_MAPPING = "rdb-gen-class-mapping";
    public static final String RDB_EXTENSION_REF_MAPPING = "rdb-extension-ref-mapping";
    public static final String PARENT_CLASS_MAPPING = "parent-class-mapping";
    public static final String LINKEND_SEP = "/";

    public void processClassMapping(Document document, Element mappingElement, ClassMapping classMapping) throws PException {
        IdentifierMapping identifierMapping;
        RdbFilter filter;
        RdbTable table;
        Element cmElement = document.createElement(RDB_CLASS_MAPPING);
        mappingElement.appendChild(cmElement);
        if (!classMapping.getDependencies().isEmpty()) {
            Iterator classNameIterator = classMapping.getDependencies().iterator();
            while (classNameIterator.hasNext()) {
                String jormClassName = (String)classNameIterator.next();
                Element ccElement = document.createElement(COLOCATED_CLASS);
                ccElement.setAttribute("class-name", jormClassName);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + ccElement.getTagName() + ">"));
                    this.logger.log(BasicLevel.DEBUG, (Object)(" colocated class =<" + jormClassName + ">"));
                }
                cmElement.appendChild(ccElement);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end =<" + ccElement.getTagName() + ">"));
            }
        }
        if ((table = ((RdbClassMultiMapping)classMapping).getRdbTable()) != null) {
            String colocated = table.isColocated() ? "TRUE" : "FALSE";
            String colocatedMaster = table.isColocatedMaster() ? "TRUE" : "FALSE";
            Element tableElement = document.createElement(RDB_TABLE_SPEC);
            tableElement.setAttribute("table-name", table.getName());
            tableElement.setAttribute("colocated", colocated);
            tableElement.setAttribute("colocated-master", colocatedMaster);
            cmElement.appendChild(tableElement);
            this.processRdbTableSpec(document, tableElement, table);
        }
        if (!((RdbClassMultiMapping)classMapping).getRdbExternalTables().isEmpty()) {
            Iterator etIterator = ((RdbClassMultiMapping)classMapping).getRdbExternalTables().iterator();
            while (etIterator.hasNext()) {
                RdbExternalTable externalTable = (RdbExternalTable)etIterator.next();
                String etcolocated = externalTable.isColocated() ? "TRUE" : "FALSE";
                String etcolocatedMaster = externalTable.isColocatedMaster() ? "TRUE" : "FALSE";
                Element etElement = document.createElement(RDB_EXTERNAL_TABLE_SPEC);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + etElement.getTagName() + ">"));
                }
                etElement.setAttribute("table-name", externalTable.getName());
                etElement.setAttribute("colocated", etcolocated);
                etElement.setAttribute("colocated-master", etcolocatedMaster);
                cmElement.appendChild(etElement);
                this.processRdbExternalTableSpec(document, etElement, externalTable);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end =<" + etElement.getTagName() + ">"));
            }
        }
        if ((filter = ((RdbClassMultiMapping)classMapping).getRdbFilter()) != null) {
            Element filterElement = document.createElement(RDB_FILTER_SPEC);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + filterElement.getTagName() + ">"));
            }
            cmElement.appendChild(filterElement);
            Element rdbFilterElement = document.createElement(RDB_FILTER);
            String filterStr = filter.getStringExpression();
            rdbFilterElement.setAttribute("value", filterStr);
            filterElement.appendChild(rdbFilterElement);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("rdf-filter <" + filterStr + ">"));
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("end =<" + filterElement.getTagName() + ">"));
            }
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("rdb-class-mapping.linkedMO = " + ((Class)classMapping.getLinkedMO()).getFQName()));
        }
        Collection pcm = classMapping.getParentClassMappings();
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("pcm = " + pcm));
        }
        if (!pcm.isEmpty()) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"begin =<parent-class-mapping>");
            }
            Iterator pcmIterator = pcm.iterator();
            while (pcmIterator.hasNext()) {
                ParentClassMapping parentClassMapping = (ParentClassMapping)pcmIterator.next();
                Element pcmElem = document.createElement(PARENT_CLASS_MAPPING);
                pcmElem.setAttribute("link-end", parentClassMapping.getFQName());
                pcmElem.setAttribute("rule-name", parentClassMapping.getRuleName());
                cmElement.appendChild(pcmElem);
            }
        }
        if ((identifierMapping = classMapping.getIdentifierMapping()) != null) {
            NameDef idNameDef = (NameDef)identifierMapping.getLinkedMO();
            Class parent = (Class)idNameDef.getParent();
            String linkend = null;
            linkend = parent == this.currentClass ? idNameDef.getName() : LINKEND_SEP + parent.getFQName() + LINKEND_SEP + idNameDef.getName();
            Element idNameDefElement = document.createElement(ID_MAPPING);
            idNameDefElement.setAttribute("link-end", linkend);
            cmElement.appendChild(idNameDefElement);
        }
        if (!classMapping.getReferenceMappings().isEmpty()) {
            Iterator rmIterator = classMapping.getReferenceMappings().iterator();
            while (rmIterator.hasNext()) {
                ReferenceMapping referenceMapping = (ReferenceMapping)rmIterator.next();
                NameDef refNameDef = (NameDef)referenceMapping.getLinkedMO();
                String ruleName = referenceMapping.getRuleName();
                Reference reference = (Reference)refNameDef.getParent();
                String linkend = null;
                Class clazz = (Class)reference.getParent();
                linkend = clazz == this.currentClass ? (refNameDef.getName().equals("") ? reference.getName() : reference.getName() + LINKEND_SEP + refNameDef.getName()) : LINKEND_SEP + clazz.getFQName() + LINKEND_SEP + reference.getName() + LINKEND_SEP + refNameDef.getName();
                Element refElement = null;
                if (refNameDef.getParent() instanceof ClassRef) {
                    refElement = document.createElement(RDB_CLASS_REF_MAPPING);
                } else if (refNameDef.getParent() instanceof GenClassRef) {
                    refElement = document.createElement(RDB_GEN_CLASS_REF_MAPPING);
                }
                refElement.setAttribute("link-end", linkend);
                refElement.setAttribute("rule-name", ruleName);
                cmElement.appendChild(refElement);
            }
        }
    }

    private void processRdbTableSpec(Document document, Element tableElement, RdbTable table) {
        if (!table.getPrimitiveElementMappings().isEmpty()) {
            Iterator pemIterator = table.getPrimitiveElementMappings().iterator();
            while (pemIterator.hasNext()) {
                RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)pemIterator.next();
                String notNull = pem.isNotNull() ? "TRUE" : "FALSE";
                PrimitiveElement pe = (PrimitiveElement)pem.getLinkedMO();
                Element csElement = document.createElement(RDB_COLUMN_SPEC);
                MetaObject parent = pe.getParent();
                String linkend = pe.getName();
                if (parent instanceof Class) {
                    boolean isInherited;
                    boolean bl = isInherited = parent != this.currentClass;
                    if (isInherited) {
                        linkend = LINKEND_SEP + ((Class)parent).getFQName() + LINKEND_SEP + pe.getName();
                    }
                }
                this.logger.log(BasicLevel.DEBUG, (Object)(" rdb-column-spec link-end =<" + linkend + ">"));
                csElement.setAttribute("link-end", linkend);
                csElement.setAttribute("column-name", pem.getName());
                csElement.setAttribute("sql-type", pem.getType());
                csElement.setAttribute("not-null", notNull);
                csElement.setAttribute("join-name", "");
                tableElement.appendChild(csElement);
            }
        }
    }

    private void processRdbExternalTableSpec(Document document, Element etElement, RdbExternalTable externalTable) throws PException {
        Iterator<Object> joinIterator = externalTable.getRdbJoins().iterator();
        while (joinIterator.hasNext()) {
            RdbJoin join = (RdbJoin)joinIterator.next();
            Element joinElement = document.createElement(RDB_JOIN);
            joinElement.setAttribute("name", join.getName());
            etElement.appendChild(joinElement);
            this.processRdbJoin(document, joinElement, join);
        }
        if (!externalTable.getPrimitiveElementMappings().isEmpty()) {
            Iterator peIterator = externalTable.getPrimitiveElementMappings().iterator();
            Element csElement = null;
            while (peIterator.hasNext()) {
                RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)peIterator.next();
                String notNull = pem.isNotNull() ? "TRUE" : "FALSE";
                PrimitiveElement pe = null;
                RdbJoin join = null;
                Map join2pe = pem.getPrimitiveElementByRdbJoin();
                if (join2pe != null) {
                    joinIterator = join2pe.keySet().iterator();
                    while (joinIterator.hasNext()) {
                        join = (RdbJoin)joinIterator.next();
                        pe = (PrimitiveElement)join2pe.get(join);
                        csElement = document.createElement(RDB_COLUMN_SPEC);
                        csElement.setAttribute("link-end", pe.getName());
                        csElement.setAttribute("column-name", pem.getName());
                        csElement.setAttribute("sql-type", pem.getType());
                        csElement.setAttribute("not-null", notNull);
                        csElement.setAttribute("join-name", join.getName());
                        etElement.appendChild(csElement);
                    }
                } else {
                    pe = (PrimitiveElement)pem.getLinkedMO();
                    join = pem.getJoinByPrimitiveElement(pe);
                    if (join == null) {
                        throw new PException("No join defined in the external table for the field: " + pe.getName());
                    }
                    csElement = document.createElement(RDB_COLUMN_SPEC);
                    csElement.setAttribute("link-end", pe.getName());
                    csElement.setAttribute("column-name", pem.getName());
                    csElement.setAttribute("sql-type", pem.getType());
                    csElement.setAttribute("not-null", notNull);
                    csElement.setAttribute("join-name", join.getName());
                    etElement.appendChild(csElement);
                }
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + csElement.getTagName() + ">"));
                }
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end =<" + csElement.getTagName() + ">"));
            }
        }
    }

    private void processRdbJoin(Document document, Element joinElement, RdbJoin join) {
        Iterator column1Iterator = join.getPTJoinColumnNames().iterator();
        Iterator column2Iterator = join.getETJoinColumnNames().iterator();
        while (column1Iterator.hasNext()) {
            String column1 = (String)column1Iterator.next();
            String column2 = (String)column2Iterator.next();
            Element cmElement = document.createElement(RDB_COLUMN_MATCH);
            cmElement.setAttribute("column1", column1);
            cmElement.setAttribute("column2", column2);
            joinElement.appendChild(cmElement);
        }
    }

    public void processGenClassMapping(Document document, Element mappingElement, GenClassMapping genClassMapping) throws PException {
        GenClassRef genClassRef = (GenClassRef)genClassMapping.getLinkedMO();
        Element gcmElement = document.createElement(RDB_GEN_CLASS_MAPPING);
        gcmElement.setAttribute("link-end", (String)this.metaobject2idvalue.get(genClassRef));
        mappingElement.appendChild(gcmElement);
        RdbTable table = ((RdbGenClassMapping)genClassMapping).getRdbTable();
        String colocated = table.isColocated() ? "TRUE" : "FALSE";
        String colocatedMaster = table.isColocatedMaster() ? "TRUE" : "FALSE";
        Element tableElement = document.createElement(RDB_TABLE_SPEC);
        tableElement.setAttribute("table-name", table.getName());
        tableElement.setAttribute("colocated", colocated);
        tableElement.setAttribute("colocated-master", colocatedMaster);
        gcmElement.appendChild(tableElement);
        this.processRdbTableSpec(document, tableElement, table);
        if (((RdbGenClassMapping)genClassMapping).getRdbExternalTables() != null) {
            Iterator etIterator = ((RdbClassMultiMapping)genClassMapping).getRdbExternalTables().iterator();
            while (etIterator.hasNext()) {
                RdbExternalTable externalTable = (RdbExternalTable)etIterator.next();
                String etcolocated = externalTable.isColocated() ? "TRUE" : "FALSE";
                String etcolocatedMaster = externalTable.isColocatedMaster() ? "TRUE" : "FALSE";
                Element etElement = document.createElement(RDB_EXTERNAL_TABLE_SPEC);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + etElement.getTagName() + ">"));
                }
                etElement.setAttribute("table-name", externalTable.getName());
                etElement.setAttribute("colocated", etcolocated);
                etElement.setAttribute("colocated-master", etcolocatedMaster);
                gcmElement.appendChild(etElement);
                this.processRdbExternalTableSpec(document, etElement, externalTable);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end =<" + etElement.getTagName() + ">"));
            }
        }
        IdentifierMapping identifierMapping = genClassMapping.getIdentifierMapping();
        NameDef idNameDef = (NameDef)identifierMapping.getLinkedMO();
        Element idNameDefElement = document.createElement(ID_MAPPING);
        idNameDefElement.setAttribute("link-end", idNameDef.getName());
        gcmElement.appendChild(idNameDefElement);
        if (genClassMapping.getReferenceMapping() != null) {
            ReferenceMapping referenceMapping = genClassMapping.getReferenceMapping();
            NameDef refNameDef = (NameDef)referenceMapping.getLinkedMO();
            Element refElement = document.createElement(RDB_REF_MAPPING);
            refElement.setAttribute("link-end", refNameDef.getName());
            refElement.setAttribute("rule-name", referenceMapping.getRuleName());
            gcmElement.appendChild(refElement);
        }
    }
}

