/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends Processor {
    public static final int STRATEGY_HIGHEST = 1;
    public static final int STRATEGY_LOWEST = 2;
    public static final String BUILDFILE = "build.bnd";
    public static final String CNFDIR = "cnf";
    static Map<File, WeakReference<Workspace>> cache = Workspace.newHashMap();
    final Map<String, Project> models = Workspace.newHashMap();

    public static Project getProject(File projectDir) throws Exception {
        projectDir = projectDir.getAbsoluteFile();
        assert (projectDir.isDirectory());
        Workspace ws = Workspace.getWorkspace(projectDir.getParentFile());
        return ws.getProject(projectDir.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workspace getWorkspace(File workspaceDir) throws Exception {
        workspaceDir = workspaceDir.getAbsoluteFile();
        Map<File, WeakReference<Workspace>> map = cache;
        synchronized (map) {
            Workspace ws;
            WeakReference<Workspace> wsr = cache.get(workspaceDir);
            if (wsr == null || (ws = (Workspace)wsr.get()) == null) {
                ws = new Workspace(workspaceDir);
                cache.put(workspaceDir, new WeakReference<Workspace>(ws));
            }
            return ws;
        }
    }

    public Workspace(File dir) throws Exception {
        dir = dir.getAbsoluteFile();
        dir.mkdirs();
        assert (dir.isDirectory());
        File buildDir = new File(dir, CNFDIR).getAbsoluteFile();
        File buildFile = new File(buildDir, BUILDFILE).getAbsoluteFile();
        if (!buildFile.isFile()) {
            this.warning("No Build File in " + dir);
        }
        this.setProperties(buildFile, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(String bsn) throws Exception {
        Map<String, Project> map = this.models;
        synchronized (map) {
            Project project = this.models.get(bsn);
            if (project != null) {
                return project;
            }
            File projectDir = this.getFile(bsn);
            project = new Project(this, projectDir);
            this.models.put(bsn, project);
            return project;
        }
    }

    public boolean isPresent(String name) {
        return this.models.containsKey(name);
    }

    public Collection<Project> getCurrentProjects() {
        return this.models.values();
    }

    @Override
    public boolean refresh() {
        if (super.refresh()) {
            for (Project project : this.getCurrentProjects()) {
                project.propertiesChanged();
            }
            return true;
        }
        return false;
    }
}

