/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.lib.deployer.RepoDeployer;
import aQute.lib.jardiff.Diff;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.libg.generics.Create;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bnd
extends Processor {
    PrintStream out = System.out;
    static boolean exceptions = false;
    static boolean failok = false;
    private Project project;
    static final int BUILD_SOURCES = 1;
    static final int BUILD_POM = 2;
    static final int BUILD_FORCE = 4;
    static final int VERIFY = 1;
    static final int MANIFEST = 2;
    static final int LIST = 4;
    static final int ECLIPSE = 8;
    static final int IMPEXP = 16;
    static final int USES = 32;
    static final int USEDBY = 64;
    static final int COMPONENT = 128;
    static final int HEX = 0;

    public static void main(String[] args) {
        block3: {
            bnd main = new bnd();
            try {
                main.run(args);
                if (failok) {
                    return;
                }
                System.exit(main.getErrors().size());
            }
            catch (Exception e) {
                System.err.println("Software error occurred " + e);
                if (!exceptions) break block3;
                e.printStackTrace();
            }
        }
        System.exit(-1);
    }

    void run(String[] args) throws Exception {
        int cnt = 0;
        int i = 0;
        while (i < args.length) {
            if ("-failok".equals(args[i])) {
                failok = true;
            } else if ("-exceptions".equals(args[i])) {
                exceptions = true;
            } else if ("-pedantic".equals(args[i])) {
                this.setPedantic(true);
            } else if ("-base".equals(args[i])) {
                this.setBase(new File(args[++i]).getAbsoluteFile());
                if (!this.getBase().isDirectory()) {
                    System.out.println("-base must be a valid directory");
                }
            } else {
                if ("wrap".equals(args[i])) {
                    ++cnt;
                    this.doWrap(args, ++i);
                    break;
                }
                if ("print".equals(args[i])) {
                    ++cnt;
                    this.doPrint(args, ++i);
                    break;
                }
                if ("release".equals(args[i])) {
                    ++cnt;
                    this.doRelease(args, ++i);
                    break;
                }
                if ("debug".equals(args[i])) {
                    ++cnt;
                    this.debug(args, ++i);
                    break;
                }
                if ("view".equals(args[i])) {
                    ++cnt;
                    this.doView(args, ++i);
                    break;
                }
                if ("build".equals(args[i])) {
                    ++cnt;
                    this.doBuild(args, ++i);
                    break;
                }
                if ("xref".equals(args[i])) {
                    ++cnt;
                    this.doXref(args, ++i);
                    break;
                }
                if ("eclipse".equals(args[i])) {
                    ++cnt;
                    this.doEclipse(args, ++i);
                    break;
                }
                if ("repo".equals(args[i])) {
                    ++cnt;
                    this.doRepo(args, ++i);
                    break;
                }
                if ("diff".equals(args[i])) {
                    ++cnt;
                    this.doDiff(args, ++i);
                    break;
                }
                if ("test".equals(args[i])) {
                    ++cnt;
                    this.test(args, ++i);
                    break;
                }
                if ("help".equals(args[i])) {
                    ++cnt;
                    this.doHelp(args, ++i);
                    break;
                }
                ++cnt;
                String path = args[i];
                if (path.startsWith("-")) {
                    this.doHelp(args, i);
                    this.error("Invalid option on commandline: " + args[i]);
                    break;
                }
                if (path.endsWith(".bnd")) {
                    this.doBuild(new File(path), new File[0], new File[0], null, "", new File(path).getParentFile(), 0, new HashSet<File>());
                } else if (path.endsWith(".jar") || path.endsWith(".bar")) {
                    this.doPrint(path, -1);
                } else {
                    this.doHelp(args, i);
                    this.error("Invalid commandline: " + args[i]);
                    break;
                }
            }
            ++i;
        }
        if (cnt == 0) {
            File f = new File("bnd.bnd");
            if (f.exists()) {
                this.doBuild(f, new File[0], new File[0], null, "", f.getParentFile(), 0, new HashSet<File>());
            } else {
                this.doHelp();
                this.error("No files on commandline");
            }
        }
        int n = 1;
        switch (this.getErrors().size()) {
            case 0: {
                break;
            }
            case 1: {
                System.err.println("One error");
                break;
            }
            default: {
                System.err.println(String.valueOf(this.getErrors().size()) + " errors");
            }
        }
        for (String msg : this.getErrors()) {
            System.err.println(String.valueOf(n++) + " : " + msg);
        }
        n = 1;
        switch (this.getWarnings().size()) {
            case 0: {
                break;
            }
            case 1: {
                System.err.println("One warning");
                break;
            }
            default: {
                System.err.println(String.valueOf(this.getWarnings().size()) + " warnings");
            }
        }
        for (String msg : this.getWarnings()) {
            System.err.println(String.valueOf(n++) + " : " + msg);
        }
    }

    private void doRelease(String[] args, int i) throws Exception {
        Project project = this.getProject();
        project.release(false);
        this.getInfo(project);
    }

    private void doXref(String[] args, int i) {
        while (i < args.length) {
            try {
                File file = new File(args[i]);
                Jar jar = new Jar(file.getName(), file);
                try {
                    for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                        String key = entry.getKey();
                        Resource r = entry.getValue();
                        if (!key.endsWith(".class")) continue;
                        InputStream in = r.openInputStream();
                        Clazz clazz = new Clazz(key);
                        this.out.print(key);
                        Set<String> xref = clazz.xref(in);
                        in.close();
                        for (String element : xref) {
                            this.out.print("\t");
                            this.out.print(element);
                        }
                        this.out.println();
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doEclipse(String[] args, int i) throws Exception {
        block1: {
            dir = new File("").getAbsoluteFile();
            if (args.length != i) ** GOTO lbl7
            this.doEclipse(dir);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.doEclipse(new File(dir, args[i]));
                ++i;
lbl7:
                // 2 sources

                ** while (i < args.length)
            }
        }
    }

    private void doEclipse(File file) throws Exception {
        if (!file.isDirectory()) {
            this.error("Eclipse requires a path to a directory: " + file.getAbsolutePath());
        } else {
            File cp = new File(file, ".classpath");
            if (!cp.exists()) {
                this.error("Cannot find .classpath in project directory: " + file.getAbsolutePath());
            } else {
                EclipseClasspath eclipse = new EclipseClasspath(this, file.getParentFile(), file);
                this.out.println("Classpath    " + eclipse.getClasspath());
                this.out.println("Dependents   " + eclipse.getDependents());
                this.out.println("Sourcepath   " + eclipse.getSourcepath());
                this.out.println("Output       " + eclipse.getOutput());
                this.out.println();
            }
        }
    }

    private void doBuild(String[] args, int i) throws Exception {
        File[] classpath = new File[]{};
        File workspace = null;
        File[] sourcepath = new File[]{};
        File output = null;
        String eclipse = "";
        int options = 0;
        while (i < args.length) {
            if ("-workspace".startsWith(args[i])) {
                workspace = new File(args[++i]);
            } else if ("-classpath".startsWith(args[i])) {
                classpath = this.getClasspath(args[++i]);
            } else if ("-sourcepath".startsWith(args[i])) {
                String arg = args[++i];
                String[] spaces = arg.split("\\s*,\\s*");
                sourcepath = new File[spaces.length];
                int j = 0;
                while (j < spaces.length) {
                    File f = new File(spaces[j]);
                    if (!f.exists()) {
                        this.error("No such sourcepath entry: " + f.getAbsolutePath());
                    }
                    sourcepath[j] = f;
                    ++j;
                }
            } else if ("-eclipse".startsWith(args[i])) {
                eclipse = args[++i];
            } else if ("-noeclipse".startsWith(args[i])) {
                eclipse = null;
            } else if ("-output".startsWith(args[i])) {
                output = new File(args[++i]);
            } else if ("-sources".startsWith(args[i])) {
                options |= 1;
            } else if ("-pom".startsWith(args[i])) {
                options |= 2;
            } else if ("-force".startsWith(args[i])) {
                options |= 4;
            } else if (args[i].startsWith("-")) {
                this.error("Invalid option for bnd: " + args[i]);
            } else {
                File properties = new File(args[i]);
                if (!properties.exists()) {
                    this.error("Cannot find bnd file: " + args[i]);
                } else {
                    if (workspace == null) {
                        workspace = properties.getParentFile();
                    }
                    this.doBuild(properties, classpath, sourcepath, output, eclipse, workspace, options, new HashSet<File>());
                }
                output = null;
            }
            ++i;
        }
    }

    private File[] getClasspath(String string) {
        String[] spaces = string.split("\\s*,\\s*");
        File[] classpath = new File[spaces.length];
        int j = 0;
        while (j < spaces.length) {
            File f = new File(spaces[j]);
            if (!f.exists()) {
                this.error("No such classpath entry: " + f.getAbsolutePath());
            }
            classpath[j] = f;
            ++j;
        }
        return classpath;
    }

    private void doBuild(File properties, File[] classpath, File[] sourcepath, File output, String eclipse, File workspace, int options, Set<File> building) throws Exception {
        if (building.contains(properties = properties.getAbsoluteFile())) {
            this.error("Circular dependency in pre build " + properties);
            return;
        }
        building.add(properties);
        Builder builder = new Builder();
        try {
            String prebuild;
            builder.setPedantic(this.isPedantic());
            builder.setProperties(properties);
            if (output == null) {
                String out = builder.getProperty("-output");
                if (out != null) {
                    output = bnd.getFile(properties.getParentFile(), out);
                    if (!output.getName().endsWith(".jar")) {
                        output.mkdirs();
                    }
                } else {
                    output = properties.getAbsoluteFile().getParentFile();
                }
            }
            if ((prebuild = builder.getProperty("-prebuild")) != null) {
                this.prebuild(prebuild, properties.getParentFile(), classpath, sourcepath, output, eclipse, workspace, options, building);
            }
            this.doEclipse(builder, properties, classpath, sourcepath, eclipse, workspace);
            if ((options & 1) != 0) {
                builder.getProperties().setProperty("-sources", "true");
            }
            if (failok) {
                builder.setProperty("-failok", "true");
            }
            Jar jar = builder.build();
            this.getInfo(builder);
            if (this.getErrors().size() > 0 && !failok) {
                return;
            }
            String name = String.valueOf(builder.getBsn()) + ".jar";
            if (output.isDirectory()) {
                output = new File(output, name);
            }
            if ((options & 2) != 0) {
                builder.doPom(jar);
            }
            jar.setName(output.getName());
            String msg = "";
            if (!output.exists() || output.lastModified() <= jar.lastModified() || (options & 4) != 0) {
                jar.write(output);
            } else {
                msg = "(not modified)";
            }
            this.statistics(jar, output, msg);
        }
        finally {
            builder.close();
        }
    }

    private void prebuild(String prebuild, File base, File[] classpath, File[] sourcepath, File output, String eclipse2, File workspace, int options, Set<File> building) throws Exception {
        if (output.isFile()) {
            output = output.getParentFile();
        }
        Collection<String> parts = Processor.split(prebuild);
        for (String part : parts) {
            File f = new File(part);
            if (!f.exists()) {
                f = new File(base, part);
            }
            if (!f.exists()) {
                this.error("Trying to build a non-existent file: " + parts);
                continue;
            }
            try {
                this.doBuild(f, classpath, sourcepath, output, eclipse2, workspace, options, building);
            }
            catch (Exception e) {
                this.error("Trying to build: " + part + " " + e);
            }
        }
    }

    private void statistics(Jar jar, File output, String msg) {
        this.out.println(String.valueOf(jar.getName()) + " " + jar.getResources().size() + " " + output.length() + msg);
    }

    void doEclipse(Builder builder, File properties, File[] classpath, File[] sourcepath, String eclipse, File workspace) throws IOException {
        if (eclipse != null) {
            File project = new File(workspace, eclipse).getAbsoluteFile();
            if (project.exists() && project.isDirectory()) {
                try {
                    EclipseClasspath path = new EclipseClasspath(this, project.getParentFile(), project);
                    List<File> newClasspath = Create.copy(Arrays.asList(classpath));
                    newClasspath.addAll(path.getClasspath());
                    classpath = newClasspath.toArray(classpath);
                    List<File> newSourcepath = Create.copy(Arrays.asList(sourcepath));
                    newSourcepath.addAll(path.getSourcepath());
                    sourcepath = newSourcepath.toArray(sourcepath);
                }
                catch (Exception e) {
                    if (eclipse.length() > 0) {
                        this.error("Eclipse specified (" + eclipse + ") but getting error processing: " + e);
                    }
                }
            } else if (eclipse.length() > 0) {
                this.error("Eclipse specified (" + eclipse + ") but no project directory found");
            }
        }
        builder.setClasspath(classpath);
        builder.setSourcepath(sourcepath);
    }

    private void doHelp() {
        this.doHelp(new String[0], 0);
    }

    /*
     * Unable to fully structure code
     */
    private void doHelp(String[] args, int i) {
        block10: {
            if (args.length > i) ** GOTO lbl21
            this.out.println("bnd -failok? -exceptions? ( wrap | print | build | eclipse | xref | view )?");
            this.out.println("See http://www.aQute.biz/Code/Bnd");
            break block10;
lbl-1000:
            // 1 sources

            {
                if ("wrap".equals(args[i])) {
                    this.out.println("bnd wrap (-output <file|dir>)? (-properties <file>)? <jar-file>");
                } else if ("print".equals(args[i])) {
                    this.out.println("bnd wrap -verify? -manifest? -list? -eclipse <jar-file>");
                } else if ("build".equals(args[i])) {
                    this.out.println("bnd build (-output <file|dir>)? (-classpath <list>)? (-sourcepath <list>)? ");
                    this.out.println("    -eclipse? -noeclipse? -sources? <bnd-file>");
                } else if ("eclipse".equals(args[i])) {
                    this.out.println("bnd eclipse");
                } else if ("view".equals(args[i])) {
                    this.out.println("bnd view <file.jar> <resource-names>+");
                }
                ++i;
lbl21:
                // 2 sources

                ** while (args.length > i)
            }
        }
    }

    private void doPrint(String[] args, int i) throws Exception {
        int options = 0;
        while (i < args.length) {
            if ("-verify".startsWith(args[i])) {
                options |= 1;
            } else if ("-manifest".startsWith(args[i])) {
                options |= 2;
            } else if ("-list".startsWith(args[i])) {
                options |= 4;
            } else if ("-eclipse".startsWith(args[i])) {
                options |= 8;
            } else if ("-impexp".startsWith(args[i])) {
                options |= 0x10;
            } else if ("-uses".startsWith(args[i])) {
                options |= 0x20;
            } else if ("-usedby".startsWith(args[i])) {
                options |= 0x40;
            } else if ("-component".startsWith(args[i])) {
                options |= 0x80;
            } else if ("-all".startsWith(args[i])) {
                options = -1;
            } else if (args[i].startsWith("-")) {
                this.error("Invalid option for print: " + args[i]);
            } else {
                this.doPrint(args[i], options);
            }
            ++i;
        }
    }

    public void doPrint(String string, int options) throws Exception {
        block23: {
            File file = new File(string);
            if (!file.exists()) {
                this.error("File to print not found: " + string);
            } else {
                if (options == 0) {
                    options = 51;
                }
                Jar jar = new Jar(file.getName(), file);
                try {
                    if ((options & 1) != 0) {
                        Verifier verifier = new Verifier(jar);
                        verifier.setPedantic(this.isPedantic());
                        verifier.verify();
                        this.getInfo(verifier);
                    }
                    if ((options & 2) != 0) {
                        Manifest manifest = jar.getManifest();
                        if (manifest == null) {
                            this.warning("JAR file has no manifest " + string);
                        } else {
                            this.out.println("[MANIFEST " + jar.getName() + "]");
                            TreeSet<String> sorted = new TreeSet<String>();
                            for (Object element : manifest.getMainAttributes().keySet()) {
                                sorted.add(element.toString());
                            }
                            for (String key : sorted) {
                                String value = manifest.getMainAttributes().getValue(key);
                                this.format("%-40s %-40s\r\n", key, value);
                            }
                        }
                        this.out.println();
                    }
                    if ((options & 0x10) != 0) {
                        this.out.println("[IMPEXP]");
                        Manifest m = jar.getManifest();
                        if (m != null) {
                            Map<String, Map<String, String>> imports = this.parseHeader(m.getMainAttributes().getValue("Import-Package"));
                            Map<String, Map<String, String>> exports = this.parseHeader(m.getMainAttributes().getValue("Export-Package"));
                            imports.keySet().removeAll((Collection)exports.keySet());
                            this.print("Import-Package", new TreeMap<String, Map<String, String>>(imports));
                            this.print("Export-Package", new TreeMap<String, Map<String, String>>(exports));
                        } else {
                            this.warning("File has no manifest");
                        }
                    }
                    if ((options & 0x60) != 0) {
                        this.out.println();
                        Analyzer analyzer = new Analyzer();
                        analyzer.setPedantic(this.isPedantic());
                        analyzer.setJar(jar);
                        analyzer.analyze();
                        if ((options & 0x20) != 0) {
                            this.out.println("[USES]");
                            this.printMapOfSets(new TreeMap<String, Set<String>>(analyzer.getUses()));
                            this.out.println();
                        }
                        if ((options & 0x40) != 0) {
                            this.out.println("[USEDBY]");
                            this.printMapOfSets(this.invertMapOfCollection(analyzer.getUses()));
                        }
                    }
                    if ((options & 0x80) != 0) {
                        this.printComponents(this.out, jar);
                    }
                    if ((options & 4) == 0) break block23;
                    this.out.println("[LIST]");
                    for (Map.Entry<String, Map<String, Resource>> entry : jar.getDirectories().entrySet()) {
                        String name = entry.getKey();
                        Map<String, Resource> contents = entry.getValue();
                        this.out.println(name);
                        if (contents != null) {
                            for (String element : contents.keySet()) {
                                int n = element.lastIndexOf(47);
                                if (n > 0) {
                                    element = element.substring(n + 1);
                                }
                                this.out.print("  ");
                                this.out.print(element);
                                this.out.println();
                            }
                            continue;
                        }
                        this.out.println(String.valueOf(name) + " <no contents>");
                    }
                    this.out.println();
                }
                finally {
                    jar.close();
                }
            }
        }
    }

    private void printComponents(PrintStream out, Jar jar) throws IOException {
        out.println("[COMPONENTS]");
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            out.println("No manifest");
            return;
        }
        String componentHeader = manifest.getMainAttributes().getValue("Service-Component");
        Map<String, Map<String, String>> clauses = this.parseHeader(componentHeader);
        for (String path : clauses.keySet()) {
            out.println(path);
        }
        out.println();
    }

    Map<String, Set<String>> invertMapOfCollection(Map<String, Set<String>> map) {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            if (name.startsWith("java.") && !name.equals("java.sql")) continue;
            Collection used = entry.getValue();
            for (String n : used) {
                if (n.startsWith("java.") && !n.equals("java.sql")) continue;
                TreeSet<String> set = (TreeSet<String>)result.get(n);
                if (set == null) {
                    set = new TreeSet<String>();
                    result.put(n, set);
                }
                set.add(name);
            }
        }
        return result;
    }

    void printMapOfSets(Map<String, Set<String>> map) {
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            TreeSet<String> used = new TreeSet<String>((Collection)entry.getValue());
            Iterator k = used.iterator();
            while (k.hasNext()) {
                String n = (String)k.next();
                if (!n.startsWith("java.") || n.equals("java.sql")) continue;
                k.remove();
            }
            String list = this.vertical(40, used);
            this.format("%-40s %s", name, list);
        }
    }

    String vertical(int padding, Set<String> used) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (String name : used) {
            sb.append(del);
            sb.append(name);
            sb.append("\r\n");
            del = this.pad(padding);
        }
        return sb.toString();
    }

    String pad(int i) {
        StringBuffer sb = new StringBuffer();
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private void doView(String[] args, int i) throws Exception {
        int options = 0;
        String charset = "UTF-8";
        File output = null;
        while (i < args.length) {
            if ("-charset".startsWith(args[i])) {
                charset = args[++i];
            } else {
                if (!"-output".startsWith(args[i])) break;
                output = new File(args[++i]);
            }
            ++i;
        }
        if (i >= args.length) {
            this.error("Insufficient arguments for view, no JAR file");
            return;
        }
        String jar = args[i++];
        if (i >= args.length) {
            this.error("No Files to view");
            return;
        }
        this.doView(jar, args, i, charset, options, output);
    }

    private void doView(String jar, String[] args, int i, String charset, int options, File output) {
        File path = new File(jar).getAbsoluteFile();
        File dir = path.getParentFile();
        if (dir == null) {
            dir = new File("");
        }
        if (!dir.exists()) {
            this.error("No such file: " + dir.getAbsolutePath());
            return;
        }
        String name = path.getName();
        if (name == null) {
            name = "META-INF/MANIFEST.MF";
        }
        Instruction instruction = Instruction.getPattern(path.getName());
        File[] children = dir.listFiles();
        int j = 0;
        while (j < children.length) {
            String base = children[j].getName();
            if (instruction.matches(base) ^ instruction.isNegated()) {
                while (i < args.length) {
                    this.doView(children[j], args[i], charset, options, output);
                    ++i;
                }
            }
            ++j;
        }
    }

    private void doView(File file, String resource, String charset, int options, File output) {
        try {
            Instruction instruction = Instruction.getPattern(resource);
            FileInputStream fin = new FileInputStream(file);
            ZipInputStream in = new ZipInputStream(fin);
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (instruction.matches(entry.getName()) ^ instruction.isNegated()) {
                    this.doView(entry.getName(), in, charset, options, output);
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
            in.close();
            fin.close();
        }
        catch (Exception e) {
            this.out.println("Can not process: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void doView(String name, ZipInputStream in, String charset, int options, File output) throws Exception {
        int n = name.lastIndexOf(47);
        name = name.substring(n + 1);
        InputStreamReader rds = new InputStreamReader((InputStream)in, charset);
        OutputStreamWriter wrt = new OutputStreamWriter(this.out);
        if (output != null) {
            wrt = output.isDirectory() ? new FileWriter(new File(output, name)) : new FileWriter(output);
        }
        this.copy(rds, wrt);
        if (output != null) {
            wrt.close();
        } else {
            wrt.flush();
        }
    }

    private void copy(InputStreamReader rds, OutputStreamWriter wrt) throws IOException {
        char[] buffer = new char[1024];
        int size = rds.read(buffer);
        while (size > 0) {
            wrt.write(buffer, 0, size);
            size = rds.read(buffer);
        }
    }

    private void print(String msg, Map<String, Map<String, String>> ports) {
        if (ports.isEmpty()) {
            return;
        }
        this.out.println(msg);
        for (Map.Entry<String, Map<String, String>> entry : ports.entrySet()) {
            String key = entry.getKey();
            Map<String, String> clause = Create.copy(entry.getValue());
            clause.remove("uses:");
            this.format("  %-38s %s\r\n", key.trim(), clause.isEmpty() ? "" : clause.toString());
        }
    }

    private void format(String string, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            block0 : switch (c) {
                case '%': {
                    String s = "" + objects[index++];
                    int width = 0;
                    int justify = -1;
                    int n = ++i;
                    ++i;
                    c = string.charAt(n);
                    switch (c) {
                        case '-': {
                            justify = -1;
                            break;
                        }
                        case '+': {
                            justify = 1;
                            break;
                        }
                        case '|': {
                            justify = 0;
                            break;
                        }
                    }
                    int n2 = --i;
                    ++i;
                    c = string.charAt(n2);
                    while (c >= '0' && c <= '9') {
                        width *= 10;
                        width += c - 48;
                        c = string.charAt(i++);
                    }
                    if (c != 's') {
                        throw new IllegalArgumentException("Invalid sprintf format:  " + string);
                    }
                    if (s.length() > width) {
                        sb.append(s);
                        break;
                    }
                    switch (justify) {
                        case -1: {
                            sb.append(s);
                            int j = 0;
                            while (j < width - s.length()) {
                                sb.append(" ");
                                ++j;
                            }
                            break block0;
                        }
                        case 1: {
                            int j = 0;
                            while (j < width - s.length()) {
                                sb.append(" ");
                                ++j;
                            }
                            sb.append(s);
                            break;
                        }
                        case 0: {
                            int spaces = (width - s.length()) / 2;
                            int j = 0;
                            while (j < spaces) {
                                sb.append(" ");
                                ++j;
                            }
                            sb.append(s);
                            j = 0;
                            while (j < width - s.length() - spaces) {
                                sb.append(" ");
                                ++j;
                            }
                            break block8;
                        }
                    }
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        this.out.print(sb);
    }

    private void doWrap(String[] args, int i) throws Exception {
        int options = 0;
        File properties = null;
        File output = null;
        File[] classpath = null;
        while (i < args.length) {
            if ("-output".startsWith(args[i])) {
                output = new File(args[++i]);
            } else if ("-properties".startsWith(args[i])) {
                properties = new File(args[++i]);
            } else if ("-classpath".startsWith(args[i])) {
                classpath = this.getClasspath(args[++i]);
            } else {
                File bundle = new File(args[i]);
                this.doWrap(properties, bundle, output, classpath, options, null);
            }
            ++i;
        }
    }

    public boolean doWrap(File properties, File bundle, File output, File[] classpath, int options, Map<String, String> additional) throws Exception {
        if (!bundle.exists()) {
            this.error("No such file: " + bundle.getAbsolutePath());
            return false;
        }
        Analyzer analyzer = new Analyzer();
        try {
            String path;
            analyzer.setPedantic(this.isPedantic());
            analyzer.setJar(bundle);
            Jar dot = analyzer.getJar();
            if (properties != null) {
                analyzer.setProperties(properties);
            }
            if (additional != null) {
                analyzer.putAll(additional, false);
            }
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                String base = bundle.getName();
                Matcher m = p.matcher(base);
                base = "Untitled";
                if (m.matches()) {
                    base = m.group(1);
                } else {
                    this.error("Can not calculate name of output bundle, rename jar or use -properties");
                }
                analyzer.setProperty("Bundle-SymbolicName", base);
            }
            if (analyzer.getProperty("Export-Package") == null) {
                String export = analyzer.calculateExportsFromContents(dot);
                analyzer.setProperty("Export-Package", export);
            }
            if (classpath != null) {
                analyzer.setClasspath(classpath);
            }
            analyzer.mergeManifest(dot.getManifest());
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Builder.cleanupVersion(version);
                analyzer.setProperty("Bundle-Version", version);
            }
            if (output == null) {
                output = properties != null ? properties.getAbsoluteFile().getParentFile() : bundle.getAbsoluteFile().getParentFile();
            }
            path = (path = bundle.getName()).endsWith(".jar") ? String.valueOf(path.substring(0, path.length() - ".jar".length())) + ".bar" : String.valueOf(bundle.getName()) + ".bar";
            if (output.isDirectory()) {
                output = new File(output, path);
            }
            analyzer.calcManifest();
            Jar jar = analyzer.getJar();
            this.getInfo(analyzer);
            this.statistics(jar, output, "");
            File f = File.createTempFile("tmpbnd", ".jar");
            jar.write(f);
            jar.close();
            if (!f.renameTo(output)) {
                this.copy(f, output);
                f.deleteOnExit();
            }
            boolean bl = this.getErrors().size() == 0;
            return bl;
        }
        finally {
            analyzer.close();
        }
    }

    private void doRepo(String[] args, int first) throws Exception {
        RepoDeployer repo = new RepoDeployer();
        int i = first;
        while (i < args.length) {
            if ("-repo".equals(args[i])) {
                repo.setRepo(this.getFile(args[++i]));
            } else if (!args[i].startsWith("-list")) {
                if (args[i].startsWith("-bsn")) {
                    repo.setBsn(args[++i]);
                } else if (args[i].startsWith("-version")) {
                    repo.setVersion(args[++i]);
                } else if (args[i].startsWith("-")) {
                    this.error("Unknown option for release: " + args[i]);
                } else {
                    File file = this.getFile(args[i]);
                    if (!file.exists()) {
                        file = new File(args[i]);
                    }
                    if (file.exists()) {
                        try {
                            repo.setFile(file);
                            repo.deploy();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.error("Can not deploy " + file, e);
                        }
                    } else {
                        this.error("No such file " + file);
                    }
                }
            }
            ++i;
        }
    }

    void doDiff(String[] args, int first) throws IOException {
        Jar jar;
        File base = new File("");
        boolean strict = false;
        Jar[] targets = new Jar[2];
        int n = 0;
        int i = first;
        while (i < args.length) {
            if ("-d".equals(args[i])) {
                base = bnd.getFile(base, args[++i]);
            } else if ("-strict".equals(args[i])) {
                strict = "true".equalsIgnoreCase(args[++i]);
            } else if (args[i].startsWith("-")) {
                this.error("Unknown option for release: " + args[i]);
            } else {
                System.out.println("x " + args[i] + " " + n);
                if (n >= 2) {
                    System.err.println("Must have 2 files ... not more");
                } else {
                    File f = bnd.getFile(base, args[i]);
                    if (!f.isFile()) {
                        System.err.println("Not a file: " + f);
                    } else {
                        try {
                            jar = new Jar(f);
                            targets[n++] = jar;
                        }
                        catch (Exception e) {
                            System.err.println("Not a JAR file: " + f);
                        }
                    }
                }
            }
            ++i;
        }
        if (n != 2) {
            System.err.println("Must have 2 files ...");
            return;
        }
        Diff diff = new Diff();
        Map<String, Object> map = diff.diff(targets[0], targets[1], strict);
        diff.print(System.out, map, 0);
        Jar[] jarArray = targets;
        int n2 = targets.length;
        int n3 = 0;
        while (n3 < n2) {
            jar = jarArray[n3];
            jar.close();
            ++n3;
        }
        diff.close();
    }

    void copy(File a, File b) {
        try {
            FileInputStream in = new FileInputStream(a);
            FileOutputStream out = new FileOutputStream(b);
            byte[] buffer = new byte[8196];
            int size = ((InputStream)in).read(buffer);
            while (size > 0) {
                ((OutputStream)out).write(buffer, 0, size);
                size = ((InputStream)in).read(buffer);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.error("While copying the output file: " + a + "->" + b);
        }
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void test(String[] args, int i) throws Exception {
        Project project = this.getProject();
        project.test();
        this.getInfo(project);
    }

    public Project getProject() throws Exception {
        if (this.project != null) {
            return this.project;
        }
        this.project = Workspace.getProject(this.getBase());
        if (!this.project.isValid()) {
            throw new IllegalArgumentException("The base directory " + this.getBase() + " is not a project directory ");
        }
        return this.project;
    }

    public void debug(String[] args, int i) throws Exception {
        Project project = this.getProject();
        Properties p = project.getFlattenedProperties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String s = (String)entry.getValue();
            Collection<String> l = null;
            if (s.indexOf(44) > 0) {
                l = bnd.split(s);
            } else if (s.indexOf(58) > 0) {
                l = bnd.split(s, "\\s*:\\s*");
            }
            if (l != null) {
                String del = (String)entry.getKey();
                for (String ss : l) {
                    System.out.printf("%-40s %s\n", del, ss);
                    del = "";
                }
                continue;
            }
            System.out.printf("%-40s %s\n", entry.getKey(), entry.getValue());
        }
    }
}

