/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.server.ClusteredObjectView;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.ServerView;
import org.ow2.cmi.controller.server.filter.IFilter;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClusterView
implements Serializable {
    private static final long serialVersionUID = -5710461778454543508L;
    private final Map<String, ClusteredObjectView> clusteredObjectsViews = new HashMap<String, ClusteredObjectView>();
    private final Map<String, ServerView> serverViews = new HashMap<String, ServerView>();
    private final List<IFilter> filters = Collections.synchronizedList(new ArrayList());
    private int delayToRefresh;

    public void clear() {
        this.clusteredObjectsViews.clear();
        this.filters.clear();
        this.delayToRefresh = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObject(String objectName) {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            return this.clusteredObjectsViews.containsKey(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedObjectInfo getObjectInfo(String objectName) throws ObjectNotFoundException {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            ClusteredObjectView clusteredObjectView = this.clusteredObjectsViews.get(objectName);
            if (clusteredObjectView == null) {
                throw new ObjectNotFoundException("Cannot get object infos", objectName);
            }
            return clusteredObjectView.getObjectInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            ClusteredObjectView clusteredObjectView = this.clusteredObjectsViews.get(objectName);
            if (clusteredObjectView == null) {
                throw new ObjectNotFoundException("Cannot get CMI references", objectName);
            }
            return clusteredObjectView.getCMIReferences(protocolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CMIReference> getCMIReferences(String objectName) throws ObjectNotFoundException {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            ClusteredObjectView clusteredObjectView = this.clusteredObjectsViews.get(objectName);
            if (clusteredObjectView == null) {
                throw new ObjectNotFoundException("Cannot get CMI references", objectName);
            }
            return clusteredObjectView.getCMIReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getObjectNames() {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            return new HashSet<String>(this.clusteredObjectsViews.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedObjectInfo addObjectInfo(DistributedObjectInfo distributedObjectInfo, boolean override) {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            ClusteredObjectView clusteredObjectView = this.clusteredObjectsViews.get(distributedObjectInfo.getObjectName());
            if (clusteredObjectView == null) {
                clusteredObjectView = new ClusteredObjectView();
                clusteredObjectView.setObjectInfo(distributedObjectInfo);
                this.clusteredObjectsViews.put(distributedObjectInfo.getObjectName(), clusteredObjectView);
            } else if (override) {
                DistributedObjectInfo oldDistributedObjectInfo = clusteredObjectView.getObjectInfo();
                if (!oldDistributedObjectInfo.equals(distributedObjectInfo)) {
                    clusteredObjectView.setObjectInfo(distributedObjectInfo);
                }
                return oldDistributedObjectInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCMIReference(CMIReference cmiReference) {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            ClusteredObjectView clusteredObjectView = this.clusteredObjectsViews.get(cmiReference.getObjectName());
            if (clusteredObjectView == null) {
                clusteredObjectView = new ClusteredObjectView();
                this.clusteredObjectsViews.put(cmiReference.getObjectName(), clusteredObjectView);
            }
            clusteredObjectView.addCMIReference(cmiReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCMIReference(CMIReference cmiReference) throws ObjectNotFoundException {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            ClusteredObjectView clusteredObjectView = this.clusteredObjectsViews.get(cmiReference.getObjectName());
            if (clusteredObjectView == null) {
                throw new ObjectNotFoundException("Cannot get CMI references", cmiReference.getObjectName());
            }
            return clusteredObjectView.removeCMIReference(cmiReference);
        }
    }

    public void setDelay(int delay) {
        this.delayToRefresh = delay;
    }

    public int getDelay() {
        return this.delayToRefresh;
    }

    public List<IFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void addFilter(IFilter filter) {
        this.filters.add(filter);
    }

    public boolean removeFilter(IFilter filter) {
        return this.filters.remove(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addServerToBlackList(ServerRef serverRef) {
        boolean blacklisted = false;
        Map<String, ServerView> map = this.serverViews;
        synchronized (map) {
            ServerView serverView = this.serverViews.get(serverRef.getProviderURL());
            if (serverView == null) {
                serverView = new ServerView();
                this.serverViews.put(serverRef.getProviderURL(), serverView);
            } else {
                blacklisted = serverView.isBlacklisted();
            }
            if (!blacklisted) {
                serverView.setBlacklisted(true);
            }
        }
        return blacklisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerBlackListed(ServerRef serverRef) {
        Map<String, ServerView> map = this.serverViews;
        synchronized (map) {
            ServerView serverView = this.serverViews.get(serverRef.getProviderURL());
            if (serverView == null) {
                return false;
            }
            return serverView.isBlacklisted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerFromBlackList(ServerRef serverRef) throws ServerNotFoundException {
        boolean blacklisted = false;
        Map<String, ServerView> map = this.serverViews;
        synchronized (map) {
            ServerView serverView = this.serverViews.get(serverRef.getProviderURL());
            if (serverView == null) {
                throw new ServerNotFoundException("Cannot remove from the blacklist an unkwnown server", serverRef);
            }
            blacklisted = serverView.isBlacklisted();
            if (blacklisted) {
                serverView.setBlacklisted(false);
            }
        }
        return blacklisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusterNames() {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            HashSet<String> clusterNames = new HashSet<String>();
            for (String objectName : this.clusteredObjectsViews.keySet()) {
                clusterNames.add(this.clusteredObjectsViews.get(objectName).getObjectInfo().getClusterName());
            }
            return clusterNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getObjectNames(String clusterName) {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            HashSet<String> objectNames = new HashSet<String>();
            for (String objectName : this.clusteredObjectsViews.keySet()) {
                if (!this.clusteredObjectsViews.get(objectName).getObjectInfo().getClusterName().equals(clusterName)) continue;
                objectNames.add(objectName);
            }
            return objectNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLoadFactor(ServerRef serverRef, int loadFactor) {
        int oldLoadFactor;
        Map<String, ServerView> map = this.serverViews;
        synchronized (map) {
            ServerView serverView = this.serverViews.get(serverRef.getProviderURL());
            if (serverView == null) {
                serverView = new ServerView();
                this.serverViews.put(serverRef.getProviderURL(), serverView);
                oldLoadFactor = -1;
            } else {
                oldLoadFactor = serverView.getLoadFactor();
            }
            if (oldLoadFactor != loadFactor) {
                serverView.setLoadFactor(loadFactor);
            }
        }
        return oldLoadFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoadFactor(ServerRef serverRef) throws ServerNotFoundException {
        Map<String, ServerView> map = this.serverViews;
        synchronized (map) {
            ServerView serverView = this.serverViews.get(serverRef.getProviderURL());
            if (serverView == null) {
                throw new ServerNotFoundException("Cannot remove from the blacklist an unkwnown server", serverRef);
            }
            return serverView.getLoadFactor();
        }
    }

    public Map<String, ? extends ServerView> getServerViews() {
        return this.serverViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusteredObjects(String providerURL) {
        Map<String, ClusteredObjectView> map = this.clusteredObjectsViews;
        synchronized (map) {
            for (ClusteredObjectView clusteredObjectView : this.clusteredObjectsViews.values()) {
                clusteredObjectView.removeServerRef(providerURL);
            }
        }
    }
}

