/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha.interceptor.jrmp;

import java.io.IOException;
import java.util.Stack;
import org.ow2.carol.rmi.interceptor.api.JServerRequestInfo;
import org.ow2.carol.rmi.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.interceptor.spi.JServiceContext;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.ha.interceptor.jrmp.HAServiceContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HAServerInterceptor
implements JServerRequestInterceptor {
    private String interceptorName = "HAServerInterceptor";
    private static Log logger = LogFactory.getLog(HAServerInterceptor.class);

    public String name() {
        return this.interceptorName;
    }

    public void receiveRequest(JServerRequestInfo jri) throws IOException {
        HAServiceContext receivedCtx = (HAServiceContext)jri.getRequestServiceContext(HAServiceContext.HA_CTX_ID);
        if (receivedCtx == null) {
            return;
        }
        logger.debug((Object)receivedCtx.toString(), new Object[0]);
        HACurrent current = HACurrent.getHACurrent();
        HAContext haContext = (HAContext)receivedCtx.getContextData();
        Stack<RequestId> requests = haContext.getRequests();
        current.setRequests(requests);
        boolean onFailover = haContext.isOnFailover();
        current.setOnFailover(onFailover);
        logger.debug((Object)"HACtx asocciated to Thread", new Object[0]);
    }

    public void sendReply(JServerRequestInfo jri) throws IOException {
        this.putHAContext(jri);
    }

    public void sendException(JServerRequestInfo jri) throws IOException {
        this.putHAContext(jri);
    }

    public void sendOther(JServerRequestInfo jri) throws IOException {
        this.putHAContext(jri);
    }

    private void putHAContext(JServerRequestInfo jri) {
        HACurrent current = HACurrent.getHACurrent();
        HAContext haContext = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        haContext.setRequests(requests);
        logger.debug((Object)("newHACtx: " + haContext), new Object[0]);
        HAServiceContext haServiceContext = new HAServiceContext(haContext);
        jri.addReplyServiceContext((JServiceContext)haServiceContext);
    }
}

